/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Covers;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsSubsuming;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Operator;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspector;

public class ComparableConditionInspector<T extends Comparable<T>>
extends ConditionInspector
implements Covers<T> {
    protected final Operator operator;
    protected final T value;

    public ComparableConditionInspector(Pattern52 pattern, String factField, T value, String operator) {
        super(pattern, factField);
        this.operator = Operator.resolve(operator);
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public boolean conflicts(Object other) {
        if (other instanceof ComparableConditionInspector) {
            switch (((ComparableConditionInspector)other).getOperator()) {
                case NOT_EQUALS: {
                    switch (this.operator) {
                        case NOT_EQUALS: {
                            return false;
                        }
                    }
                }
            }
            boolean overlaps = this.overlaps(other);
            boolean overlapsNOT = !overlaps;
            return overlapsNOT;
        }
        return false;
    }

    @Override
    public boolean isRedundant(Object object) {
        if (object instanceof IsSubsuming) {
            return this.subsumes(object) && ((IsSubsuming)object).subsumes(this);
        }
        return false;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public boolean overlaps(Object other) {
        ComparableConditionInspector anotherPoint;
        if (other instanceof ComparableConditionInspector && (anotherPoint = (ComparableConditionInspector)other) != null) {
            switch (anotherPoint.getOperator()) {
                case NOT_EQUALS: {
                    switch (this.operator) {
                        case EQUALS: {
                            return !this.getValue().equals(anotherPoint.getValue());
                        }
                    }
                    return true;
                }
                case EQUALS: {
                    switch (this.operator) {
                        case NOT_EQUALS: {
                            return !this.getValue().equals(anotherPoint.getValue());
                        }
                    }
                    return this.covers((Comparable<T>)anotherPoint.getValue());
                }
                case GREATER_OR_EQUAL: {
                    switch (this.operator) {
                        case NOT_EQUALS: {
                            return true;
                        }
                        case LESS_THAN: 
                        case BEFORE: {
                            return anotherPoint.covers((Comparable<T>)this.getValue()) && this.covers((Comparable<T>)anotherPoint.getValue());
                        }
                    }
                    return this.covers((Comparable<T>)anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue());
                }
                case LESS_OR_EQUAL: {
                    switch (this.operator) {
                        case NOT_EQUALS: {
                            return true;
                        }
                        case GREATER_THAN: 
                        case AFTER: {
                            return anotherPoint.covers((Comparable<T>)this.getValue()) && this.covers((Comparable<T>)anotherPoint.getValue());
                        }
                    }
                    return this.covers((Comparable<T>)anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue());
                }
                case LESS_THAN: 
                case BEFORE: {
                    switch (this.operator) {
                        case EQUALS: {
                            return anotherPoint.covers((Comparable<T>)this.getValue());
                        }
                        case NOT_EQUALS: {
                            return true;
                        }
                        case LESS_THAN: 
                        case BEFORE: {
                            return this.valueIsEqualTo((Comparable<T>)anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue()) || this.covers((Comparable<T>)anotherPoint.getValue());
                        }
                        case GREATER_OR_EQUAL: {
                            return anotherPoint.covers((Comparable<T>)this.getValue()) && this.covers((Comparable<T>)anotherPoint.getValue());
                        }
                    }
                    return this.covers((Comparable<T>)anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue());
                }
                case GREATER_THAN: 
                case AFTER: {
                    switch (this.operator) {
                        case EQUALS: {
                            return anotherPoint.covers((Comparable<T>)this.getValue());
                        }
                        case NOT_EQUALS: {
                            return true;
                        }
                        case GREATER_THAN: 
                        case AFTER: {
                            return this.valueIsEqualTo((Comparable<T>)anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue()) || this.covers((Comparable<T>)anotherPoint.getValue());
                        }
                        case LESS_OR_EQUAL: {
                            return anotherPoint.covers((Comparable<T>)this.getValue()) && this.covers((Comparable<T>)anotherPoint.getValue());
                        }
                    }
                    return this.covers((Comparable<T>)anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue());
                }
                case IN: {
                    return anotherPoint.covers((Comparable<T>)this.getValue());
                }
                case NOT_IN: {
                    boolean b = anotherPoint.covers((Comparable<T>)this.getValue());
                    return b;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean subsumes(Object other) {
        ComparableConditionInspector anotherPoint;
        if (other instanceof ComparableConditionInspector && (anotherPoint = (ComparableConditionInspector)other) != null) {
            switch (anotherPoint.getOperator()) {
                case NOT_EQUALS: {
                    switch (this.operator) {
                        case NOT_EQUALS: {
                            return this.getValue().equals(anotherPoint.getValue());
                        }
                        case EQUALS: {
                            boolean valueIsEqualTo = this.valueIsEqualTo((Comparable<T>)anotherPoint.getValue());
                            boolean covers = this.covers((Comparable<T>)anotherPoint.getValue());
                            return !valueIsEqualTo && !covers;
                        }
                    }
                    return false;
                }
                case EQUALS: {
                    switch (this.operator) {
                        case NOT_EQUALS: {
                            boolean valueIsEqualTo = this.valueIsEqualTo((Comparable<T>)anotherPoint.getValue());
                            boolean covers = this.covers((Comparable<T>)anotherPoint.getValue());
                            return !valueIsEqualTo && !covers;
                        }
                    }
                    return this.covers((Comparable<T>)anotherPoint.getValue());
                }
                case GREATER_OR_EQUAL: {
                    switch (this.operator) {
                        case GREATER_THAN: 
                        case GREATER_OR_EQUAL: {
                            return this.covers((Comparable<T>)anotherPoint.getValue());
                        }
                        case NOT_EQUALS: {
                            return this.valueIsGreaterThan((Comparable<T>)anotherPoint.getValue());
                        }
                    }
                    return false;
                }
                case LESS_OR_EQUAL: {
                    switch (this.operator) {
                        case LESS_THAN: 
                        case LESS_OR_EQUAL: {
                            return this.covers((Comparable<T>)anotherPoint.getValue());
                        }
                        case NOT_EQUALS: {
                            return this.valueIsLessThan((Comparable<T>)anotherPoint.getValue());
                        }
                    }
                    return false;
                }
                case LESS_THAN: {
                    switch (this.operator) {
                        case LESS_OR_EQUAL: {
                            return this.covers((Comparable<T>)anotherPoint.getValue());
                        }
                        case NOT_EQUALS: 
                        case LESS_THAN: {
                            return this.valueIsLessThanOrEqualTo((Comparable<T>)anotherPoint.getValue());
                        }
                    }
                    return false;
                }
                case GREATER_THAN: {
                    switch (this.operator) {
                        case GREATER_OR_EQUAL: {
                            return this.covers((Comparable<T>)anotherPoint.getValue());
                        }
                        case NOT_EQUALS: 
                        case GREATER_THAN: {
                            return this.valueIsGreaterThanOrEqualTo((Comparable<T>)anotherPoint.getValue());
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean covers(Comparable<T> otherValue) {
        if (otherValue instanceof Comparable) {
            switch (this.operator) {
                case EQUALS: {
                    return this.valueIsEqualTo(otherValue);
                }
                case NOT_EQUALS: {
                    return !this.valueIsEqualTo(otherValue);
                }
                case GREATER_OR_EQUAL: {
                    return this.valueIsGreaterThanOrEqualTo(otherValue);
                }
                case LESS_OR_EQUAL: {
                    return this.valueIsLessThanOrEqualTo(otherValue);
                }
                case LESS_THAN: 
                case BEFORE: {
                    return this.valueIsLessThan(otherValue);
                }
                case GREATER_THAN: 
                case AFTER: {
                    return this.valueIsGreaterThan(otherValue);
                }
            }
            return false;
        }
        return false;
    }

    protected boolean valueIsGreaterThanOrEqualTo(Comparable<T> otherValue) {
        return this.valueIsEqualTo(otherValue) || this.valueIsGreaterThan(otherValue);
    }

    protected boolean valueIsLessThanOrEqualTo(Comparable<T> otherValue) {
        return this.valueIsEqualTo(otherValue) || this.valueIsLessThan(otherValue);
    }

    protected boolean valueIsGreaterThan(Comparable<T> otherValue) {
        return otherValue.compareTo(this.getValue()) > 0;
    }

    protected boolean valueIsLessThan(Comparable<T> otherValue) {
        return otherValue.compareTo(this.getValue()) < 0;
    }

    protected boolean valueIsEqualTo(Comparable<T> otherValue) {
        return otherValue.compareTo(this.getValue()) == 0;
    }

    @Override
    public String toHumanReadableString() {
        return this.getFactField() + " " + (Object)((Object)this.operator) + " " + this.getValue();
    }
}

