/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import java.util.Iterator;
import java.util.Set;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;
import org.gwtbootstrap3.client.ui.constants.IconType;

public class AnalysisLineCell
extends AbstractCell<Issue> {
    private static final CellTemplate TEMPLATE = (CellTemplate)GWT.create(CellTemplate.class);

    public AnalysisLineCell() {
        super(new String[0]);
    }

    public void render(Cell.Context context, Issue issue, SafeHtmlBuilder safeHtmlBuilder) {
        safeHtmlBuilder.append(TEMPLATE.text(this.getImage(issue.getSeverity()), this.getLineNumbers(issue.getRowNumbers()), issue.getTitle()));
    }

    private SafeHtml getLineNumbers(final Set<Integer> rowNumbers) {
        return new SafeHtml(){

            public String asString() {
                StringBuilder builder = new StringBuilder();
                Iterator iterator = rowNumbers.iterator();
                while (iterator.hasNext()) {
                    builder.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    builder.append(", ");
                }
                return builder.toString();
            }
        };
    }

    private String getImage(Severity severity) {
        switch (severity) {
            case ERROR: {
                return IconType.REMOVE.getCssName();
            }
            case WARNING: {
                return IconType.QUESTION.getCssName();
            }
        }
        return IconType.INFO.getCssName();
    }

    static interface CellTemplate
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<span><i class=\"fa {0}\" ></i><span> - {1} - {2}</span></span>")
        public SafeHtml text(String var1, SafeHtml var2, String var3);
    }
}

