/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Explanation;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class Issue
implements Comparable<Issue> {
    private final Severity severity;
    private final TreeSet<Integer> rowNumbers = new TreeSet();
    private final String title;
    private final Explanation explanation = new Explanation();

    public Issue(Severity severity, String title, Integer ... rowNumbers) {
        this.severity = severity;
        this.title = title;
        this.rowNumbers.addAll(Arrays.asList(rowNumbers));
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Set<Integer> getRowNumbers() {
        return this.rowNumbers;
    }

    public String getTitle() {
        return this.title;
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    public String toString() {
        return this.title;
    }

    @Override
    public int compareTo(Issue issue) {
        int compareToSeverity = this.severity.compareTo(issue.getSeverity());
        if (compareToSeverity == 0) {
            int compareToTitle = this.title.compareTo(issue.getTitle());
            if (compareToTitle == 0) {
                return this.compareRowNumbers(issue.getRowNumbers());
            }
            return compareToTitle;
        }
        return compareToSeverity;
    }

    private int compareRowNumbers(Set<Integer> rowNumbers) {
        if (this.rowNumbers.equals(rowNumbers)) {
            return 0;
        }
        for (Integer a : this.rowNumbers) {
            for (Integer b : rowNumbers) {
                if (a >= b) continue;
                return -1;
            }
        }
        return 1;
    }
}

