/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.auditlog;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.auditlog.AuditLogEntry;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.guided.dtable.shared.auditlog.ActionInsertFactColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.ActionSetFieldColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.ActionWorkItemColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.ActionWorkItemInsertFactColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.ActionWorkItemSetFieldColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.AttributeColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.ColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.ConditionColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.DecisionTableAuditEvents;
import org.drools.workbench.models.guided.dtable.shared.auditlog.DeleteColumnAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.DeleteRowAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.InsertColumnAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.InsertRowAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.LimitedEntryActionInsertFactColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.LimitedEntryActionSetFieldColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.LimitedEntryConditionColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.MetadataColumnDetails;
import org.drools.workbench.models.guided.dtable.shared.auditlog.UpdateColumnAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.WorkItemColumnParameterValueDiffImpl;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;

public class AuditLogEntryCellHelper {
    private static final String QUOTE = "'";
    private static final Template TEMPLATE = (Template)GWT.create(Template.class);
    private final DateTimeFormat format;
    private String labelClass = null;
    private String valueClass = null;

    public AuditLogEntryCellHelper(DateTimeFormat format) {
        this.format = format;
    }

    public AuditLogEntryCellHelper(DateTimeFormat format, String labelClass, String valueClass) {
        this.format = format;
        this.labelClass = labelClass;
        this.valueClass = valueClass;
    }

    public static String getEventTypeDisplayText(String eventType) {
        if (eventType.equals(DecisionTableAuditEvents.INSERT_COLUMN.name())) {
            return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogEventInsertColumn();
        }
        if (eventType.equals(DecisionTableAuditEvents.INSERT_ROW.name())) {
            return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogEventInsertRow();
        }
        if (eventType.equals(DecisionTableAuditEvents.UPDATE_COLUMN.name())) {
            return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogEventUpdateColumn();
        }
        if (eventType.equals(DecisionTableAuditEvents.DELETE_COLUMN.name())) {
            return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogEventDeleteColumn();
        }
        if (eventType.equals(DecisionTableAuditEvents.DELETE_ROW.name())) {
            return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogEventDeleteRow();
        }
        throw new IllegalArgumentException("Unrecognised AuditLogEntry type.");
    }

    public SafeHtml getSafeHtml(AuditLogEntry event) {
        if (event instanceof UpdateColumnAuditLogEntry) {
            return this.getSafeHtml((UpdateColumnAuditLogEntry)event);
        }
        if (event instanceof InsertColumnAuditLogEntry) {
            return this.getSafeHtml((InsertColumnAuditLogEntry)event);
        }
        if (event instanceof DeleteColumnAuditLogEntry) {
            return this.getSafeHtml((DeleteColumnAuditLogEntry)event);
        }
        if (event instanceof InsertRowAuditLogEntry) {
            return this.getSafeHtml((InsertRowAuditLogEntry)event);
        }
        if (event instanceof DeleteRowAuditLogEntry) {
            return this.getSafeHtml((DeleteRowAuditLogEntry)event);
        }
        throw new IllegalArgumentException("Unrecognised AuditLogEntry type.");
    }

    private SafeHtml getSafeHtml(InsertRowAuditLogEntry event) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertRowAt0(event.getRowIndex() + 1)));
        return sb.toSafeHtml();
    }

    private SafeHtml getSafeHtml(DeleteRowAuditLogEntry event) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogDeleteRowAt0(event.getRowIndex() + 1)));
        return sb.toSafeHtml();
    }

    private SafeHtml getSafeHtml(InsertColumnAuditLogEntry event) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        this.buildColumnDetailsInsert(event.getDetails(), sb);
        return sb.toSafeHtml();
    }

    private SafeHtml getSafeHtml(UpdateColumnAuditLogEntry event) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        this.buildColumnDetailsUpdate(event.getDetails(), event.getOriginalDetails(), (List<BaseColumnFieldDiff>)event.getDiffs(), sb);
        return sb.toSafeHtml();
    }

    private SafeHtml getSafeHtml(DeleteColumnAuditLogEntry event) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogDeleteColumn0(event.getColumnHeader())));
        return sb.toSafeHtml();
    }

    private void buildColumnDetailsInsert(ColumnDetails details, SafeHtmlBuilder sb) {
        if (details instanceof AttributeColumnDetails) {
            this.buildColumnDetailsInsert((AttributeColumnDetails)details, sb);
        } else if (details instanceof MetadataColumnDetails) {
            this.buildColumnDetailsInsert((MetadataColumnDetails)details, sb);
        } else if (details instanceof ConditionColumnDetails) {
            this.buildColumnDetailsInsert((ConditionColumnDetails)details, sb);
        } else if (details instanceof LimitedEntryConditionColumnDetails) {
            this.buildColumnDetailsInsert((LimitedEntryConditionColumnDetails)details, sb);
        } else if (details instanceof ActionInsertFactColumnDetails) {
            this.buildColumnDetailsInsert((ActionInsertFactColumnDetails)details, sb);
        } else if (details instanceof LimitedEntryActionInsertFactColumnDetails) {
            this.buildColumnDetailsInsert((LimitedEntryActionInsertFactColumnDetails)details, sb);
        } else if (details instanceof ActionSetFieldColumnDetails) {
            this.buildColumnDetailsInsert((ActionSetFieldColumnDetails)details, sb);
        } else if (details instanceof LimitedEntryActionSetFieldColumnDetails) {
            this.buildColumnDetailsInsert((LimitedEntryActionSetFieldColumnDetails)details, sb);
        } else if (details instanceof ActionWorkItemColumnDetails) {
            this.buildColumnDetailsInsert((ActionWorkItemColumnDetails)details, sb);
        } else if (details instanceof ActionWorkItemInsertFactColumnDetails) {
            this.buildColumnDetailsInsert((ActionWorkItemInsertFactColumnDetails)details, sb);
        } else if (details instanceof ActionWorkItemSetFieldColumnDetails) {
            this.buildColumnDetailsInsert((ActionWorkItemSetFieldColumnDetails)details, sb);
        } else {
            sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertColumn0(details.getColumnHeader())));
        }
    }

    private void buildColumnDetailsInsert(AttributeColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertAttribute0(details.getAttribute())));
    }

    private void buildColumnDetailsInsert(MetadataColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertMetadata0(details.getMetadata())));
    }

    private void buildColumnDetailsInsert(ConditionColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader2Details(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertCondition0(details.getColumnHeader()), GuidedDecisionTableConstants.INSTANCE.Field() + ":", this.nil(details.getFactField()), GuidedDecisionTableConstants.INSTANCE.Operator() + ":", this.nil(details.getOperator()), this.labelClass, this.valueClass));
    }

    private void buildColumnDetailsInsert(LimitedEntryConditionColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader3Details(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertCondition0(details.getColumnHeader()), GuidedDecisionTableConstants.INSTANCE.Field() + ":", this.nil(details.getFactField()), GuidedDecisionTableConstants.INSTANCE.Operator() + ":", this.nil(details.getOperator()), GuidedDecisionTableConstants.INSTANCE.Value() + ":", this.nilLimitedEntryValue(details.getValue()), this.labelClass, this.valueClass));
    }

    private void buildColumnDetailsInsert(ActionInsertFactColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader2Details(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertActionInsertFact0(details.getColumnHeader()), GuidedDecisionTableConstants.INSTANCE.FactType() + ":", this.nil(details.getFactType()), GuidedDecisionTableConstants.INSTANCE.Field() + ":", this.nil(details.getFactField()), this.labelClass, this.valueClass));
    }

    private void buildColumnDetailsInsert(LimitedEntryActionInsertFactColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader3Details(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertActionInsertFact0(details.getColumnHeader()), GuidedDecisionTableConstants.INSTANCE.FactType() + ":", this.nil(details.getFactType()), GuidedDecisionTableConstants.INSTANCE.Field() + ":", this.nil(details.getFactField()), GuidedDecisionTableConstants.INSTANCE.Value() + ":", this.nilLimitedEntryValue(details.getValue()), this.labelClass, this.valueClass));
    }

    private void buildColumnDetailsInsert(ActionSetFieldColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader2Details(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertActionSetField0(details.getColumnHeader()), GuidedDecisionTableConstants.INSTANCE.BoundVariable() + ":", this.nil(details.getBoundName()), GuidedDecisionTableConstants.INSTANCE.Field() + ":", this.nil(details.getFactField()), this.labelClass, this.valueClass));
    }

    private void buildColumnDetailsInsert(LimitedEntryActionSetFieldColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader3Details(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertActionSetField0(details.getColumnHeader()), GuidedDecisionTableConstants.INSTANCE.BoundVariable() + ":", this.nil(details.getBoundName()), GuidedDecisionTableConstants.INSTANCE.Field() + ":", this.nil(details.getFactField()), GuidedDecisionTableConstants.INSTANCE.Value() + ":", this.nilLimitedEntryValue(details.getValue()), this.labelClass, this.valueClass));
    }

    private void buildColumnDetailsInsert(ActionWorkItemColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertWorkItemExecuteColumn0(details.getColumnHeader())));
        if (details.getParameters().size() > 0) {
            sb.append(SafeHtmlUtils.fromTrustedString((String)"<table>"));
            sb.append(TEMPLATE.commentRow(this.nil(GuidedDecisionTableConstants.INSTANCE.WorkItemNameColon()), this.nil(details.getName()), this.labelClass, this.valueClass));
            for (Map.Entry e : details.getParameters().entrySet()) {
                sb.append(TEMPLATE.commentRow(this.nil((String)e.getKey()) + ":", this.nil((PortableParameterDefinition)e.getValue()), this.labelClass, this.valueClass));
            }
            sb.append(SafeHtmlUtils.fromTrustedString((String)"</table>"));
        }
    }

    private void buildColumnDetailsInsert(ActionWorkItemInsertFactColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader4Details(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertWorkItemInsertFactColumn0(details.getColumnHeader()), GuidedDecisionTableConstants.INSTANCE.FactType() + ":", this.nil(details.getFactType()), GuidedDecisionTableConstants.INSTANCE.Field() + ":", this.nil(details.getFactField()), GuidedDecisionTableConstants.INSTANCE.WorkItemNameColon(), this.nil(details.getWorkItemName()), GuidedDecisionTableConstants.INSTANCE.WorkItemParameterNameColon(), this.nil(details.getWorkItemResultParameterName()), this.labelClass, this.valueClass));
    }

    private void buildColumnDetailsInsert(ActionWorkItemSetFieldColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader4Details(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogInsertWorkItemSetFieldColumn0(details.getColumnHeader()), GuidedDecisionTableConstants.INSTANCE.BoundVariable() + ":", this.nil(details.getBoundName()), GuidedDecisionTableConstants.INSTANCE.Field() + ":", this.nil(details.getFactField()), GuidedDecisionTableConstants.INSTANCE.WorkItemNameColon(), this.nil(details.getWorkItemName()), GuidedDecisionTableConstants.INSTANCE.WorkItemParameterNameColon(), this.nil(details.getWorkItemResultParameterName()), this.labelClass, this.valueClass));
    }

    private void buildColumnDetailsUpdate(ColumnDetails details, ColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        if (details instanceof ConditionColumnDetails && originalDetails instanceof ConditionColumnDetails) {
            this.buildColumnDetailsUpdate((ConditionColumnDetails)details, (ConditionColumnDetails)originalDetails, diffs, sb);
        } else if (details instanceof LimitedEntryConditionColumnDetails && originalDetails instanceof LimitedEntryConditionColumnDetails) {
            this.buildColumnDetailsUpdate((LimitedEntryConditionColumnDetails)details, (LimitedEntryConditionColumnDetails)originalDetails, diffs, sb);
        } else if (details instanceof ActionInsertFactColumnDetails && originalDetails instanceof ActionInsertFactColumnDetails) {
            this.buildColumnDetailsUpdate((ActionInsertFactColumnDetails)details, (ActionInsertFactColumnDetails)originalDetails, diffs, sb);
        } else if (details instanceof LimitedEntryActionInsertFactColumnDetails && originalDetails instanceof LimitedEntryActionInsertFactColumnDetails) {
            this.buildColumnDetailsUpdate((LimitedEntryActionInsertFactColumnDetails)details, (LimitedEntryActionInsertFactColumnDetails)originalDetails, diffs, sb);
        } else if (details instanceof ActionSetFieldColumnDetails && originalDetails instanceof ActionSetFieldColumnDetails) {
            this.buildColumnDetailsUpdate((ActionSetFieldColumnDetails)details, (ActionSetFieldColumnDetails)originalDetails, diffs, sb);
        } else if (details instanceof LimitedEntryActionSetFieldColumnDetails && originalDetails instanceof LimitedEntryActionSetFieldColumnDetails) {
            this.buildColumnDetailsUpdate((LimitedEntryActionSetFieldColumnDetails)details, (LimitedEntryActionSetFieldColumnDetails)originalDetails, diffs, sb);
        } else if (details instanceof AttributeColumnDetails && originalDetails instanceof AttributeColumnDetails) {
            this.buildColumnDetailsUpdate((AttributeColumnDetails)details, (AttributeColumnDetails)originalDetails, diffs, sb);
        } else if (details instanceof MetadataColumnDetails && originalDetails instanceof MetadataColumnDetails) {
            this.buildColumnDetailsUpdate((MetadataColumnDetails)details, (MetadataColumnDetails)originalDetails, diffs, sb);
        } else if (details instanceof ActionWorkItemColumnDetails && originalDetails instanceof ActionWorkItemColumnDetails) {
            this.buildColumnDetailsUpdate((ActionWorkItemColumnDetails)details, (ActionWorkItemColumnDetails)originalDetails, diffs, sb);
        } else if (details instanceof ActionWorkItemInsertFactColumnDetails && originalDetails instanceof ActionWorkItemInsertFactColumnDetails) {
            this.buildColumnDetailsUpdate((ActionWorkItemInsertFactColumnDetails)details, (ActionWorkItemInsertFactColumnDetails)originalDetails, diffs, sb);
        } else if (details instanceof ActionWorkItemSetFieldColumnDetails && originalDetails instanceof ActionWorkItemSetFieldColumnDetails) {
            this.buildColumnDetailsUpdate((ActionWorkItemSetFieldColumnDetails)details, (ActionWorkItemSetFieldColumnDetails)originalDetails, diffs, sb);
        } else {
            sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateColumn(details.getColumnHeader())));
            SafeHtmlBuilder sbFields = null;
            if (diffs != null && !diffs.isEmpty()) {
                sbFields = new SafeHtmlBuilder();
                for (BaseColumnFieldDiff diff : diffs) {
                    String changedFieldName = diff.getFieldName();
                    if (changedFieldName.equals("header")) {
                        this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                        continue;
                    }
                    if (changedFieldName.equals("hideColumn")) {
                        this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
                        continue;
                    }
                    if (!changedFieldName.equals("defaultValue")) continue;
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DefaultValue(), diff.getOldValue(), diff.getValue(), sbFields);
                }
            }
            if (sbFields != null) {
                sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
            }
        }
    }

    private void buildColumnDetailsUpdate(AttributeColumnDetails details, AttributeColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateAttribute(details.getAttribute())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("hideColumn")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("defaultValue")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DefaultValue(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("reverseOrder")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ReverseOrder(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("useRowNumber")) continue;
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.UseRowNumber(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private void buildColumnDetailsUpdate(ConditionColumnDetails details, ConditionColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateCondition(details.getColumnHeader())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("header")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factField")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Field(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("operator")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Operator(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("valueList")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ValueList(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("binding")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Binding(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("constraintValueType")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.CalculationType(), this.getLiteralForCalculationType((Integer)diff.getOldValue()), this.getLiteralForCalculationType((Integer)diff.getValue()), sbFields);
                    continue;
                }
                if (changedFieldName.equals("defaultValue")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DefaultValue(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("hideColumn")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("entryPointName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DTLabelFromEntryPoint(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factType")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.FactType(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("boundName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Binding(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("fieldType")) continue;
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.FieldType(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private void buildColumnDetailsUpdate(LimitedEntryConditionColumnDetails details, LimitedEntryConditionColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateCondition(details.getColumnHeader())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("header")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("value")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Value(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factField")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Field(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("operator")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Operator(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("valueList")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ValueList(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("binding")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Binding(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("constraintValueType")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.CalculationType(), this.getLiteralForCalculationType((Integer)diff.getOldValue()), this.getLiteralForCalculationType((Integer)diff.getValue()), sbFields);
                    continue;
                }
                if (changedFieldName.equals("defaultValue")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DefaultValue(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("hideColumn")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("factType")) continue;
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.FactType(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private String getLiteralForCalculationType(Integer type) {
        switch (type) {
            case 1: {
                return GuidedDecisionTableConstants.INSTANCE.LiteralValue();
            }
            case 3: {
                return GuidedDecisionTableConstants.INSTANCE.Formula();
            }
            case 5: {
                return GuidedDecisionTableConstants.INSTANCE.Predicate();
            }
        }
        return "--unknown--";
    }

    private void buildColumnDetailsUpdate(ActionInsertFactColumnDetails details, ActionInsertFactColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateAction(details.getColumnHeader())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("header")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factField")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Field(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factType")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.FactType(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("isInsertLogical")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.LogicallyInsert(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("valueList")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ValueList(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("defaultValue")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DefaultValue(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("hideColumn")) continue;
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private void buildColumnDetailsUpdate(LimitedEntryActionInsertFactColumnDetails details, LimitedEntryActionInsertFactColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateAction(details.getColumnHeader())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("header")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("value")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Value(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factField")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Field(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factType")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.FactType(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("isInsertLogical")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.LogicallyInsert(), diff.getOldValue(), diff.getValue(), sb);
                    continue;
                }
                if (changedFieldName.equals("valueList")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ValueList(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("defaultValue")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DefaultValue(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("hideColumn")) continue;
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private void buildColumnDetailsUpdate(ActionSetFieldColumnDetails details, ActionSetFieldColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateAction(details.getColumnHeader())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("header")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("boundName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Binding(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factField")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Field(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("isInsertLogical")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.LogicallyInsert(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("valueList")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ValueList(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("defaultValue")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DefaultValue(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("hideColumn")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("update")) continue;
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.UpdateEngineWithChanges(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private void buildColumnDetailsUpdate(LimitedEntryActionSetFieldColumnDetails details, LimitedEntryActionSetFieldColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateAction(details.getColumnHeader())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("header")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("value")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Value(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("boundName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Binding(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factField")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Field(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("isInsertLogical")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.LogicallyInsert(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("valueList")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ValueList(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("defaultValue")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DefaultValue(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("hideColumn")) continue;
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private void buildColumnDetailsUpdate(MetadataColumnDetails details, MetadataColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateColumn(details.getColumnHeader())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("defaultValue")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DefaultValue(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("metadata")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Metadata1(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("header")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("hideColumn")) continue;
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private void buildColumnDetailsUpdate(ActionWorkItemColumnDetails details, ActionWorkItemColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateAction(details.getColumnHeader())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("header")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("hideColumn")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("workItemDefinitionName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemName(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("workItemDefinitionParameterName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterName(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("workItemDefinitionParameterValue")) continue;
                if (diff instanceof WorkItemColumnParameterValueDiffImpl) {
                    String parameterName = ((WorkItemColumnParameterValueDiffImpl)diff).getParameterName();
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterValueOnly0(parameterName), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterValue(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private void buildColumnDetailsUpdate(ActionWorkItemInsertFactColumnDetails details, ActionWorkItemInsertFactColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateAction(details.getColumnHeader())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("header")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("hideColumn")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("boundName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Binding(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factType")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.FactType(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factField")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Field(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("isInsertLogical")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.LogicallyInsert(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("workItemName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemName(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("workItemResultParameterName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterName(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("parameterClassName")) continue;
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterClassName(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private void buildColumnDetailsUpdate(ActionWorkItemSetFieldColumnDetails details, ActionWorkItemSetFieldColumnDetails originalDetails, List<BaseColumnFieldDiff> diffs, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogUpdateAction(details.getColumnHeader())));
        SafeHtmlBuilder sbFields = null;
        if (diffs != null && !diffs.isEmpty()) {
            sbFields = new SafeHtmlBuilder();
            for (BaseColumnFieldDiff diff : diffs) {
                String changedFieldName = diff.getFieldName();
                if (changedFieldName.equals("header")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.ColumnHeader(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("hideColumn")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.HideThisColumn(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("boundName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Binding(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("factField")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.Field(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("type")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.FieldType(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("update")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.UpdateEngineWithChanges(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("workItemName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemName(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (changedFieldName.equals("workItemResultParameterName")) {
                    this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterName(), diff.getOldValue(), diff.getValue(), sbFields);
                    continue;
                }
                if (!changedFieldName.equals("parameterClassName")) continue;
                this.buildColumnUpdateFields(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterClassName(), diff.getOldValue(), diff.getValue(), sbFields);
            }
        }
        if (sbFields != null) {
            sb.append(TEMPLATE.updatedFields(sbFields.toSafeHtml(), this.labelClass));
        }
    }

    private void buildColumnUpdateFields(String fieldName, Object oldValue, Object newValue, SafeHtmlBuilder sb) {
        String _fieldName = fieldName.endsWith(":") ? fieldName.substring(0, fieldName.length() - 1) : fieldName;
        String _oldValue = oldValue != null ? this.convertValueToString(oldValue) : "";
        String _newValue = newValue != null ? this.convertValueToString(newValue) : "";
        sb.append(TEMPLATE.updatedField(_fieldName, QUOTE + _oldValue + QUOTE, QUOTE + _newValue + QUOTE));
    }

    private String nil(String value) {
        return value == null ? "" : value;
    }

    private String nil(PortableParameterDefinition value) {
        return value == null ? "" : value.asString();
    }

    private String nilLimitedEntryValue(DTCellValue52 value) {
        String displayText = this.convertDTCellValueToString(value);
        return displayText == null ? "" : displayText;
    }

    private String convertValueToString(Object o) {
        if (o instanceof Boolean) {
            Boolean booleanValue = (Boolean)o;
            return booleanValue == null ? null : booleanValue.toString();
        }
        if (o instanceof Date) {
            Date dateValue = (Date)o;
            return dateValue == null ? null : this.format.format(dateValue);
        }
        if (o instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)o;
            return bigDecimalValue == null ? null : bigDecimalValue.toPlainString();
        }
        if (o instanceof BigInteger) {
            BigInteger bigIntegerValue = (BigInteger)o;
            return bigIntegerValue == null ? null : bigIntegerValue.toString();
        }
        if (o instanceof Byte) {
            Byte byteValue = (Byte)o;
            return byteValue == null ? null : byteValue.toString();
        }
        if (o instanceof Double) {
            Double doubleValue = (Double)o;
            return doubleValue == null ? null : doubleValue.toString();
        }
        if (o instanceof Float) {
            Float floatValue = (Float)o;
            return floatValue == null ? null : floatValue.toString();
        }
        if (o instanceof Integer) {
            Integer integerValue = (Integer)o;
            return integerValue == null ? null : integerValue.toString();
        }
        if (o instanceof Long) {
            Long longValue = (Long)o;
            return longValue == null ? null : longValue.toString();
        }
        if (o instanceof Short) {
            Short shortValue = (Short)o;
            return shortValue == null ? null : shortValue.toString();
        }
        return o.toString();
    }

    private String convertDTCellValueToString(DTCellValue52 dcv) {
        switch (dcv.getDataType()) {
            case BOOLEAN: {
                Boolean booleanValue = dcv.getBooleanValue();
                return booleanValue == null ? null : booleanValue.toString();
            }
            case DATE: {
                Date dateValue = dcv.getDateValue();
                return dateValue == null ? null : this.format.format(dcv.getDateValue());
            }
            case NUMERIC: {
                BigDecimal numericValue = (BigDecimal)dcv.getNumericValue();
                return numericValue == null ? null : numericValue.toPlainString();
            }
            case NUMERIC_BIGDECIMAL: {
                BigDecimal bigDecimalValue = (BigDecimal)dcv.getNumericValue();
                return bigDecimalValue == null ? null : bigDecimalValue.toPlainString();
            }
            case NUMERIC_BIGINTEGER: {
                BigInteger bigIntegerValue = (BigInteger)dcv.getNumericValue();
                return bigIntegerValue == null ? null : bigIntegerValue.toString();
            }
            case NUMERIC_BYTE: {
                Byte byteValue = (Byte)dcv.getNumericValue();
                return byteValue == null ? null : byteValue.toString();
            }
            case NUMERIC_DOUBLE: {
                Double doubleValue = (Double)dcv.getNumericValue();
                return doubleValue == null ? null : doubleValue.toString();
            }
            case NUMERIC_FLOAT: {
                Float floatValue = (Float)dcv.getNumericValue();
                return floatValue == null ? null : floatValue.toString();
            }
            case NUMERIC_INTEGER: {
                Integer integerValue = (Integer)dcv.getNumericValue();
                return integerValue == null ? null : integerValue.toString();
            }
            case NUMERIC_LONG: {
                Long longValue = (Long)dcv.getNumericValue();
                return longValue == null ? null : longValue.toString();
            }
            case NUMERIC_SHORT: {
                Short shortValue = (Short)dcv.getNumericValue();
                return shortValue == null ? null : shortValue.toString();
            }
        }
        return dcv.getStringValue();
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div>{0}</div>")
        public SafeHtml commentHeader(String var1);

        @SafeHtmlTemplates.Template(value="<tr><td><div class=\"{2}\">{0}</div></td><td><div class=\"{3}\">{1}</div></td></tr>")
        public SafeHtml commentRow(String var1, String var2, String var3, String var4);

        @SafeHtmlTemplates.Template(value="<div>{0}</div><table><tr><td><div class=\"{5}\">{1}</div></td><td><div class=\"{6}\">{2}</div></td></tr><tr><td><div class=\"{5}\">{3}</div></td><td><div class=\"{6}\">{4}</div></td></tr></table>")
        public SafeHtml commentHeader2Details(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

        @SafeHtmlTemplates.Template(value="<div>{0}</div><table><tr><td><div class=\"{7}\">{1}</div></td><td><div class=\"{8}\">{2}</div></td></tr><tr><td><div class=\"{7}\">{3}</div></td><td><div class=\"{8}\">{4}</div></td></tr><tr><td><div class=\"{7}\">{5}</div></td><td><div class=\"{8}\">{6}</div></td></tr></table>")
        public SafeHtml commentHeader3Details(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9);

        @SafeHtmlTemplates.Template(value="<div>{0}</div><table><tr><td><div class=\"{9}\">{1}</div></td><td><div class=\"{10}\">{2}</div></td></tr><tr><td><div class=\"{9}\">{3}</div></td><td><div class=\"{10}\">{4}</div></td></tr><tr><td><div class=\"{9}\">{5}</div></td><td><div class=\"{10}\">{6}</div></td></tr><tr><td><div class=\"{9}\">{7}</div></td><td><div class=\"{10}\">{8}</div></td></tr></table>")
        public SafeHtml commentHeader4Details(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11);

        @SafeHtmlTemplates.Template(value="<div class=\"{1}\"><ul>{0}</ul></div>")
        public SafeHtml updatedFields(SafeHtml var1, String var2);

        @SafeHtmlTemplates.Template(value="<li>{0}:&nbsp;{1}&nbsp;&raquo;&nbsp;{2}&nbsp;</li>")
        public SafeHtml updatedField(String var1, String var2, String var3);
    }
}

