/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.pages;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AbstractGuidedDecisionTableWizardPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.FactPatternsPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.events.DuplicatePatternsEvent;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.events.PatternRemovedEvent;
import org.kie.workbench.common.widgets.client.datamodel.ImportAddedEvent;
import org.kie.workbench.common.widgets.client.datamodel.ImportRemovedEvent;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class FactPatternsPage
extends AbstractGuidedDecisionTableWizardPage
implements FactPatternsPageView.Presenter {
    @Inject
    private FactPatternsPageView view;
    @Inject
    private Event<DuplicatePatternsEvent> duplicatePatternsEvent;
    @Inject
    private Event<PatternRemovedEvent> patternRemovedEvent;
    @Inject
    private Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;

    public String getTitle() {
        return GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardFactPatterns();
    }

    public void initialise() {
        this.view.init(this);
        this.view.setValidator(this.getValidator());
        List<String> availableTypes = Arrays.asList(this.oracle.getFactTypes());
        this.view.setAvailableFactTypes(availableTypes);
        this.view.setChosenPatterns(new ArrayList<Pattern52>());
        this.content.setWidget((IsWidget)this.view);
    }

    public void prepareView() {
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean arePatternBindingsUnique = this.getValidator().arePatternBindingsUnique();
        DuplicatePatternsEvent event = new DuplicatePatternsEvent(arePatternBindingsUnique);
        this.duplicatePatternsEvent.fire((Object)event);
        callback.callback((Object)arePatternBindingsUnique);
    }

    public void handleImportAddedEvent(@Observes ImportAddedEvent event) {
        if (!event.getDataModelOracle().equals(this.oracle)) {
            return;
        }
        List<String> availableTypes = Arrays.asList(this.oracle.getFactTypes());
        this.view.setAvailableFactTypes(availableTypes);
    }

    public void handleImportRemovedEvent(@Observes ImportRemovedEvent event) {
        if (!event.getDataModelOracle().equals(this.oracle)) {
            return;
        }
        List<String> availableTypes = Arrays.asList(this.oracle.getFactTypes());
        this.view.setAvailableFactTypes(availableTypes);
    }

    public void onDuplicatePatterns(@Observes DuplicatePatternsEvent event) {
        this.view.setArePatternBindingsUnique(event.getArePatternBindingsUnique());
    }

    @Override
    public void isPatternEvent(Pattern52 pattern, Callback<Boolean> callback) {
        this.oracle.isFactTypeAnEvent(pattern.getFactType(), callback);
    }

    @Override
    public void signalRemovalOfPattern(Pattern52 pattern) {
        PatternRemovedEvent event = new PatternRemovedEvent(pattern);
        this.patternRemovedEvent.fire((Object)event);
    }

    @Override
    public void setConditionPatterns(List<Pattern52> patterns) {
        this.model.getConditions().clear();
        this.model.getConditions().addAll(patterns);
    }

    @Override
    public void makeResult(GuidedDecisionTable52 model) {
        int fi = 1;
        for (Pattern52 p : model.getPatterns()) {
            if (this.getValidator().isPatternValid(p)) continue;
            String binding = "f" + fi++;
            p.setBoundName(binding);
            while (!this.getValidator().isPatternBindingUnique(p)) {
                binding = "f" + fi++;
                p.setBoundName(binding);
            }
        }
    }

    @Override
    public void stateChanged() {
        WizardPageStatusChangeEvent event = new WizardPageStatusChangeEvent((WizardPage)this);
        this.wizardPageStatusChangeEvent.fire((Object)event);
    }
}

