/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.pages;

import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.New;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.rule.HasCEPWindow;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.FactPatternsPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.MinimumWidthCellList;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.cells.PatternCell;
import org.drools.workbench.screens.guided.rule.client.editor.BindingTextBox;
import org.drools.workbench.screens.guided.rule.client.editor.CEPWindowOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.OperatorSelection;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.resources.WizardCellListResources;

@Dependent
public class FactPatternsPageViewImpl
extends Composite
implements FactPatternsPageView {
    private FactPatternsPageView.Presenter presenter;
    private Validator validator;
    private Set<String> availableTypesSelections;
    private MinimumWidthCellList<String> availableTypesWidget;
    private List<Pattern52> chosenPatterns;
    private Pattern52 chosenPatternSelection;
    private Set<Pattern52> chosenPatternSelections;
    private MinimumWidthCellList<Pattern52> chosenPatternWidget;
    @UiField
    ScrollPanel availableTypesContainer;
    @UiField
    ScrollPanel chosenPatternsContainer;
    @UiField
    Button btnAdd;
    @UiField
    Button btnRemove;
    @UiField
    VerticalPanel patternDefinition;
    @UiField
    BindingTextBox txtBinding;
    @UiField
    HelpBlock txtBindingHelp;
    @UiField
    FormGroup bindingContainer;
    @UiField
    TextBox txtEntryPoint;
    @UiField
    CEPWindowOperatorsDropdown ddCEPWindow;
    @UiField
    FormGroup cepWindowContainer;
    @UiField(provided=true)
    Button btnMoveUp = new Button(){
        {
            this.setIcon(IconType.ANGLE_UP);
        }
    };
    @UiField(provided=true)
    Button btnMoveDown = new Button(){
        {
            this.setIcon(IconType.ANGLE_DOWN);
        }
    };
    @New
    @Inject
    private PatternCell patternCell;
    private static FactPatternsPageWidgetBinder uiBinder = (FactPatternsPageWidgetBinder)GWT.create(FactPatternsPageWidgetBinder.class);

    public FactPatternsPageViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @PostConstruct
    public void setup() {
        this.availableTypesWidget = new MinimumWidthCellList(new TextCell(), (CellList.Resources)WizardCellListResources.INSTANCE);
        this.chosenPatternWidget = new MinimumWidthCellList(this.patternCell, (CellList.Resources)WizardCellListResources.INSTANCE);
        this.initialiseAvailableTypes();
        this.initialiseChosenPatterns();
        this.initialiseBinding();
        this.initialiseEntryPoint();
        this.initialiseCEPWindow();
        this.initialiseShufflers();
    }

    @Override
    public void setValidator(Validator validator) {
        this.validator = validator;
        this.patternCell.setValidator(validator);
    }

    private void initialiseAvailableTypes() {
        this.availableTypesContainer.add(this.availableTypesWidget);
        this.availableTypesWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.availableTypesWidget.setMinimumWidth(270);
        Label lstEmpty = new Label(GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardNoAvailablePatterns());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.availableTypesWidget.setEmptyListWidget((Widget)lstEmpty);
        final MultiSelectionModel selectionModel = new MultiSelectionModel();
        this.availableTypesWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                FactPatternsPageViewImpl.this.availableTypesSelections = selectionModel.getSelectedSet();
                FactPatternsPageViewImpl.this.btnAdd.setEnabled(FactPatternsPageViewImpl.this.availableTypesSelections.size() > 0);
            }
        });
    }

    private void initialiseChosenPatterns() {
        this.chosenPatternsContainer.add(this.chosenPatternWidget);
        this.chosenPatternWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.chosenPatternWidget.setMinimumWidth(270);
        Label lstEmpty = new Label(GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardNoChosenPatterns());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.chosenPatternWidget.setEmptyListWidget((Widget)lstEmpty);
        final MultiSelectionModel selectionModel = new MultiSelectionModel();
        this.chosenPatternWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                FactPatternsPageViewImpl.this.chosenPatternSelections = selectionModel.getSelectedSet();
                this.chosenTypesSelected(FactPatternsPageViewImpl.this.chosenPatternSelections);
            }

            private void chosenTypesSelected(Set<Pattern52> ps) {
                FactPatternsPageViewImpl.this.btnRemove.setEnabled(true);
                if (ps.size() == 1) {
                    FactPatternsPageViewImpl.this.chosenPatternSelection = ps.iterator().next();
                    FactPatternsPageViewImpl.this.patternDefinition.setVisible(true);
                    FactPatternsPageViewImpl.this.validateBinding();
                    FactPatternsPageViewImpl.this.txtBinding.setEnabled(true);
                    FactPatternsPageViewImpl.this.txtBinding.setText(FactPatternsPageViewImpl.this.chosenPatternSelection.getBoundName());
                    FactPatternsPageViewImpl.this.txtEntryPoint.setEnabled(true);
                    FactPatternsPageViewImpl.this.txtEntryPoint.setText(FactPatternsPageViewImpl.this.chosenPatternSelection.getEntryPointName());
                    FactPatternsPageViewImpl.this.enableMoveUpButton();
                    FactPatternsPageViewImpl.this.enableMoveDownButton();
                    FactPatternsPageViewImpl.this.presenter.isPatternEvent(FactPatternsPageViewImpl.this.chosenPatternSelection, new Callback<Boolean>(){

                        public void callback(Boolean result) {
                            if (Boolean.TRUE.equals(result)) {
                                FactPatternsPageViewImpl.this.ddCEPWindow.setCEPWindow((HasCEPWindow)FactPatternsPageViewImpl.this.chosenPatternSelection);
                                FactPatternsPageViewImpl.this.cepWindowContainer.setVisible(true);
                            } else {
                                FactPatternsPageViewImpl.this.cepWindowContainer.setVisible(false);
                            }
                        }
                    });
                } else {
                    FactPatternsPageViewImpl.this.chosenPatternSelection = null;
                    FactPatternsPageViewImpl.this.patternDefinition.setVisible(false);
                    FactPatternsPageViewImpl.this.txtBinding.setEnabled(false);
                    FactPatternsPageViewImpl.this.txtBinding.setText("");
                    FactPatternsPageViewImpl.this.txtEntryPoint.setEnabled(false);
                    FactPatternsPageViewImpl.this.txtEntryPoint.setText("");
                    FactPatternsPageViewImpl.this.btnMoveUp.setEnabled(false);
                    FactPatternsPageViewImpl.this.btnMoveDown.setEnabled(false);
                    FactPatternsPageViewImpl.this.cepWindowContainer.setVisible(false);
                }
            }
        });
    }

    private void validateBinding() {
        if (this.validator.isPatternBindingUnique(this.chosenPatternSelection)) {
            this.txtBindingHelp.setVisible(false);
            this.bindingContainer.removeStyleName(ValidationState.ERROR.getCssName());
        } else {
            this.txtBindingHelp.setVisible(true);
            this.bindingContainer.addStyleName(ValidationState.ERROR.getCssName());
        }
    }

    private void enableMoveUpButton() {
        if (this.chosenPatterns == null || this.chosenPatternSelection == null) {
            this.btnMoveUp.setEnabled(false);
            return;
        }
        int index = this.chosenPatterns.indexOf(this.chosenPatternSelection);
        this.btnMoveUp.setEnabled(index > 0);
    }

    private void enableMoveDownButton() {
        if (this.chosenPatterns == null || this.chosenPatternSelection == null) {
            this.btnMoveDown.setEnabled(false);
            return;
        }
        int index = this.chosenPatterns.indexOf(this.chosenPatternSelection);
        this.btnMoveDown.setEnabled(index < this.chosenPatterns.size() - 1);
    }

    private void initialiseBinding() {
        this.txtBinding.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String binding = FactPatternsPageViewImpl.this.txtBinding.getText();
                FactPatternsPageViewImpl.this.chosenPatternSelection.setBoundName(binding);
                FactPatternsPageViewImpl.this.presenter.stateChanged();
                FactPatternsPageViewImpl.this.validateBinding();
            }
        });
    }

    private void initialiseEntryPoint() {
        this.txtEntryPoint.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (FactPatternsPageViewImpl.this.chosenPatternSelection == null) {
                    return;
                }
                FactPatternsPageViewImpl.this.chosenPatternSelection.setEntryPointName((String)event.getValue());
            }
        });
    }

    private void initialiseCEPWindow() {
        this.ddCEPWindow.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<OperatorSelection>(){

            public void onValueChange(ValueChangeEvent<OperatorSelection> event) {
                if (FactPatternsPageViewImpl.this.chosenPatternSelection == null) {
                    return;
                }
                OperatorSelection selection = (OperatorSelection)event.getValue();
                String selected = selection.getValue();
                FactPatternsPageViewImpl.this.chosenPatternSelection.getWindow().setOperator(selected);
            }
        });
    }

    private void initialiseShufflers() {
        this.btnMoveUp.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int index = FactPatternsPageViewImpl.this.chosenPatterns.indexOf(FactPatternsPageViewImpl.this.chosenPatternSelection);
                Pattern52 p = (Pattern52)FactPatternsPageViewImpl.this.chosenPatterns.remove(index);
                FactPatternsPageViewImpl.this.chosenPatterns.add(index - 1, p);
                FactPatternsPageViewImpl.this.setChosenPatterns(FactPatternsPageViewImpl.this.chosenPatterns);
                FactPatternsPageViewImpl.this.presenter.setConditionPatterns(FactPatternsPageViewImpl.this.chosenPatterns);
            }
        });
        this.btnMoveDown.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int index = FactPatternsPageViewImpl.this.chosenPatterns.indexOf(FactPatternsPageViewImpl.this.chosenPatternSelection);
                Pattern52 p = (Pattern52)FactPatternsPageViewImpl.this.chosenPatterns.remove(index);
                FactPatternsPageViewImpl.this.chosenPatterns.add(index + 1, p);
                FactPatternsPageViewImpl.this.setChosenPatterns(FactPatternsPageViewImpl.this.chosenPatterns);
                FactPatternsPageViewImpl.this.presenter.setConditionPatterns(FactPatternsPageViewImpl.this.chosenPatterns);
            }
        });
    }

    @Override
    public void setAvailableFactTypes(List<String> types) {
        this.availableTypesWidget.setRowCount(types.size(), true);
        this.availableTypesWidget.setRowData(types);
    }

    @Override
    public void setChosenPatterns(List<Pattern52> types) {
        this.chosenPatterns = types;
        this.chosenPatternWidget.setRowCount(types.size(), true);
        this.chosenPatternWidget.setRowData(types);
        this.enableMoveUpButton();
        this.enableMoveDownButton();
        this.presenter.stateChanged();
    }

    public void init(FactPatternsPageView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setArePatternBindingsUnique(boolean arePatternBindingsUnique) {
        this.chosenPatternWidget.redraw();
    }

    @UiHandler(value={"btnAdd"})
    public void btnAddClick(ClickEvent event) {
        for (String type : this.availableTypesSelections) {
            Pattern52 pattern = new Pattern52();
            pattern.setFactType(type);
            this.chosenPatterns.add(pattern);
        }
        this.setChosenPatterns(this.chosenPatterns);
        this.presenter.setConditionPatterns(this.chosenPatterns);
        this.presenter.stateChanged();
    }

    @UiHandler(value={"btnRemove"})
    public void btnRemoveClick(ClickEvent event) {
        boolean allPatternsRemoved = true;
        for (Pattern52 pattern : this.chosenPatternSelections) {
            if (!this.validator.canPatternBeRemoved(pattern)) {
                allPatternsRemoved = false;
                continue;
            }
            this.chosenPatterns.remove(pattern);
            this.chosenPatternSelections.remove(pattern);
            this.presenter.signalRemovalOfPattern(pattern);
        }
        if (!allPatternsRemoved) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.UnableToDeletePatterns());
        }
        this.setChosenPatterns(this.chosenPatterns);
        this.presenter.setConditionPatterns(this.chosenPatterns);
        this.presenter.stateChanged();
        this.txtBinding.setText("");
        this.txtBinding.setEnabled(false);
        this.txtEntryPoint.setText("");
        this.txtEntryPoint.setEnabled(false);
        this.btnRemove.setEnabled(this.isAPatternSelected());
        this.patternDefinition.setVisible(false);
    }

    private boolean isAPatternSelected() {
        for (Pattern52 pattern : this.chosenPatterns) {
            if (!this.chosenPatternWidget.getSelectionModel().isSelected((Object)pattern)) continue;
            return true;
        }
        return false;
    }

    static interface FactPatternsPageWidgetBinder
    extends UiBinder<Widget, FactPatternsPageViewImpl> {
    }
}

