/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.utils;

import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.utils.DTCellValueUtilities;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DTCellValueUtilitiesTest {
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    private DTCellValueUtilities utilities;

    @Before
    public void setup() {
        this.utilities = new DTCellValueUtilities(this.model, this.oracle);
    }

    @Test
    public void testRemoveCommaSeparatedValue() {
        DTCellValue52 dcv = new DTCellValue52(Integer.valueOf(1));
        this.utilities.removeCommaSeparatedValue(dcv);
        Assert.assertEquals((Object)1, (Object)dcv.getNumericValue());
        Assert.assertNull((Object)dcv.getBooleanValue());
        Assert.assertNull((Object)dcv.getStringValue());
        Assert.assertNull((Object)dcv.getDateValue());
        Assert.assertEquals((Object)DataType.DataTypes.NUMERIC_INTEGER, (Object)dcv.getDataType());
        dcv = new DTCellValue52(Long.valueOf(1L));
        this.utilities.removeCommaSeparatedValue(dcv);
        Assert.assertEquals((Object)1L, (Object)dcv.getNumericValue());
        Assert.assertNull((Object)dcv.getBooleanValue());
        Assert.assertNull((Object)dcv.getStringValue());
        Assert.assertNull((Object)dcv.getDateValue());
        Assert.assertEquals((Object)DataType.DataTypes.NUMERIC_LONG, (Object)dcv.getDataType());
        dcv = new DTCellValue52(Double.valueOf(1.0));
        this.utilities.removeCommaSeparatedValue(dcv);
        Assert.assertEquals((Object)1.0, (Object)dcv.getNumericValue());
        Assert.assertNull((Object)dcv.getBooleanValue());
        Assert.assertNull((Object)dcv.getStringValue());
        Assert.assertNull((Object)dcv.getDateValue());
        Assert.assertEquals((Object)DataType.DataTypes.NUMERIC_DOUBLE, (Object)dcv.getDataType());
        dcv = new DTCellValue52("Fred");
        this.utilities.removeCommaSeparatedValue(dcv);
        Assert.assertEquals((Object)"Fred", (Object)dcv.getStringValue());
        Assert.assertNull((Object)dcv.getBooleanValue());
        Assert.assertNull((Object)dcv.getNumericValue());
        Assert.assertNull((Object)dcv.getDateValue());
        Assert.assertEquals((Object)DataType.DataTypes.STRING, (Object)dcv.getDataType());
        dcv = new DTCellValue52("Fred,Ginger");
        this.utilities.removeCommaSeparatedValue(dcv);
        Assert.assertEquals((Object)"Fred", (Object)dcv.getStringValue());
        Assert.assertNull((Object)dcv.getBooleanValue());
        Assert.assertNull((Object)dcv.getNumericValue());
        Assert.assertNull((Object)dcv.getDateValue());
        Assert.assertEquals((Object)DataType.DataTypes.STRING, (Object)dcv.getDataType());
        dcv = new DTCellValue52(",Ginger");
        this.utilities.removeCommaSeparatedValue(dcv);
        Assert.assertEquals((Object)"", (Object)dcv.getStringValue());
        Assert.assertNull((Object)dcv.getBooleanValue());
        Assert.assertNull((Object)dcv.getNumericValue());
        Assert.assertNull((Object)dcv.getDateValue());
        Assert.assertEquals((Object)DataType.DataTypes.STRING, (Object)dcv.getDataType());
        dcv = new DTCellValue52("Fred,");
        this.utilities.removeCommaSeparatedValue(dcv);
        Assert.assertEquals((Object)"Fred", (Object)dcv.getStringValue());
        Assert.assertNull((Object)dcv.getBooleanValue());
        Assert.assertNull((Object)dcv.getNumericValue());
        Assert.assertNull((Object)dcv.getDateValue());
        Assert.assertEquals((Object)DataType.DataTypes.STRING, (Object)dcv.getDataType());
    }
}

