/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.LimitedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.TestUtil;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ValidateEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Checks;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerConflictTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    @Mock
    AsyncPackageDataModelOracle oracle;
    private AnalysisReport analysisReport;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
        Mockito.when((Object)this.oracle.getFieldType("Person", "age")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.oracle.getFieldType("Person", "name")).thenReturn((Object)"String");
        Mockito.when((Object)this.oracle.getFieldType("Person", "lastName")).thenReturn((Object)"String");
        Mockito.when((Object)this.oracle.getFieldType("Account", "deposit")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.oracle.getFieldType("Person", "approved")).thenReturn((Object)"Boolean");
    }

    @Test
    public void testNoIssue() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withConditionIntegerColumn("d", "Account", "deposit", "<").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 100, 0, true}}).build();
        DecisionTableAnalyzer analyzer = this.getAnalyser(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
    }

    @Test
    public void testNoIssueWithNulls() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("p", "Person", "age", ">").withConditionIntegerColumn("p", "Person", "age", "<").withData(new Object[][]{{1, "description", null, null}}).build();
        ((DTCellValue52)((List)table52.getData().get(0)).get(2)).setStringValue("");
        ((DTCellValue52)((List)table52.getData().get(0)).get(3)).setStringValue("");
        DecisionTableAnalyzer analyzer = this.getAnalyser(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
    }

    @Test
    public void testImpossibleMatch001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withConditionIntegerColumn("a", "Person", "age", "<").withData(new Object[][]{{1, "description", 100, 0}}).build();
        DecisionTableAnalyzer analyzer = this.getAnalyser(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("ImpossibleMatch", this.analysisReport);
    }

    @Test
    public void testImpossibleMatch002() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withEnumColumn("a", "Person", "name", "==", "Toni,Eder").withConditionIntegerColumn("a", "Person", "name", "==").withData(new Object[][]{{1, "description", "Toni", ""}}).build();
        DecisionTableAnalyzer analyzer = this.getAnalyser(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertDoesNotContain("ImpossibleMatch", this.analysisReport);
    }

    @Test
    public void testConflict() throws Exception {
        GuidedDecisionTable52 table52 = new LimitedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withIntegerColumn("a", "Person", "age", "==", 0).withAction("a", "approved", "Boolean", new DTCellValue52(){
            {
                this.setBooleanValue(true);
            }
        }).withAction("a", "approved", "Boolean", new DTCellValue52(){
            {
                this.setBooleanValue(false);
            }
        }).withData(new Object[][]{{1, "description", true, true, false}, {2, "description", true, false, true}}).build();
        DecisionTableAnalyzer analyzer = this.getAnalyser(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("ConflictingRows", this.analysisReport, 2);
        TestUtil.assertContains("ConflictingRows", this.analysisReport, 1);
    }

    @Test
    public void testConflictIgnoreEmptyRows() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withActionSetField("a", "approved", "String").withData(new Object[][]{{1, "description", null, ""}, {2, "description", null, "true"}}).build();
        DecisionTableAnalyzer analyzer = this.getAnalyser(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertDoesNotContain("ConflictingRows", this.analysisReport, 1);
        TestUtil.assertDoesNotContain("ConflictingRows", this.analysisReport, 2);
    }

    @Test
    public void testConflictWithASubsumingRow() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withStringColumn("a", "Person", "name", "==").withStringColumn("a", "Person", "lastName", "==").withActionSetField("a", "salary", "Integer").withActionSetField("a", "description", "String").withData(new Object[][]{{1, "description", 10, null, null, 100, "ok"}, {2, "description", null, "Toni", null, 200, "ok"}, {3, "description", 12, "Toni", "Rikkola", 300, "ok"}, {4, "description", null, null, null, null, null}}).build();
        DecisionTableAnalyzer analyzer = this.getAnalyser(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("ConflictingRows", this.analysisReport, 2);
        TestUtil.assertContains("ConflictingRows", this.analysisReport, 3);
    }

    private DecisionTableAnalyzer getAnalyser(GuidedDecisionTable52 table52) {
        return new DecisionTableAnalyzer((PlaceRequest)Mockito.mock(PlaceRequest.class), this.oracle, table52, (EventBus)Mockito.mock(EventBus.class)){

            protected void sendReport(AnalysisReport report) {
                DecisionTableAnalyzerConflictTest.this.analysisReport = report;
            }

            protected Checks getChecks() {
                return new Checks(){

                    protected void doRun(CancellableRepeatingCommand command) {
                        while (command.execute()) {
                        }
                    }
                };
            }

            protected ParameterizedCommand<Status> getOnStatusCommand() {
                return null;
            }

            protected Command getOnCompletionCommand() {
                return new Command(){

                    public void execute() {
                        this.sendReport(this.makeAnalysisReport());
                    }
                };
            }
        };
    }
}

