/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.TestUtil;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ValidateEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Checks;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerDeficiencyTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    @Mock
    AsyncPackageDataModelOracle oracle;
    private AnalysisReport analysisReport;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.oracle.getFieldType("Person", "age")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.oracle.getFieldType("Person", "approved")).thenReturn((Object)"Boolean");
        Mockito.when((Object)this.oracle.getFieldType("Person", "salary")).thenReturn((Object)"String");
        Mockito.when((Object)this.oracle.getFieldType("Person", "description")).thenReturn((Object)"String");
        Mockito.when((Object)this.oracle.getFieldType("Person", "name")).thenReturn((Object)"String");
        Mockito.when((Object)this.oracle.getFieldType("Person", "lastName")).thenReturn((Object)"String");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
    }

    @Test
    public void testRuleIsDeficient001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withStringColumn("a", "Person", "name", "==").withStringColumn("a", "Person", "lastName", "==").withActionSetField("a", "salary", "Integer").withData(new Object[][]{{1, "description", null, "Eder", null, 100}, {2, "description", 10, null, null, 200}, {3, "description", null, "Toni", "Rikkola", 300}, {4, "description", null, null, null, null}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 1);
        TestUtil.assertContains("DeficientRow", this.analysisReport, 2);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 3);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 4);
    }

    @Test
    public void testRuleIsDeficient002() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withStringColumn("a", "Person", "name", "==").withStringColumn("a", "Person", "lastName", "==").withActionSetField("a", "salary", "Integer").withActionSetField("a", "description", "String").withData(new Object[][]{{1, "description", 10, "", "", 100, "ok"}, {2, "description", null, "", "", 200, "ok"}, {3, "description", 12, "", "Rikkola", 300, "ok"}, {4, "description", null, "", "", null, ""}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 1);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 2);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 3);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 4);
        ((DTCellValue52)((List)table52.getData().get(1)).get(3)).setStringValue("Toni");
        HashMap updates = new HashMap();
        updates.put(new Coordinate(1, 3), new ArrayList());
        analyzer.onValidate(new ValidateEvent(updates));
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 1);
        TestUtil.assertContains("DeficientRow", this.analysisReport, 2);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 3);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 4);
    }

    @Test
    public void testRuleIsDeficient003() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withStringColumn("a", "Person", "name", "==").withStringColumn("a", "Person", "lastName", "==").withActionSetField("a", "salary", "Integer").withActionSetField("a", "description", "String").withData(new Object[][]{{1, "description", 10, "", "", 100, "ok"}, {2, "description", null, "Eder", "", 200, "ok"}, {3, "description", 12, "", "Rikkola", 300, "ok"}, {4, "description", null, "", "", null, ""}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 1);
        TestUtil.assertContains("DeficientRow", this.analysisReport, 2);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 3);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 4);
        ((DTCellValue52)((List)table52.getData().get(2)).get(3)).setStringValue("Toni");
        HashMap updates = new HashMap();
        updates.put(new Coordinate(2, 3), new ArrayList());
        analyzer.onValidate(new ValidateEvent(updates));
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 1);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 2);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 3);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 4);
    }

    @Test
    public void testRuleIsDeficient004() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withStringColumn("a", "Person", "name", "==").withStringColumn("a", "Person", "lastName", "==").withActionSetField("a", "salary", "Integer").withActionSetField("a", "description", "String").withData(new Object[][]{{1, "description", 10, "", "", 100, "ok"}, {2, "description", null, "Eder", "", 200, "ok"}, {3, "description", 12, "Toni", "Rikkola", 300, "ok"}, {4, "description", null, "", "", null, ""}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 1);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 2);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 3);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 4);
        ((DTCellValue52)((List)table52.getData().get(2)).get(3)).setStringValue("");
        HashMap updates = new HashMap();
        updates.put(new Coordinate(2, 3), new ArrayList());
        analyzer.onValidate(new ValidateEvent(updates));
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 1);
        TestUtil.assertContains("DeficientRow", this.analysisReport, 2);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 3);
        TestUtil.assertDoesNotContain("DeficientRow", this.analysisReport, 4);
    }

    private DecisionTableAnalyzer getDecisionTableAnalyzer(GuidedDecisionTable52 table52) {
        return new DecisionTableAnalyzer((PlaceRequest)Mockito.mock(PlaceRequest.class), this.oracle, table52, (EventBus)Mockito.mock(EventBus.class)){

            protected void sendReport(AnalysisReport report) {
                DecisionTableAnalyzerDeficiencyTest.this.analysisReport = report;
            }

            protected Checks getChecks() {
                return new Checks(){

                    protected void doRun(CancellableRepeatingCommand command) {
                        while (command.execute()) {
                        }
                    }
                };
            }

            protected ParameterizedCommand<Status> getOnStatusCommand() {
                return null;
            }

            protected Command getOnCompletionCommand() {
                return new Command(){

                    public void execute() {
                        this.sendReport(this.makeAnalysisReport());
                    }
                };
            }
        };
    }
}

