/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ValidateEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Checks;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateColumnDataEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerFromFileTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    @Mock
    AsyncPackageDataModelOracle oracle;
    private AnalysisReport analysisReport;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
    }

    @Test
    public void testFile1() throws Exception {
        String xml = DecisionTableAnalyzerFromFileTest.loadResource("Pricing loans.gdst");
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(GuidedDTXMLPersistence.getInstance().unmarshal(xml));
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
    }

    @Test
    public void testFile2() throws Exception {
        String xml = DecisionTableAnalyzerFromFileTest.loadResource("Large file.gdst");
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(GuidedDTXMLPersistence.getInstance().unmarshal(xml));
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
    }

    @Test
    public void testFile2WithUpdate() throws Exception {
        long baseline = System.currentTimeMillis();
        String xml = DecisionTableAnalyzerFromFileTest.loadResource("Large file.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        long now = System.currentTimeMillis();
        System.out.println("Loading of model took.. " + (now - baseline) + " ms");
        baseline = now;
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
        now = System.currentTimeMillis();
        System.out.println("Initial analysis took.. " + (now - baseline) + " ms");
        baseline = now;
        ((DTCellValue52)((List)table52.getData().get(2)).get(6)).clearValues();
        HashMap updates = new HashMap();
        updates.put(new Coordinate(2, 6), new ArrayList());
        analyzer.onValidate(new ValidateEvent(updates));
        Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
        now = System.currentTimeMillis();
        System.out.println("Partial analysis took.. " + (now - baseline) + " ms");
    }

    @Test
    public void testFile2WithDeletes() throws Exception {
        String xml = DecisionTableAnalyzerFromFileTest.loadResource("Large file.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
        for (int iterations = 0; iterations < 10; ++iterations) {
            analyzer.onDeleteRow(new DeleteRowEvent(100));
            table52.getData().remove(100);
            analyzer.onUpdateColumnData(new UpdateColumnDataEvent(0, new ArrayList()));
            Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
        }
    }

    private DecisionTableAnalyzer getDecisionTableAnalyzer(GuidedDecisionTable52 table52) {
        return new DecisionTableAnalyzer((PlaceRequest)Mockito.mock(PlaceRequest.class), this.oracle, table52, (EventBus)Mockito.mock(EventBus.class)){

            protected void sendReport(AnalysisReport report) {
                DecisionTableAnalyzerFromFileTest.this.analysisReport = report;
            }

            protected Checks getChecks() {
                return new Checks(){

                    protected void doRun(CancellableRepeatingCommand command) {
                        while (command.execute()) {
                        }
                    }
                };
            }

            protected ParameterizedCommand<Status> getOnStatusCommand() {
                return null;
            }

            protected Command getOnCompletionCommand() {
                return new Command(){

                    public void execute() {
                        this.sendReport(this.makeAnalysisReport());
                    }
                };
            }
        };
    }

    public static String loadResource(String name) throws Exception {
        InputStream in = DecisionTableAnalyzerFromFileTest.class.getResourceAsStream(name);
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }
}

