/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.TestUtil;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ValidateEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Checks;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerRedundancyTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    @Mock
    AsyncPackageDataModelOracle oracle;
    private AnalysisReport analysisReport;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
        Mockito.when((Object)this.oracle.getFieldType("LoanApplication", "amount")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.oracle.getFieldType("LoanApplication", "lengthYears")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.oracle.getFieldType("LoanApplication", "deposit")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.oracle.getFieldType("LoanApplication", "approved")).thenReturn((Object)"Boolean");
        Mockito.when((Object)this.oracle.getFieldType("LoanApplication", "insuranceCost")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.oracle.getFieldType("LoanApplication", "approvedRate")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.oracle.getFieldType("IncomeSource", "type")).thenReturn((Object)"String");
        Mockito.when((Object)this.oracle.getFieldType("Person", "name")).thenReturn((Object)"String");
    }

    @Test
    public void testNoIssues() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("application", "LoanApplication", "amount", ">").withConditionIntegerColumn("application", "LoanApplication", "amount", "<=").withConditionIntegerColumn("application", "LoanApplication", "lengthYears", "==").withConditionIntegerColumn("application", "LoanApplication", "deposit", "<").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "Boolean").withActionSetField("application", "insuranceCost", "Integer").withActionSetField("application", "approvedRate", "Integer").withData(new Object[][]{{1, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {2, "description", 10000, 100000, 20, 2000, "Job", true, 0, 4}, {3, "description", 100001, 130000, 20, 3000, "Job", true, 10, 6}, {4, "description", null, null, null, null, null, null, null, null}, {5, "description", null, null, null, null, null, null, null, null}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(1)", this.analysisReport);
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(2)", this.analysisReport);
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(3)", this.analysisReport);
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(4)", this.analysisReport);
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(5)", this.analysisReport);
    }

    @Test
    public void testNoIssues2() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("application", "LoanApplication", "amount", ">").withConditionIntegerColumn("application", "LoanApplication", "amount", "<=").withConditionIntegerColumn("application", "LoanApplication", "lengthYears", "==").withConditionIntegerColumn("application", "LoanApplication", "deposit", "<").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "Boolean").withActionSetField("application", "insuranceCost", "Integer").withActionSetField("application", "approvedRate", "Integer").withData(new Object[][]{{1, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {2, "description", 1000, 200000, 30, 20000, "Asset", true, 0, 2}, {3, "description", 100001, 130000, 20, 3000, "Job", true, 10, 6}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(1)", this.analysisReport);
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(2)", this.analysisReport);
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(3)", this.analysisReport);
    }

    @Test
    public void testRedundantRows001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withNumericColumn("application", "LoanApplication", "amount", ">").withNumericColumn("application", "LoanApplication", "amount", "<=").withNumericColumn("application", "LoanApplication", "lengthYears", "==").withNumericColumn("application", "LoanApplication", "deposit", "<").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "Boolean").withActionSetField("application", "insuranceCost", "Numeric").withActionSetField("application", "approvedRate", "Numeric").withData(new Object[][]{{1, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {2, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {3, "description", 100001, 130000, 20, 3000, "Job", true, 10, 6}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RedundantRows", this.analysisReport, 1);
        TestUtil.assertContains("RedundantRows", this.analysisReport, 2);
    }

    @Test
    public void testRedundantRows002() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withStringColumn("application", "LoanApplication", "amount", ">").withStringColumn("person", "Person", "name", "==").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "String").withData(new Object[][]{{1, "description", "131000", "Toni", "Asset", "true"}, {2, "description", "131000", "Toni", "Asset", "true"}, {3, "description", "100001", "Michael", "Job", "true"}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RedundantRows", this.analysisReport, 1);
        TestUtil.assertContains("RedundantRows", this.analysisReport, 2);
    }

    @Test
    public void testRedundantRows003() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withStringColumn("application", "LoanApplication", "amount", ">").withStringColumn("person", "Person", "name", "==").withEnumColumn("income", "IncomeSource", "type", "==", "Asset,Job").withActionSetField("application", "approved", "String").withData(new Object[][]{{1, "description", "131000", "Toni", "Asset", "true"}, {2, "description", "131000", "Toni", "Asset", "true"}, {3, "description", "100001", "Michael", "Job", "true"}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RedundantRows", this.analysisReport, 1);
        TestUtil.assertContains("RedundantRows", this.analysisReport, 2);
    }

    @Test
    public void testRedundantConditions001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withEnumColumn("a", "Person", "name", "==", "Toni,Eder").withConditionIntegerColumn("a", "Person", "name", "==").withData(new Object[][]{{1, "description", "Toni", "Toni"}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RedundantConditions", this.analysisReport);
    }

    @Test
    public void testRedundantRowsWithConflict() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withConditionIntegerColumn("d", "Account", "deposit", "<").withActionSetField("a", "approved", "Boolean").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 100, 0, true, true}, {2, "description", 100, 0, true, false}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(1)", this.analysisReport);
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(2)", this.analysisReport);
    }

    @Test
    public void testRedundantActionsInOneRow001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "name", "==").withActionSetField("a", "salary", "Integer").withActionSetField("a", "salary", "Integer").withData(new Object[][]{{1, "description", "Toni", 100, 100}, {2, "description", "Eder", 200, null}, {3, "description", "Michael", null, 300}, {4, "description", null, null, null, null, null}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("ValueForFactFieldIsSetTwice(a, salary)", this.analysisReport);
    }

    @Test
    public void testRedundantActionsInOneRow002() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "name", "==").withActionInsertFact("Person", "b", "salary", "Integer").withActionSetField("b", "salary", "Integer").withData(new Object[][]{{1, "description", "Toni", 100, 100}, {2, "description", "Eder", 200, null}, {3, "description", "Michael", null, 300}, {4, "description", null, null, null, null, null}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("ValueForFactFieldIsSetTwice(b, salary)", this.analysisReport);
    }

    private DecisionTableAnalyzer getDecisionTableAnalyzer(GuidedDecisionTable52 table52) {
        return new DecisionTableAnalyzer((PlaceRequest)Mockito.mock(PlaceRequest.class), this.oracle, table52, (EventBus)Mockito.mock(EventBus.class)){

            protected void sendReport(AnalysisReport report) {
                DecisionTableAnalyzerRedundancyTest.this.analysisReport = report;
            }

            protected Checks getChecks() {
                return new Checks(){

                    protected void doRun(CancellableRepeatingCommand command) {
                        while (command.execute()) {
                        }
                    }
                };
            }

            protected ParameterizedCommand<Status> getOnStatusCommand() {
                return null;
            }

            protected Command getOnCompletionCommand() {
                return new Command(){

                    public void execute() {
                        this.sendReport(this.makeAnalysisReport());
                    }
                };
            }
        };
    }
}

