/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.LimitedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.TestUtil;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ValidateEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Checks;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    @Mock
    AsyncPackageDataModelOracle oracle;
    private AnalysisReport analysisReport;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.oracle.getFieldType("Person", "age")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.oracle.getFieldType("Person", "approved")).thenReturn((Object)"Boolean");
        Mockito.when((Object)this.oracle.getFieldType("Person", "name")).thenReturn((Object)"String");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
    }

    @Test
    public void testEmpty() throws Exception {
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(new GuidedDecisionTable52());
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
    }

    @Test
    public void testEmptyRow() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withData(new Object[][]{{1, "description", ""}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
    }

    @Test
    public void testRuleHasNoAction() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withData(new Object[][]{{1, "description", 0}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RuleHasNoAction", this.analysisReport);
    }

    @Test
    public void testRuleHasNoActionSet() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withActionSetField("a", "age", "Integer").withActionSetField("a", "approved", "Boolean").withActionSetField("a", "name", "String").withData(new Object[][]{{1, "description", 0, null, null, ""}, {2, "description", null, null, null, null}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RuleHasNoAction", this.analysisReport, 1);
        TestUtil.assertDoesNotContain("RuleHasNoAction", this.analysisReport, 2);
    }

    @Test
    public void testRuleHasNoRestrictions() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", true}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RuleHasNoRestrictionsAndWillAlwaysFire", this.analysisReport);
    }

    @Test
    public void testRuleHasNoRestrictionsSet() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withStringColumn("a", "Person", "name", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", null, "", true}, {2, "description", null, null, null}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RuleHasNoRestrictionsAndWillAlwaysFire", this.analysisReport, 1);
        TestUtil.assertDoesNotContain("RuleHasNoRestrictionsAndWillAlwaysFire", this.analysisReport, 2);
    }

    @Test
    public void testMultipleValuesForOneAction() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withActionSetField("a", "approved", "Boolean").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 100, true, false}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onFocus();
        TestUtil.assertContains("MultipleValuesForOneAction", this.analysisReport);
    }

    @Test
    public void testRedundancy() throws Exception {
        GuidedDecisionTable52 table52 = new LimitedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withIntegerColumn("a", "Person", "age", "==", 0).withAction("a", "Person", "approved", new DTCellValue52(){
            {
                this.setBooleanValue(true);
            }
        }).withAction("a", "Person", "approved", new DTCellValue52(){
            {
                this.setBooleanValue(true);
            }
        }).withData(new Object[][]{{1, "description", true, true, false}, {2, "description", true, false, true}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RedundantRows", this.analysisReport, 1);
        TestUtil.assertContains("RedundantRows", this.analysisReport, 2);
    }

    @Test
    public void testOnFocus() throws Exception {
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(new GuidedDecisionTable52());
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        this.analysisReport = null;
        analyzer.onFocus();
        Assert.assertNotNull((Object)this.analysisReport);
    }

    private DecisionTableAnalyzer getDecisionTableAnalyzer(GuidedDecisionTable52 table52) {
        return new DecisionTableAnalyzer((PlaceRequest)Mockito.mock(PlaceRequest.class), this.oracle, table52, (EventBus)Mockito.mock(EventBus.class)){

            protected void sendReport(AnalysisReport report) {
                DecisionTableAnalyzerTest.this.analysisReport = report;
            }

            protected Checks getChecks() {
                return new Checks(){

                    protected void doRun(CancellableRepeatingCommand command) {
                        while (command.execute()) {
                        }
                    }
                };
            }

            protected ParameterizedCommand<Status> getOnStatusCommand() {
                return null;
            }

            protected Command getOnCompletionCommand() {
                return new Command(){

                    public void execute() {
                        this.sendReport(this.makeAnalysisReport());
                    }
                };
            }
        };
    }
}

