/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.TestUtil;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ValidateEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Checks;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.CellValue;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AfterColumnDeleted;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AfterColumnInserted;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AppendRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateColumnDataEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerUpdateTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    @Mock
    AsyncPackageDataModelOracle oracle;
    private AnalysisReport analysisReport;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
        this.oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        Mockito.when((Object)this.oracle.getFieldType("Person", "age")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.oracle.getFieldType("Person", "approved")).thenReturn((Object)"Boolean");
    }

    @Test
    public void testRowValueChange() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 1, true}, {2, "description", 1, true}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RedundantRows", this.analysisReport, 1);
        TestUtil.assertContains("RedundantRows", this.analysisReport, 2);
        ((DTCellValue52)((List)table52.getData().get(1)).get(2)).setNumericValue(Integer.valueOf(0));
        HashMap updates = new HashMap();
        updates.put(new Coordinate(1, 2), new ArrayList());
        analyzer.onValidate(new ValidateEvent(updates));
        this.assertColumnValuesAreEmpty(this.analysisReport);
    }

    @Test
    public void testRemoveRow() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withConditionIntegerColumn("a", "Person", "age", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 1, 1, true}, {2, "description", 0, 1, true}, {3, "description", 2, 2, true}, {4, "description", 1, 1, false}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("ConflictingRows", this.analysisReport, 4);
        TestUtil.assertContains("ImpossibleMatch", this.analysisReport, 2);
        table52.getData().remove(1);
        analyzer.onDeleteRow(new DeleteRowEvent(1));
        analyzer.onUpdateColumnData(new UpdateColumnDataEvent(0, this.getMockColumnData(table52.getData().size())));
        TestUtil.assertContains("ConflictingRows", this.analysisReport, 3);
        TestUtil.assertDoesNotContain("ImpossibleMatch", this.analysisReport, 3);
        ((DTCellValue52)((List)table52.getData().get(1)).get(3)).setNumericValue(Integer.valueOf(1));
        analyzer.onUpdateColumnData(new UpdateColumnDataEvent(0, this.getMockColumnData(table52.getData().size())));
        analyzer.onValidate(new ValidateEvent(this.getUpdates(1, 3)));
        TestUtil.assertContains("ImpossibleMatch", this.analysisReport, 2);
    }

    @Test
    public void testRemoveRow2() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withConditionIntegerColumn("a", "Person", "age", "<").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 1, 10, true}, {2, "description", 1, 10, true}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("RedundantRows", this.analysisReport, 1);
        TestUtil.assertContains("RedundantRows", this.analysisReport, 2);
        table52.getData().remove(0);
        analyzer.onDeleteRow(new DeleteRowEvent(0));
        analyzer.onUpdateColumnData(new UpdateColumnDataEvent(0, this.getMockColumnData(table52.getData().size())));
        Assert.assertTrue((boolean)this.analysisReport.getAnalysisData().isEmpty());
    }

    @Test
    public void testRemoveColumn() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 1, true}, {2, "description", 2, true}, {3, "description", 3, true}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        this.assertColumnValuesAreEmpty(this.analysisReport);
        table52.getActionCols().remove(0);
        ((List)table52.getData().get(0)).remove(3);
        ((List)table52.getData().get(1)).remove(3);
        ((List)table52.getData().get(2)).remove(3);
        analyzer.onAfterDeletedColumn(new AfterColumnDeleted());
        TestUtil.assertContains("RuleHasNoAction", this.analysisReport);
    }

    @Test
    public void testAddColumn() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 1, true}, {2, "description", 2, true}, {3, "description", 3, true}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        this.assertColumnValuesAreEmpty(this.analysisReport);
        table52.getActionCols().add(ExtendedGuidedDecisionTableBuilder.createActionSetField("a", "approved", "Boolean"));
        ((List)table52.getData().get(0)).add(new DTCellValue52(Boolean.valueOf(true)));
        ((List)table52.getData().get(1)).add(new DTCellValue52(Boolean.valueOf(true)));
        ((List)table52.getData().get(2)).add(new DTCellValue52(Boolean.valueOf(false)));
        analyzer.onAfterColumnInserted(new AfterColumnInserted());
        TestUtil.assertContains("MultipleValuesForOneAction", this.analysisReport, 3);
    }

    @Test
    public void testInsertRow() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withConditionIntegerColumn("a", "Person", "age", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 1, 1, true}, {2, "description", 0, 1, true}, {3, "description", 2, 2, true}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        table52.getData().add(0, new ArrayList());
        analyzer.onInsertRow(new InsertRowEvent(0));
        analyzer.onUpdateColumnData(new UpdateColumnDataEvent(0, this.getMockColumnData(table52.getData().size())));
        TestUtil.assertContains("ImpossibleMatch", this.analysisReport, 3);
    }

    @Test
    public void testAppendRow() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withConditionIntegerColumn("a", "Person", "age", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 1, 1, true}, {2, "description", 0, 1, true}, {3, "description", 2, 2, true}}).build();
        DecisionTableAnalyzer analyzer = this.getDecisionTableAnalyzer(table52);
        analyzer.onValidate(new ValidateEvent(new HashMap()));
        TestUtil.assertContains("ImpossibleMatch", this.analysisReport, 2);
        table52.getData().add(new ArrayList());
        analyzer.onAppendRow(new AppendRowEvent());
        analyzer.onUpdateColumnData(new UpdateColumnDataEvent(0, this.getMockColumnData(table52.getData().size())));
        TestUtil.assertContains("ImpossibleMatch", this.analysisReport, 2);
    }

    private ArrayList<CellValue<? extends Comparable<?>>> getMockColumnData(int size) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < size; ++i) {
            list.add((CellValue<Comparable<?>>)Mockito.mock(CellValue.class));
        }
        return list;
    }

    private HashMap<Coordinate, List<List<CellValue<? extends Comparable<?>>>>> getUpdates(int x, int y) {
        HashMap updates = new HashMap();
        updates.put(new Coordinate(x, y), new ArrayList());
        return updates;
    }

    private void assertColumnValuesAreEmpty(AnalysisReport report) {
        Assert.assertTrue((String)"Was not empty", (boolean)report.getAnalysisData().isEmpty());
    }

    private DecisionTableAnalyzer getDecisionTableAnalyzer(GuidedDecisionTable52 table52) {
        return new DecisionTableAnalyzer((PlaceRequest)Mockito.mock(PlaceRequest.class), this.oracle, table52, (EventBus)Mockito.mock(EventBus.class)){

            protected void sendReport(AnalysisReport report) {
                DecisionTableAnalyzerUpdateTest.this.analysisReport = report;
            }

            protected Checks getChecks() {
                return new Checks(){

                    protected void doRun(CancellableRepeatingCommand command) {
                        while (command.execute()) {
                        }
                    }
                };
            }

            protected ParameterizedCommand<Status> getOnStatusCommand() {
                return null;
            }

            protected Command getOnCompletionCommand() {
                return new Command(){

                    public void execute() {
                        this.sendReport(this.makeAnalysisReport());
                    }
                };
            }
        };
    }
}

