/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.NumericIntegerConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.StringConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.junit.Assert;

public class TestUtil {
    public static void assertContains(String expected, AnalysisReport result) {
        boolean foundIt = false;
        for (Issue issue : result.getAnalysisData()) {
            if (!issue.getTitle().contains(expected)) continue;
            foundIt = true;
            break;
        }
        Assert.assertTrue((String)("Could not find " + expected), (boolean)foundIt);
    }

    public static void assertDoesNotContain(String notExpected, AnalysisReport result) {
        boolean foundIt = false;
        for (Issue issue : result.getAnalysisData()) {
            if (!issue.getTitle().contains(notExpected)) continue;
            foundIt = true;
            break;
        }
        Assert.assertFalse((String)("Found " + notExpected), (boolean)foundIt);
    }

    public static void assertDoesNotContain(String notExpected, AnalysisReport result, int rowNumber) {
        boolean foundOne = false;
        for (Issue issue : result.getAnalysisData()) {
            if (!TestUtil.containsRowNumber(rowNumber, issue) || !issue.getTitle().contains(notExpected)) continue;
            foundOne = true;
            break;
        }
        Assert.assertFalse((String)("Found " + notExpected), (boolean)foundOne);
    }

    public static void assertContains(String expected, AnalysisReport result, int rowNumber) {
        boolean foundOne = false;
        for (Issue issue : result.getAnalysisData()) {
            if (!TestUtil.containsRowNumber(rowNumber, issue) || !issue.getTitle().contains(expected)) continue;
            foundOne = true;
            break;
        }
        Assert.assertTrue((String)("Could not find " + expected), (boolean)foundOne);
    }

    private static boolean containsRowNumber(int rowNumber, Issue issue) {
        for (Integer number : issue.getRowNumbers()) {
            if (rowNumber != number) continue;
            return true;
        }
        return false;
    }

    public static NumericIntegerConditionInspector getNumericIntegerCondition(Pattern52 pattern, String factField, String operator, int value) {
        return new NumericIntegerConditionInspector(pattern, factField, Integer.valueOf(value), operator);
    }

    public static StringConditionInspector getStringCondition(Pattern52 pattern, String factField, String operator, String value) {
        return new StringConditionInspector(pattern, factField, value, operator);
    }
}

