/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.action;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.ActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.ActionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.FactFieldColumnActionInspectorKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionInspectorConflictTest {
    @GwtMock
    DateTimeFormat dateTimeFormat;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
    }

    @Test
    public void testRedundancy001() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "name", "Toni");
        ActionInspector b = this.createSetActionInspector("person", "name", "Toni");
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy002() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "name", "Toni");
        ActionInspector b = this.createSetActionInspector("person", "name", "Rambo");
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy003() throws Exception {
        ActionInspector a = this.createSetActionInspector("person1", "name", "Toni");
        ActionInspector b = this.createSetActionInspector("person2", "name", "Toni");
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy004() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "name", new DTCellValue52(Boolean.valueOf(true)));
        ActionInspector b = this.createSetActionInspector("person", "name", "true");
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy005() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "name", new DTCellValue52(Boolean.valueOf(true)));
        ActionInspector b = this.createSetActionInspector("person", "name", "false");
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy006() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "age", new DTCellValue52(Integer.valueOf(20)));
        ActionInspector b = this.createSetActionInspector("person", "age", "20");
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy007() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "age", new DTCellValue52(Integer.valueOf(20)));
        ActionInspector b = this.createSetActionInspector("person", "age", "10");
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy008() throws Exception {
        Date date = new Date();
        ActionInspector a = this.createSetActionInspector("person", "birthDay", new DTCellValue52(date));
        ActionInspector b = this.createSetActionInspector("person", "birthDay", this.format(date));
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy009() throws Exception {
        Date value = new Date();
        ActionInspector a = this.createSetActionInspector("person", "birthDay", new DTCellValue52(value));
        ActionInspector b = this.createSetActionInspector("person", "birthDay", "29-Dec-1981");
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testConflict001() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "name", "Toni");
        ActionInspector b = this.createSetActionInspector("person", "name", "Rambo");
        Assert.assertTrue((boolean)a.conflicts((Object)b));
        Assert.assertTrue((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testConflict002() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "name", new DTCellValue52(Boolean.valueOf(true)));
        ActionInspector b = this.createSetActionInspector("person", "name", "false");
        Assert.assertTrue((boolean)a.conflicts((Object)b));
        Assert.assertTrue((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testNoConflict001() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "name", "Toni");
        ActionInspector b = this.createSetActionInspector("address", "street", "Rambo");
        Assert.assertFalse((boolean)a.conflicts((Object)b));
        Assert.assertFalse((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testNoConflict002() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "name", "Toni");
        ActionInspector b = this.createSetActionInspector("person", "name", "Toni");
        Assert.assertFalse((boolean)a.conflicts((Object)b));
        Assert.assertFalse((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testNoConflict003() throws Exception {
        ActionInspector a = this.createSetActionInspector("person", "name", new DTCellValue52(Boolean.valueOf(true)));
        ActionInspector b = this.createSetActionInspector("person", "name", "true");
        Assert.assertFalse((boolean)a.conflicts((Object)b));
        Assert.assertFalse((boolean)b.conflicts((Object)a));
    }

    private ActionInspector createSetActionInspector(String boundName, String factField, String stringValue) {
        return this.createSetActionInspector(stringValue, this.createActionSetFieldCol(boundName, factField));
    }

    private ActionInspector createSetActionInspector(String boundName, String factField, DTCellValue52 cell) {
        return new ActionInspector((ActionInspectorKey)new FactFieldColumnActionInspectorKey(this.createActionSetFieldCol(boundName, factField)), cell){

            protected String format(Date dateValue) {
                return ActionInspectorConflictTest.this.format(dateValue);
            }
        };
    }

    private String format(Date dateValue) {
        return new SimpleDateFormat(ApplicationPreferences.getDroolsDateFormat()).format(dateValue);
    }

    private ActionInspector createSetActionInspector(String stringValue, ActionSetFieldCol52 actionCol) {
        return new ActionInspector((ActionInspectorKey)new FactFieldColumnActionInspectorKey(actionCol), this.createStringValueCell(stringValue)){

            protected String format(Date dateValue) {
                return ActionInspectorConflictTest.this.format(dateValue);
            }
        };
    }

    private ActionSetFieldCol52 createActionSetFieldCol(String boundName, String factField) {
        ActionSetFieldCol52 actionCol = new ActionSetFieldCol52();
        actionCol.setBoundName(boundName);
        actionCol.setFactField(factField);
        return actionCol;
    }

    private DTCellValue52 createStringValueCell(String stringValue) {
        DTCellValue52 value = new DTCellValue52();
        value.setStringValue(stringValue);
        return value;
    }
}

