/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.UpdateHandler;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.ActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RowInspectorCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class RowInspectorCacheTest {
    private RowInspectorCache cache;
    private GuidedDecisionTable52 table52;
    @Mock
    private UpdateHandler updateHandler;
    @GwtMock
    DateTimeFormat dateTimeFormat;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withConditionIntegerColumn("a", "Person", "age", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 0, 1, true}, {2, "description", 0, 1, true}, {3, "description", 0, 1, true}, {4, "description", 0, 1, true}, {5, "description", 0, 1, false}, {6, "description", 0, 1, true}, {7, "description", 0, 1, true}}).build();
        this.cache = new RowInspectorCache((AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class), this.table52, this.updateHandler);
    }

    @Test
    public void testInit() throws Exception {
        for (RowInspector rowInspector : this.cache.all()) {
            if (rowInspector.getRowIndex() == 4) {
                Assert.assertFalse((boolean)((ActionInspector)rowInspector.getActions().allValues().get(0)).getValue().getBooleanValue());
                continue;
            }
            Assert.assertTrue((boolean)((ActionInspector)rowInspector.getActions().allValues().get(0)).getValue().getBooleanValue());
        }
        Assert.assertEquals((long)7L, (long)this.cache.all().size());
    }

    @Test
    public void testRemoveRow() throws Exception {
        this.cache.removeRow(3);
        Collection all = this.cache.all();
        Assert.assertEquals((long)6L, (long)all.size());
        ArrayList<Integer> rowNumbers = new ArrayList<Integer>();
        for (RowInspector rowInspector : all) {
            rowNumbers.add(rowInspector.getRowIndex());
        }
        Assert.assertTrue((boolean)rowNumbers.contains(0));
        Assert.assertTrue((boolean)rowNumbers.contains(1));
        Assert.assertTrue((boolean)rowNumbers.contains(2));
        Assert.assertTrue((boolean)rowNumbers.contains(3));
        Assert.assertTrue((boolean)rowNumbers.contains(4));
        Assert.assertTrue((boolean)rowNumbers.contains(5));
        Assert.assertFalse((boolean)rowNumbers.contains(6));
    }

    @Test
    public void testRemoveColumn() throws Exception {
        this.table52.getActionCols().clear();
        ((List)this.table52.getData().get(0)).remove(4);
        ((List)this.table52.getData().get(1)).remove(4);
        ((List)this.table52.getData().get(2)).remove(4);
        ((List)this.table52.getData().get(3)).remove(4);
        ((List)this.table52.getData().get(4)).remove(4);
        ((List)this.table52.getData().get(5)).remove(4);
        ((List)this.table52.getData().get(6)).remove(4);
        this.cache.reset();
        Collection all = this.cache.all();
        Assert.assertEquals((long)7L, (long)all.size());
        int expectedRowNumber = 0;
        for (RowInspector rowInspector : all) {
            Assert.assertEquals((long)expectedRowNumber++, (long)rowInspector.getRowIndex());
            Assert.assertTrue((boolean)rowInspector.getActions().isEmpty());
        }
    }

    @Test
    public void testUpdate() throws Exception {
        Assert.assertEquals((long)7L, (long)this.cache.all().size());
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        coordinates.add(new Coordinate(3, 3));
        List data = this.table52.getData();
        ((DTCellValue52)((List)data.get(3)).get(3)).setNumericValue(Integer.valueOf(0));
        ArgumentCaptor oldInspectorCaptor = ArgumentCaptor.forClass(RowInspector.class);
        ArgumentCaptor newInspectorCaptor = ArgumentCaptor.forClass(RowInspector.class);
        this.cache.updateRowInspectors(coordinates, this.table52.getData());
        ((UpdateHandler)Mockito.verify((Object)this.updateHandler)).updateRow((RowInspector)oldInspectorCaptor.capture(), (RowInspector)newInspectorCaptor.capture());
        Assert.assertEquals((long)3L, (long)((RowInspector)oldInspectorCaptor.getValue()).getRowIndex());
        Assert.assertEquals((long)3L, (long)((RowInspector)newInspectorCaptor.getValue()).getRowIndex());
        Assert.assertEquals((long)7L, (long)this.cache.all().size());
        int expectedRowNumber = 0;
        for (RowInspector rowInspector : this.cache.all()) {
            Assert.assertEquals((long)expectedRowNumber++, (long)rowInspector.getRowIndex());
        }
    }

    @Test
    public void testDoNotUpdateWhenDescriptionChanges() throws Exception {
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        coordinates.add(new Coordinate(1, 1));
        this.cache.updateRowInspectors(coordinates, this.table52.getData());
        ((UpdateHandler)Mockito.verify((Object)this.updateHandler, (VerificationMode)Mockito.never())).updateRow((RowInspector)Mockito.any(RowInspector.class), (RowInspector)Mockito.any(RowInspector.class));
    }
}

