/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RowInspectorCache;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Check;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Checks;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.PairCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.SingleCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;

@RunWith(value=GwtMockitoTestRunner.class)
public class ChecksTest {
    @Spy
    private Checks checks = new Checks(){

        protected ArrayList<Check> makeSingleRowChecks(RowInspector rowInspector) {
            ArrayList<Check> checks = new ArrayList<Check>();
            checks.add((Check)new MockSingleCheck(rowInspector));
            return checks;
        }

        protected ArrayList<Check> makePairRowChecks(RowInspector rowInspector, RowInspector other) {
            ArrayList<Check> checks = new ArrayList<Check>();
            checks.add((Check)new MockPairCheck(rowInspector, other));
            return checks;
        }

        protected void doRun(CancellableRepeatingCommand command) {
            while (command.execute()) {
            }
        }
    };
    @Mock
    private RowInspectorCache cache;
    private RowInspector rowInspector1;
    private RowInspector rowInspector2;
    private RowInspector rowInspector3;
    private ArrayList<RowInspector> rowInspectors;

    @Before
    public void setUp() throws Exception {
        this.rowInspector1 = this.mockRowInspector(1);
        this.rowInspector2 = this.mockRowInspector(2);
        this.rowInspector3 = this.mockRowInspector(3);
        this.rowInspectors = new ArrayList();
        this.rowInspectors.add(this.rowInspector1);
        this.rowInspectors.add(this.rowInspector2);
        this.rowInspectors.add(this.rowInspector3);
        Mockito.when((Object)this.cache.all()).thenReturn(this.rowInspectors);
        this.checks.add(this.rowInspector1);
        this.checks.add(this.rowInspector2);
        this.checks.add(this.rowInspector3);
    }

    @Test
    public void testChecksGetGenerated() throws Exception {
        Assert.assertEquals((long)3L, (long)this.checks.get(this.rowInspector1).size());
        Assert.assertEquals((long)3L, (long)this.checks.get(this.rowInspector2).size());
        Assert.assertEquals((long)3L, (long)this.checks.get(this.rowInspector3).size());
    }

    @Test
    public void testRemove() throws Exception {
        Collection removed = this.checks.remove(this.rowInspector2);
        Assert.assertEquals((long)5L, (long)removed.size());
        Assert.assertNotNull((Object)this.checks.get(this.rowInspector1));
        Assert.assertNull((Object)this.checks.get(this.rowInspector2));
        Assert.assertNotNull((Object)this.checks.get(this.rowInspector3));
    }

    @Test
    public void testRunTests() throws Exception {
        for (RowInspector rowInspector : this.cache.all()) {
            this.assertNoIssues(rowInspector);
        }
        this.checks.run();
        for (RowInspector rowInspector : this.cache.all()) {
            this.assertHasIssues(rowInspector);
        }
    }

    @Test
    public void testOnlyTestChanges() throws Exception {
        this.checks.run();
        RowInspector newRowInspector = this.mockRowInspector(3);
        this.rowInspectors.remove(this.rowInspector3);
        this.rowInspectors.add(newRowInspector);
        this.checks.update(this.rowInspector3, newRowInspector);
        Assert.assertNull((Object)this.checks.get(this.rowInspector3));
        Collection checks = this.checks.get(newRowInspector);
        Assert.assertEquals((long)3L, (long)checks.size());
        this.assertNoIssues(newRowInspector);
        this.checks.run();
        this.assertHasIssues(newRowInspector);
        Assert.assertEquals((long)3L, (long)this.checks.get(this.rowInspector1).size());
        Assert.assertEquals((long)3L, (long)this.checks.get(this.rowInspector2).size());
        Assert.assertEquals((long)3L, (long)this.checks.get(newRowInspector).size());
    }

    private RowInspector mockRowInspector(int rowNumber) {
        return new RowInspector(rowNumber, null, this.cache);
    }

    private void assertHasIssues(RowInspector rowInspector) {
        for (Check check : this.checks.get(rowInspector)) {
            Assert.assertTrue((boolean)check.hasIssues());
            Assert.assertEquals((Object)"1", (Object)check.getIssue().getTitle());
        }
    }

    private void assertNoIssues(RowInspector rowInspector) {
        for (Check check : this.checks.get(rowInspector)) {
            Assert.assertFalse((boolean)check.hasIssues());
        }
    }

    private class MockPairCheck
    extends PairCheck {
        int runCount;

        public MockPairCheck(RowInspector rowInspector, RowInspector other) {
            super(rowInspector, other);
            this.runCount = 0;
        }

        public void check() {
            this.hasIssues = true;
        }

        public Issue getIssue() {
            return new Issue(Severity.NOTE, ++this.runCount + "", new Integer[0]);
        }
    }

    private class MockSingleCheck
    extends SingleCheck {
        int runCount;

        public MockSingleCheck(RowInspector rowInspector) {
            super(rowInspector);
            this.runCount = 0;
        }

        public void check() {
            this.hasIssues = true;
        }

        public Issue getIssue() {
            return new Issue(Severity.NOTE, ++this.runCount + "", new Integer[0]);
        }
    }
}

