/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ComparableConditionInspector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class ComparableConditionInspectorConflictTest {
    private final Comparable value1;
    private final Comparable value2;
    private final String operator1;
    private final String operator2;
    private final boolean conflictExpected;

    @Test
    public void parametrizedTest() {
        ComparableConditionInspector a = this.getCondition(this.value1, this.operator1);
        ComparableConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescriptionConflict(a, b, this.conflictExpected), (Object)this.conflictExpected, (Object)a.conflicts((Object)b));
        Assert.assertEquals((String)this.getAssertDescriptionConflict(a, b, this.conflictExpected), (Object)this.conflictExpected, (Object)a.conflicts((Object)b));
        Assert.assertEquals((String)this.getAssertDescriptionOverlap(a, b, !this.conflictExpected), (Object)(!this.conflictExpected ? 1 : 0), (Object)a.overlaps((Object)b));
        Assert.assertEquals((String)this.getAssertDescriptionOverlap(b, a, !this.conflictExpected), (Object)(!this.conflictExpected ? 1 : 0), (Object)b.overlaps((Object)a));
    }

    public ComparableConditionInspectorConflictTest(String operator1, Comparable value1, String operator2, Comparable value2, boolean conflictExpected) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.conflictExpected = conflictExpected;
    }

    private String getAssertDescriptionConflict(ComparableConditionInspector a, ComparableConditionInspector b, boolean conflictExpected) {
        return String.format("Expected condition '%s' %sto conflict with condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", b.toHumanReadableString());
    }

    private String getAssertDescriptionOverlap(ComparableConditionInspector a, ComparableConditionInspector b, boolean conflictExpected) {
        return String.format("Expected condition '%s' %sto overlap with condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", b.toHumanReadableString());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0.5, "==", 0.5, false}, {"!=", 0.5, "!=", 0.5, false}, {">", 0.5, ">", 0.5, false}, {">=", 0.5, ">=", 0.5, false}, {"<", 0.5, "<", 0.5, false}, {"<=", 0.5, "<=", 0.5, false}, {"==", 0.5, "!=", 1.5, false}, {"==", 0.5, ">", -1.5, false}, {"==", 0.5, ">", -10.5, false}, {"==", 0.5, ">=", 0.5, false}, {"==", 0.5, ">=", -10.5, false}, {"==", 0.5, "<", 1.5, false}, {"==", 0.5, "<", 10.5, false}, {"==", 0.5, "<=", 0.5, false}, {"==", 0.5, "<=", 10.5, false}, {"==", 0.5, "==", 1.5, true}, {"==", 0.5, "!=", 0.5, true}, {"==", 0.5, ">", 0.5, true}, {"==", 0.5, ">", 10.5, true}, {"==", 0.5, ">=", 1.5, true}, {"==", 0.5, ">=", 10.5, true}, {"==", 0.5, "<", 0.5, true}, {"==", 0.5, "<", -10.5, true}, {"==", 0.5, "<=", -1.5, true}, {"==", 0.5, "<=", -10.5, true}, {"!=", 0.5, "!=", 1.5, false}, {"!=", 0.5, ">", -1.5, false}, {"!=", 0.5, ">=", 0.5, false}, {"!=", 0.5, "<", 1.5, false}, {"!=", 0.5, "<=", 0.5, false}, {">", 0.5, ">", 1.5, false}, {">", 0.5, ">=", 0.5, false}, {">", 0.5, "<", 2.5, false}, {">", 0.5, "<", 10.5, false}, {">", 0.5, "<=", 1.5, false}, {">", 0.5, "<=", 10.5, false}, {">", 0.5, "<", -1.5, true}, {">", 0.5, "<", 0.5, true}, {">", 0.5, "<", 1.5, false}, {">", 0.5, "<=", -2.5, true}, {">", 0.5, "<=", -1.5, true}, {">", 0.5, "<=", 0.5, true}, {">=", 0.5, ">=", 1.5, false}, {">=", 0.5, "<", 1.5, false}, {">=", 0.5, "<", 10.5, false}, {">=", 0.5, "<=", 0.5, false}, {">=", 0.5, "<=", 10.5, false}, {">=", 0.5, "<", -2.5, true}, {">=", 0.5, "<", -1.5, true}, {">=", 0.5, "<", 0.5, true}, {">=", 0.5, "<=", -3.5, true}, {">=", 0.5, "<=", -2.5, true}, {">=", 0.5, "<=", -1.5, true}, {"<", 0.5, "<", 1.5, false}, {"<", 0.5, "<=", 0.5, false}, {"<=", 0.5, "<=", 1.5, false}, {"after", new Date(0L), "after", new Date(0L), false}, {"before", new Date(0L), "before", new Date(0L), false}, {"after", new Date(10000L), "before", new Date(20000L), false}, {"after", new Date(20000L), "before", new Date(10000L), true});
    }

    private ComparableConditionInspector getCondition(Comparable value, String operator) {
        return new ComparableConditionInspector((Pattern52)Mockito.mock(Pattern52.class), "age", value, operator);
    }
}

