/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.utils.GuidedDecisionTableUtils;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.BooleanConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ComparableConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspectorBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.NumericIntegerConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.StringConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.UnrecognizedConditionInspector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class ConditionInspectorBuilderTest {
    private final GuidedDecisionTableUtils utils = (GuidedDecisionTableUtils)Mockito.mock(GuidedDecisionTableUtils.class);
    private final ConditionCol52 conditionColumn = (ConditionCol52)Mockito.mock(ConditionCol52.class);
    private final ConditionInspectorBuilder ciBuilder = new ConditionInspectorBuilder(this.utils, (Pattern52)Mockito.mock(Pattern52.class), this.conditionColumn, (DTCellValue52)Mockito.mock(DTCellValue52.class));
    private final String type;
    private final Class expectedInspector;

    public ConditionInspectorBuilderTest(String type, Class expectedInspector) {
        this.type = type;
        this.expectedInspector = expectedInspector;
    }

    @Test
    public void testBuildConditionInspector() {
        Mockito.when((Object)this.utils.getType((BaseColumn)this.conditionColumn)).thenReturn((Object)this.type);
        Mockito.when((Object)this.utils.getValueList((BaseColumn)this.conditionColumn)).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.conditionColumn.getOperator()).thenReturn((Object)"==");
        Assert.assertEquals((String)("For field type " + this.type), (Object)this.expectedInspector, this.ciBuilder.buildConditionInspector().getClass());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"Integer", NumericIntegerConditionInspector.class}, {"Long", ComparableConditionInspector.class}, {"Double", ComparableConditionInspector.class}, {"Float", ComparableConditionInspector.class}, {"BigDecimal", ComparableConditionInspector.class}, {"BigInteger", ComparableConditionInspector.class}, {"Short", ComparableConditionInspector.class}, {"Byte", ComparableConditionInspector.class}, {"Comparable", ComparableConditionInspector.class}, {"Date", ComparableConditionInspector.class}, {"String", StringConditionInspector.class}, {"Boolean", BooleanConditionInspector.class}, {"Collection", UnrecognizedConditionInspector.class}, {"Object", UnrecognizedConditionInspector.class});
    }
}

