/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.BooleanConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ComparableConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.EnumConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.NumericIntegerConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.StringConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.UnrecognizedConditionInspector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class ConditionInspectorTest {
    private static final List<String> ALL_VALUE_LIST = Arrays.asList("value", "val01", "val02");
    private final ConditionInspector a;
    private final ConditionInspector b;
    private final boolean inspectorsEqual;

    @Test
    public void testEquals() {
        Assert.assertEquals((String)this.getDescription(), (Object)this.inspectorsEqual, (Object)this.a.equals((Object)this.b));
        Assert.assertEquals((String)this.getDescription(), (Object)this.inspectorsEqual, (Object)this.b.equals((Object)this.a));
    }

    public ConditionInspectorTest(ConditionInspector a, ConditionInspector b, boolean inspectorsEqual) {
        this.a = a;
        this.b = b;
        this.inspectorsEqual = inspectorsEqual;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getData() {
        return Arrays.asList({ConditionInspectorTest.getStringCondition("strField", "value", "=="), ConditionInspectorTest.getStringCondition("strField", "value", "=="), true}, {ConditionInspectorTest.getStringCondition("strField", "value", "=="), ConditionInspectorTest.getStringCondition("strField", "value", "!="), false}, {ConditionInspectorTest.getStringCondition("strField", "val01", "=="), ConditionInspectorTest.getStringCondition("strField", "val02", "=="), false}, {ConditionInspectorTest.getStringCondition("strFld01", "value", "=="), ConditionInspectorTest.getStringCondition("strFld02", "value", "=="), false}, {ConditionInspectorTest.getBooleanCondition("boolField", true, "=="), ConditionInspectorTest.getBooleanCondition("boolField", true, "=="), true}, {ConditionInspectorTest.getBooleanCondition("boolField", true, "=="), ConditionInspectorTest.getBooleanCondition("boolField", true, "!="), false}, {ConditionInspectorTest.getBooleanCondition("boolField", true, "=="), ConditionInspectorTest.getBooleanCondition("boolField", false, "=="), false}, {ConditionInspectorTest.getBooleanCondition("boolFld01", true, "=="), ConditionInspectorTest.getBooleanCondition("boolFld02", true, "=="), false}, {ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(0), "=="), ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(0), "=="), true}, {ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(0), "=="), ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(0), "!="), false}, {ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(0), "=="), ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(1), "=="), false}, {ConditionInspectorTest.getComparableCondition("comparab01", Integer.valueOf(0), "=="), ConditionInspectorTest.getComparableCondition("comparab02", Integer.valueOf(0), "=="), false}, {ConditionInspectorTest.getEnumCondition("enumField", "value", "=="), ConditionInspectorTest.getEnumCondition("enumField", "value", "=="), true}, {ConditionInspectorTest.getEnumCondition("enumField", "value", "=="), ConditionInspectorTest.getEnumCondition("enumField", "value", "!="), false}, {ConditionInspectorTest.getEnumCondition("enumField", "val01", "=="), ConditionInspectorTest.getEnumCondition("enumField", "val02", "=="), false}, {ConditionInspectorTest.getEnumCondition("enumFld01", "value", "=="), ConditionInspectorTest.getEnumCondition("enumFld02", "value", "=="), false}, {ConditionInspectorTest.getNumericIntegerCondition("comparable", 0, "=="), ConditionInspectorTest.getNumericIntegerCondition("comparable", 0, "=="), true}, {ConditionInspectorTest.getNumericIntegerCondition("comparable", 0, "=="), ConditionInspectorTest.getNumericIntegerCondition("comparable", 0, "!="), false}, {ConditionInspectorTest.getNumericIntegerCondition("comparable", 0, "=="), ConditionInspectorTest.getNumericIntegerCondition("comparable", 1, "=="), false}, {ConditionInspectorTest.getNumericIntegerCondition("comparab01", 0, "=="), ConditionInspectorTest.getNumericIntegerCondition("comparab02", 0, "=="), false}, {ConditionInspectorTest.getStringCondition("strField", "value", "=="), ConditionInspectorTest.getBooleanCondition("boolField", true, "=="), false}, {ConditionInspectorTest.getStringCondition("strField", "value", "=="), ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(0), "=="), false}, {ConditionInspectorTest.getStringCondition("strField", "value", "=="), ConditionInspectorTest.getEnumCondition("enumField", "value", "=="), false}, {ConditionInspectorTest.getStringCondition("strField", "value", "=="), ConditionInspectorTest.getNumericIntegerCondition("comparable", 0, "=="), false}, {ConditionInspectorTest.getStringCondition("strField", "value", "=="), ConditionInspectorTest.getUnrecognizedCondition("randomField", "=="), false}, {ConditionInspectorTest.getBooleanCondition("boolField", true, "=="), ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(0), "=="), false}, {ConditionInspectorTest.getBooleanCondition("boolField", true, "=="), ConditionInspectorTest.getEnumCondition("enumField", "value", "=="), false}, {ConditionInspectorTest.getBooleanCondition("boolField", true, "=="), ConditionInspectorTest.getNumericIntegerCondition("comparable", 0, "=="), false}, {ConditionInspectorTest.getBooleanCondition("boolField", true, "=="), ConditionInspectorTest.getUnrecognizedCondition("randomField", "=="), false}, {ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(0), "=="), ConditionInspectorTest.getEnumCondition("enumField", "value", "=="), false}, {ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(0), "=="), ConditionInspectorTest.getNumericIntegerCondition("comparable", 0, "=="), false}, {ConditionInspectorTest.getComparableCondition("comparable", Integer.valueOf(0), "=="), ConditionInspectorTest.getUnrecognizedCondition("randomField", "=="), false}, {ConditionInspectorTest.getEnumCondition("enumField", "value", "=="), ConditionInspectorTest.getNumericIntegerCondition("comparable", 0, "=="), false}, {ConditionInspectorTest.getEnumCondition("enumField", "value", "=="), ConditionInspectorTest.getUnrecognizedCondition("randomField", "=="), false});
    }

    public String getDescription() {
        return String.format("Expected '%s' %sto be equal to '%s'.", this.a.toHumanReadableString(), this.inspectorsEqual ? "" : "not ", this.b.toHumanReadableString());
    }

    private static StringConditionInspector getStringCondition(String field, String value, String operator) {
        return new StringConditionInspector((Pattern52)Mockito.mock(Pattern52.class), field, value, operator);
    }

    private static BooleanConditionInspector getBooleanCondition(String field, Boolean value, String operator) {
        return new BooleanConditionInspector((Pattern52)Mockito.mock(Pattern52.class), field, value, operator);
    }

    private static ComparableConditionInspector getComparableCondition(String field, Comparable value, String operator) {
        return new ComparableConditionInspector((Pattern52)Mockito.mock(Pattern52.class), field, value, operator);
    }

    private static EnumConditionInspector getEnumCondition(String field, String value, String operator) {
        return new EnumConditionInspector((Pattern52)Mockito.mock(Pattern52.class), field, ALL_VALUE_LIST, value, operator);
    }

    private static NumericIntegerConditionInspector getNumericIntegerCondition(String field, Integer value, String operator) {
        return new NumericIntegerConditionInspector((Pattern52)Mockito.mock(Pattern52.class), field, value, operator);
    }

    private static UnrecognizedConditionInspector getUnrecognizedCondition(String field, String operator) {
        return new UnrecognizedConditionInspector((Pattern52)Mockito.mock(Pattern52.class), field, operator);
    }
}

