/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ComparableConditionInspector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class DoubleComparableConditionInspectorCoverTest {
    private final Comparable conditionValue;
    private final Comparable value;
    private final String conditionOperator;
    private final boolean coverExpected;

    @Test
    public void parametrizedTest() {
        ComparableConditionInspector a = this.getCondition(this.conditionValue, this.conditionOperator);
        Assert.assertEquals((String)this.getAssertDescription(a, this.value, this.coverExpected), (Object)this.coverExpected, (Object)a.covers(this.value));
    }

    public DoubleComparableConditionInspectorCoverTest(Comparable conditionValue, String conditionOperator, Comparable value, boolean coverExpected) {
        this.conditionValue = conditionValue;
        this.value = value;
        this.conditionOperator = conditionOperator;
        this.coverExpected = coverExpected;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({0.5, "==", 0.5, true}, {0.5, "<", 0.5, false}, {0.5, "<", 10.5, false}, {10.5, "<", 0.5, true}, {0.5, ">", 0.5, false}, {0.5, ">", 10.5, true}, {10.5, "==", 0.5, false}, {0.5, "==", 10.5, false}, {10.5, ">", 0.5, false}, {-1.5, ">", 0.5, true}, {0.5, ">", -1.5, false}, {-1.5, "==", 0.5, false}, {0.5, "==", -1.5, false}, {new Date(0L), "==", new Date(0L), true}, {new Date(0L), "==", new Date(1L), false}, {new Date(0L), "!=", new Date(0L), false}, {new Date(0L), "!=", new Date(1L), true}, {new Date(0L), "after", new Date(1L), true}, {new Date(1L), "after", new Date(0L), false}, {new Date(0L), "before", new Date(1L), false}, {new Date(1L), "before", new Date(0L), true});
    }

    private String getAssertDescription(ComparableConditionInspector a, Comparable b, boolean conflictExpected) {
        return String.format("Expected condition '%s' %sto cover value '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", b.toString());
    }

    private ComparableConditionInspector getCondition(Comparable value, String operator) {
        return new ComparableConditionInspector((Pattern52)Mockito.mock(Pattern52.class), "age", value, operator);
    }
}

