/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.NumericIntegerConditionInspector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class NumericIntegerConditionInspectorSubsumptionTest {
    private final Integer value1;
    private final Integer value2;
    private final String operator1;
    private final String operator2;
    private final boolean aSubsumesB;
    private final boolean bSubsumesA;

    @Test
    public void testASubsumesB() {
        NumericIntegerConditionInspector a = this.getCondition(this.value1, this.operator1);
        NumericIntegerConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(a, b, this.aSubsumesB), (Object)this.aSubsumesB, (Object)a.subsumes((Object)b));
    }

    @Test
    public void testBSubsumesA() {
        NumericIntegerConditionInspector a = this.getCondition(this.value1, this.operator1);
        NumericIntegerConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(b, a, this.bSubsumesA), (Object)this.bSubsumesA, (Object)b.subsumes((Object)a));
    }

    public NumericIntegerConditionInspectorSubsumptionTest(String operator1, Integer value1, String operator2, Integer value2, boolean aSubsumesB, boolean bSubsumesA) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.aSubsumesB = aSubsumesB;
        this.bSubsumesA = bSubsumesA;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0, "==", 0, true, true}, {"!=", 0, "!=", 0, true, true}, {">", 0, ">", 0, true, true}, {">=", 0, ">=", 0, true, true}, {"<", 0, "<", 0, true, true}, {"<=", 0, "<=", 0, true, true}, {"==", 0, "==", 1, false, false}, {"==", 0, "!=", 0, false, false}, {"==", 0, ">", 0, false, false}, {"==", 0, ">", 10, false, false}, {"==", 0, ">=", 1, false, false}, {"==", 0, ">=", 10, false, false}, {"==", 0, "<", 0, false, false}, {"==", 0, "<", -10, false, false}, {"==", 0, "<=", -1, false, false}, {"==", 0, "<=", -10, false, false}, {"==", 0, "!=", 1, true, false}, {"==", 0, ">", -1, false, true}, {"==", 0, ">", -10, false, true}, {"==", 0, ">=", 0, false, true}, {"==", 0, ">=", -10, false, true}, {"==", 0, "<", 1, false, true}, {"==", 0, "<", 10, false, true}, {"==", 0, "<=", 0, false, true}, {"==", 0, "<=", 10, false, true}, {"!=", 0, "!=", 1, false, false}, {"!=", 0, ">", -1, false, false}, {"!=", 0, ">", -10, false, false}, {"!=", 0, ">=", 0, false, false}, {"!=", 0, ">=", -10, false, false}, {"!=", 0, "<", 1, false, false}, {"!=", 0, "<", 10, false, false}, {"!=", 0, "<=", 0, false, false}, {"!=", 0, "<=", 10, false, false}, {"!=", 0, ">", 0, true, false}, {"!=", 0, ">", 10, true, false}, {"!=", 0, ">=", 1, true, false}, {"!=", 0, ">=", 10, true, false}, {"!=", 0, "<", 0, true, false}, {"!=", 0, "<", -10, true, false}, {"!=", 0, "<=", -1, true, false}, {"!=", 0, "<=", -10, true, false}, {">", 0, "<", 1, false, false}, {">", 0, "<", -10, false, false}, {">", 0, "<", 10, false, false}, {">", 0, "<=", 0, false, false}, {">", 0, "<=", -10, false, false}, {">", 0, "<=", 10, false, false}, {">", 0, ">", 1, true, false}, {">", 0, ">", 10, true, false}, {">", 0, ">=", 0, false, true}, {">", 0, ">=", 10, true, false}, {">=", 0, "<", 0, false, false}, {">=", 0, "<", -10, false, false}, {">=", 0, "<", 10, false, false}, {">=", 0, "<=", -1, false, false}, {">=", 0, "<=", -10, false, false}, {">=", 0, "<=", 10, false, false}, {">=", 0, ">=", 1, true, false}, {">=", 0, ">=", 10, true, false}, {"<", 0, "<", 1, false, true}, {"<", 0, "<", 10, false, true}, {"<", 0, "<=", 0, false, true}, {"<", 0, "<=", 10, false, true}, {"<=", 0, "<=", 1, false, true}, {"<=", 0, "<=", 10, false, true}, {">", 0, ">=", 1, true, true}, {"<", 0, "<=", -1, true, true});
    }

    private String getAssertDescription(NumericIntegerConditionInspector a, NumericIntegerConditionInspector b, boolean subsumptionExpected) {
        return String.format("Expected condition '%s' %sto subsume condition '%s':", a.toHumanReadableString(), subsumptionExpected ? "" : "not ", b.toHumanReadableString());
    }

    private NumericIntegerConditionInspector getCondition(int value, String operator) {
        return new NumericIntegerConditionInspector((Pattern52)Mockito.mock(Pattern52.class), "age", Integer.valueOf(value), operator);
    }
}

