/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Operator;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.StringConditionInspector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StringConditionInspectorCoverTest {
    private final String value1;
    private final String value2;
    private final String operator;
    private final boolean covers;

    @Test
    public void parametrizedTest() {
        StringConditionInspector a = this.getCondition(this.value1, this.operator);
        Assert.assertEquals((String)this.getAssertDescription(a, this.covers, this.value2), (Object)this.covers, (Object)a.covers((Comparable)((Object)this.value2)));
    }

    public StringConditionInspectorCoverTest(String value1, String operator, String value2, boolean covers) {
        this.operator = operator;
        this.value1 = value1;
        this.value2 = value2;
        this.covers = covers;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"toni", Operator.EQUALS.toString(), "toni", true}, {"toni", Operator.MATCHES.toString(), "toni", true}, {"toni", Operator.SOUNDSLIKE.toString(), "toni", true}, {"toni,eder", Operator.IN.toString(), "toni", true}, {"toni", Operator.GREATER_OR_EQUAL.toString(), "toni", true}, {"toni", Operator.LESS_OR_EQUAL.toString(), "toni", true}, {"toni", Operator.LESS_THAN.toString(), "toni", false}, {"toni", Operator.GREATER_THAN.toString(), "toni", false}, {"toni", Operator.EQUALS.toString(), "michael", false}, {"toni", Operator.MATCHES.toString(), "michael", false}, {"toni", Operator.SOUNDSLIKE.toString(), "michael", false}, {"toni,eder", Operator.IN.toString(), "michael", false}, {"toni", Operator.GREATER_OR_EQUAL.toString(), "michael", false}, {"toni", Operator.LESS_OR_EQUAL.toString(), "michael", false}, {"toni,eder", Operator.NOT_IN.toString(), "michael", true}, {"toni,eder", Operator.NOT_IN.toString(), "eder", false}, {"toni", Operator.NOT_EQUALS.toString(), "toni", false}, {"toni", Operator.NOT_EQUALS.toString(), "eder", true}, {"toni", Operator.NOT_MATCHES.toString(), "toni", false}, {"toni", Operator.NOT_MATCHES.toString(), "eder", true}, {"toni rikkola", Operator.STR_ENDS_WITH.toString(), "rikkola", true}, {"toni rikkola", Operator.STR_ENDS_WITH.toString(), "toni", false}, {"toni rikkola", Operator.STR_STARTS_WITH.toString(), "toni", true}, {"toni rikkola", Operator.STR_STARTS_WITH.toString(), "rikkola", false}, {"array", Operator.CONTAINS.toString(), "toni,eder", false}, {"array", Operator.CONTAINS.toString(), "toni", false}, {"array", Operator.CONTAINS.toString(), "eder", false}, {"array", Operator.NOT_CONTAINS.toString(), "toni,eder", false}, {"array", Operator.NOT_CONTAINS.toString(), "toni", false}, {"array", Operator.NOT_CONTAINS.toString(), "eder", false});
    }

    private StringConditionInspector getCondition(String value, String operator) {
        return new StringConditionInspector((Pattern52)Mockito.mock(Pattern52.class), "name", value, operator);
    }

    private String getAssertDescription(StringConditionInspector a, boolean covers, String condition) {
        return String.format("Expected condition '%s' to %s cover '%s':", a.toHumanReadableString(), covers ? "" : "not ", condition);
    }
}

