/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.StringConditionInspector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StringConditionInspectorRedundancyTest {
    private final String value1;
    private final String value2;
    private final String operator1;
    private final String operator2;
    private final boolean redundancyExpected;

    @Test
    public void parametrizedTest() {
        StringConditionInspector a = this.getCondition(this.value1, this.operator1);
        StringConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(a, b, this.redundancyExpected), (Object)this.redundancyExpected, (Object)a.isRedundant((Object)b));
        Assert.assertEquals((String)this.getAssertDescription(b, a, this.redundancyExpected), (Object)this.redundancyExpected, (Object)b.isRedundant((Object)a));
    }

    public StringConditionInspectorRedundancyTest(String operator1, String value1, String operator2, String value2, boolean redundancyExpected) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.redundancyExpected = redundancyExpected;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", "a", "==", "a", true}, {"!=", "a", "!=", "a", true}, {">", "a", ">", "a", true}, {">=", "a", ">=", "a", true}, {"<", "a", "<", "a", true}, {"<=", "a", "<=", "a", true}, {"in", "a,b", "in", "a,b", true}, {"not in", "a,b", "not in", "a,b", true}, {"matches", "a", "matches", "a", true}, {"soundslike", "a", "soundslike", "a", true}, {"==", "a", "==", "b", false}, {"==", "a", "!=", "a", false}, {"==", "a", ">", "a", false}, {"==", "a", ">=", "a", false}, {"==", "a", "<", "a", false}, {"==", "a", "<=", "a", false}, {"==", "a", "in", "a,b", false}, {"==", "a", "not in", "a,b", false}, {"==", "a", "in", "a", true}, {"!=", "a", "!=", "b", false}, {"!=", "a", ">", "a", false}, {"!=", "a", ">=", "a", false}, {"!=", "a", "<", "a", false}, {"!=", "a", "<=", "a", false}, {"!=", "a", "in", "a,b", false}, {"!=", "a", "not in", "a,b", false}, {"!=", "a", "not in", "a", true}, {">", "a", ">", "b", false}, {">", "a", ">=", "a", false}, {">", "a", "<", "a", false}, {">", "a", "<=", "a", false}, {">", "a", "in", "a,b", false}, {">", "a", "not in", "a,b", false}, {">=", "a", ">=", "b", false}, {">=", "a", "<", "a", false}, {">=", "a", "<=", "a", false}, {">=", "a", "in", "a,b", false}, {">=", "a", "not in", "a,b", false}, {"<", "a", "<", "b", false}, {"<", "a", "<=", "a", false}, {"<", "a", "in", "a,b", false}, {"<", "a", "not in", "a,b", false}, {"<=", "a", "<=", "b", false}, {"<=", "a", "in", "a,b", false}, {"<=", "a", "not in", "a,b", false}, {"in", "a", "in", "b", false}, {"in", "a", "not in", "a,b", false}, {"in", "a,b", "in", "b,a", true}, {"not in", "a", "not in", "b", false}, {"not in", "a,b", "not in", "b,a", true}, {">", "a", ">=", "b", false}, {"<", "b", "<=", "a", false});
    }

    private String getAssertDescription(StringConditionInspector a, StringConditionInspector b, boolean conflictExpected) {
        return String.format("Expected conditions '%s' and '%s' %sto be redundant:", a.toHumanReadableString(), b.toHumanReadableString(), conflictExpected ? "" : "not ");
    }

    private StringConditionInspector getCondition(String value, String operator) {
        return new StringConditionInspector((Pattern52)Mockito.mock(Pattern52.class), "name", value, operator);
    }
}

