/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.StringConditionInspector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StringConditionInspectorSubsumptionTest {
    private final String value1;
    private final String value2;
    private final String operator1;
    private final String operator2;
    private final boolean aSubsumesB;
    private final boolean bSubsumesA;

    @Test
    public void testASubsumesB() {
        StringConditionInspector a = this.getCondition(this.value1, this.operator1);
        StringConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(a, b, this.aSubsumesB), (Object)this.aSubsumesB, (Object)a.subsumes((Object)b));
    }

    @Test
    public void testBSubsumesA() {
        StringConditionInspector a = this.getCondition(this.value1, this.operator1);
        StringConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(b, a, this.bSubsumesA), (Object)this.bSubsumesA, (Object)b.subsumes((Object)a));
    }

    public StringConditionInspectorSubsumptionTest(String operator1, String value1, String operator2, String value2, boolean aSubsumesB, boolean bSubsumesA) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.aSubsumesB = aSubsumesB;
        this.bSubsumesA = bSubsumesA;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", "a", "==", "a", true, true}, {"!=", "a", "!=", "a", true, true}, {">", "a", ">", "a", true, true}, {">=", "a", ">=", "a", true, true}, {"<", "a", "<", "a", true, true}, {"<=", "a", "<=", "a", true, true}, {"in", "a,b", "in", "a,b", true, true}, {"not in", "a,b", "not in", "a,b", true, true}, {"matches", "a", "matches", "a", true, true}, {"soundslike", "a", "soundslike", "a", true, true}, {"==", "a", "soundslike", "a", true, true}, {"matches", "a", "soundslike", "a", true, true}, {"==", "a", "==", "b", false, false}, {"==", "a", "!=", "a", false, false}, {"==", "a", "!=", "b", false, true}, {"==", "a", ">", "a", false, false}, {"==", "a", ">", " ", false, false}, {"==", "a", ">=", "b", false, false}, {"==", "a", ">=", "a", false, true}, {"==", "a", ">=", " ", false, false}, {"==", "a", "<", "a", false, false}, {"==", "a", "<", "b", false, false}, {"==", "a", "<=", "a", false, true}, {"==", "a", "<=", " ", false, false}, {"==", "a", "<=", "b", false, false}, {"==", "a", "in", "a,b", false, true}, {"==", "a", "in", "b,c", false, false}, {"==", "a", "not in", "a,b", false, false}, {"==", "a", "not in", "b,c", false, true}, {"!=", "a", "!=", "b", false, false}, {"!=", "a", ">", " ", false, false}, {"!=", "a", ">", "b", false, false}, {"!=", "a", ">=", " ", false, false}, {"!=", "a", ">=", "a", false, false}, {"!=", "a", ">=", "b", false, false}, {"!=", "a", "<", "b", false, false}, {"!=", "a", "<", " ", false, false}, {"!=", "a", "<=", "b", false, false}, {"!=", "a", "<=", "a", false, false}, {"!=", "a", "<=", " ", false, false}, {"!=", "a", "in", "a,b", false, false}, {"!=", "a", "in", "b,c", true, false}, {"!=", "a", "not in", "a,b", false, true}, {"!=", "a", "not in", "b,c", false, false}, {">", "a", ">", "b", false, false}, {">", "a", ">=", "a", false, true}, {">", "a", ">=", "b", false, false}, {">", "a", "<", " ", false, false}, {">", "a", "<", "c", false, false}, {">", "a", "<=", " ", false, false}, {">", "a", "<=", "b", false, false}, {">", "a", "in", "a,b", false, false}, {">", "a", "in", "b,c", false, false}, {">", "a", "not in", "a,b", false, false}, {">", "a", "not in", "0,1", false, false}, {">=", "a", ">=", "b", false, false}, {">=", "a", "<", " ", false, false}, {">=", "a", "<", "b", false, false}, {">=", "a", "<=", " ", false, false}, {">=", "a", "<=", "c", false, false}, {">=", "a", "in", "0,b", false, false}, {">=", "a", "in", "b,c", false, false}, {">=", "a", "not in", "a,b", false, false}, {">=", "a", "not in", "0,1", false, false}, {"<", "a", "<", "b", false, false}, {"<", "a", "<=", " ", false, false}, {"<", "a", "<=", "c", false, false}, {"<", "a", "in", "a,b", false, false}, {"<", "a", "in", "0,1", false, false}, {"<", "a", "not in", "a,b", false, false}, {"<", "a", "not in", "0,1", false, false}, {"<=", "a", "<=", "b", false, false}, {"<=", "a", "in", "a,b", false, false}, {"<=", "a", "in", "0,1", false, false}, {"<=", "a", "not in", "b,c", false, false}, {"<=", "a", "not in", "0,1", false, false}, {"in", "a", "in", "a,b", false, true}, {"in", "b,a", "in", "a,b", true, true}, {"in", "a", "in", "0,1", false, false}, {"in", "a", "not in", "a,b", false, false}, {"in", "a", "not in", "b,c", false, true}, {"not in", "b,a", "not in", "a,b", true, true}, {"not in", "a", "not in", "a,b", false, true}, {"not in", "a", "not in", "b,c", false, false});
    }

    private String getAssertDescription(StringConditionInspector a, StringConditionInspector b, boolean conflictExpected) {
        return String.format("Expected condition '%s' %sto subsume condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", b.toHumanReadableString());
    }

    private StringConditionInspector getCondition(String value, String operator) {
        return new StringConditionInspector((Pattern52)Mockito.mock(Pattern52.class), "name", value, operator);
    }
}

