/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.StringConditionInspector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StringConditionInspectorToHumanReadableTest {
    private static final String FIELD_NAME = "name";
    private static final String VALUE = "someValue";
    private final String operator;

    @Test
    public void testToHumanReadableString() {
        StringConditionInspector inspector = new StringConditionInspector((Pattern52)Mockito.mock(Pattern52.class), FIELD_NAME, VALUE, this.operator);
        if (this.operator.equals("!= null")) {
            Assert.assertEquals((Object)String.format("%s %s", FIELD_NAME, this.operator), (Object)inspector.toHumanReadableString());
        } else if (this.operator.equals("== null")) {
            Assert.assertEquals((Object)String.format("%s %s", FIELD_NAME, this.operator), (Object)inspector.toHumanReadableString());
        } else {
            Assert.assertEquals((Object)String.format("%s %s %s", FIELD_NAME, this.operator, VALUE), (Object)inspector.toHumanReadableString());
        }
    }

    public StringConditionInspectorToHumanReadableTest(String operator) {
        this.operator = operator;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        ArrayList<String> data = new ArrayList<String>(Arrays.asList(OperatorsOracle.STRING_OPERATORS));
        data.addAll(Arrays.asList(OperatorsOracle.EXPLICIT_LIST_OPERATORS));
        ArrayList<Object[]> data2 = new ArrayList<Object[]>();
        for (String operator : data) {
            data2.add(new Object[]{operator});
        }
        return data2;
    }
}

