/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.handlers;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.handlers.GuidedDecisionTableOptions;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.wizard.NewGuidedDecisionTableWizard;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewGuidedDecisionTableHandler
extends DefaultNewResourceHandler {
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<GuidedDecisionTableEditorService> service;
    @Inject
    private GuidedDTableResourceType resourceType;
    @Inject
    private GuidedDecisionTableOptions options;
    @Inject
    private BusyIndicatorView busyIndicatorView;
    @Inject
    private AsyncPackageDataModelOracleFactory oracleFactory;
    @Inject
    private SyncBeanManager iocManager;
    private NewGuidedDecisionTableWizard wizard;
    private AsyncPackageDataModelOracle oracle;
    private NewResourcePresenter newResourcePresenter;

    @PostConstruct
    private void setupExtensions() {
        this.extensions.add(new Pair((Object)GuidedDecisionTableConstants.INSTANCE.Options(), (Object)this.options));
    }

    public String getDescription() {
        return GuidedDecisionTableConstants.INSTANCE.NewGuidedDecisionTableDescription();
    }

    public IsWidget getIcon() {
        return new Image(GuidedDecisionTableResources.INSTANCE.images().typeGuidedDecisionTable());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        this.newResourcePresenter = presenter;
        if (!this.options.isUsingWizard()) {
            this.createEmptyDecisionTable(pkg.getPackageMainResourcesPath(), baseFileName, this.options.getTableFormat());
        } else {
            this.createDecisionTableWithWizard(pkg.getPackageMainResourcesPath(), baseFileName, this.options.getTableFormat());
        }
    }

    private void createEmptyDecisionTable(Path contextPath, String baseFileName, GuidedDecisionTable52.TableFormat tableFormat) {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        model.setTableFormat(tableFormat);
        model.setTableName(baseFileName);
        this.save(contextPath, baseFileName, model);
    }

    private void createDecisionTableWithWizard(final Path contextPath, final String baseFileName, final GuidedDecisionTable52.TableFormat tableFormat) {
        ((GuidedDecisionTableEditorService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleBaselinePayload>(){

            public void callback(PackageDataModelOracleBaselinePayload dataModel) {
                NewGuidedDecisionTableHandler.this.newResourcePresenter.complete();
                NewGuidedDecisionTableHandler.this.oracle = NewGuidedDecisionTableHandler.this.oracleFactory.makeAsyncPackageDataModelOracle(contextPath, dataModel);
                NewGuidedDecisionTableHandler.this.wizard = (NewGuidedDecisionTableWizard)((Object)NewGuidedDecisionTableHandler.this.iocManager.lookupBean(NewGuidedDecisionTableWizard.class, new Annotation[0]).getInstance());
                NewGuidedDecisionTableHandler.this.wizard.setContent(contextPath, baseFileName, tableFormat, NewGuidedDecisionTableHandler.this.oracle, NewGuidedDecisionTableHandler.this);
                NewGuidedDecisionTableHandler.this.wizard.start();
            }
        })).loadDataModel(contextPath);
    }

    public void destroyWizard() {
        if (this.wizard != null) {
            this.iocManager.destroyBean((Object)this.wizard);
            this.wizard = null;
        }
    }

    public void save(Path contextPath, String baseFileName, GuidedDecisionTable52 model) {
        this.destroyWizard();
        this.oracleFactory.destroy(this.oracle);
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        ((GuidedDecisionTableEditorService)this.service.call(this.getSuccessCallback(this.newResourcePresenter), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).create(contextPath, this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType), (Object)model, "");
    }
}

