/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Window;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.UpdateHandler;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ValidateEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RowInspectorCache;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Check;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Checks;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreen;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.jboss.errai.ioc.client.container.IOC;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AfterColumnDeleted;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AfterColumnInserted;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AppendRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateColumnDataEvent;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

public class DecisionTableAnalyzer
implements ValidateEvent.Handler,
DeleteRowEvent.Handler,
AfterColumnDeleted.Handler,
UpdateColumnDataEvent.Handler,
AppendRowEvent.Handler,
InsertRowEvent.Handler,
AfterColumnInserted.Handler {
    private final Checks checks = this.getChecks();
    private final ParameterizedCommand<Status> onStatus = this.getOnStatusCommand();
    private final Command onCompletion = this.getOnCompletionCommand();
    private final PlaceRequest place;
    private final RowInspectorCache cache;
    private final GuidedDecisionTable52 model;
    private final EventManager eventManager = new EventManager();

    public DecisionTableAnalyzer(PlaceRequest place, AsyncPackageDataModelOracle oracle, GuidedDecisionTable52 model, EventBus eventBus) {
        this.place = place;
        this.model = model;
        this.cache = new RowInspectorCache(oracle, model, new UpdateHandler(){

            @Override
            public void updateRow(RowInspector oldRowInspector, RowInspector newRowInspector) {
                DecisionTableAnalyzer.this.checks.update(oldRowInspector, newRowInspector);
            }
        });
        eventBus.addHandler(ValidateEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DeleteRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(AfterColumnDeleted.TYPE, (EventHandler)this);
        eventBus.addHandler(UpdateColumnDataEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(AppendRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(InsertRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(AfterColumnInserted.TYPE, (EventHandler)this);
    }

    protected Checks getChecks() {
        return new Checks();
    }

    protected ParameterizedCommand<Status> getOnStatusCommand() {
        return new ParameterizedCommand<Status>(){

            public void execute(Status status) {
                Window.setTitle((String)AnalysisConstants.INSTANCE.AnalysingRows0To1Of2(status.getStartRowIndex(), status.getEndRowIndex(), status.getTotalRowCount()));
            }
        };
    }

    protected Command getOnCompletionCommand() {
        return new Command(){

            public void execute() {
                Window.setTitle((String)"");
                DecisionTableAnalyzer.this.sendReport(DecisionTableAnalyzer.this.makeAnalysisReport());
            }
        };
    }

    private void resetChecks() {
        for (RowInspector rowInspector : this.cache.all()) {
            this.checks.add(rowInspector);
        }
    }

    private void analyze() {
        this.checks.run(this.onStatus, this.onCompletion);
    }

    protected AnalysisReport makeAnalysisReport() {
        AnalysisReport report = new AnalysisReport(this.place);
        HashSet<Issue> unorderedIssues = new HashSet<Issue>();
        for (RowInspector rowInspector : this.cache.all()) {
            for (Check check : this.checks.get(rowInspector)) {
                if (!check.hasIssues()) continue;
                unorderedIssues.add(check.getIssue());
            }
        }
        report.setIssues(unorderedIssues);
        return report;
    }

    protected void sendReport(AnalysisReport report) {
        ((AnalysisReportScreen)IOC.getBeanManager().lookupBean(AnalysisReportScreen.class, new Annotation[0]).getInstance()).showReport(report);
    }

    @Override
    public void onValidate(ValidateEvent event) {
        if (event.getUpdates().isEmpty() || this.checks.isEmpty()) {
            this.resetChecks();
        } else {
            this.cache.updateRowInspectors(event.getUpdates().keySet(), this.model.getData());
        }
        this.analyze();
    }

    public void onAfterDeletedColumn(AfterColumnDeleted event) {
        this.cache.reset();
        this.resetChecks();
        this.analyze();
    }

    public void onAfterColumnInserted(AfterColumnInserted event) {
        this.cache.reset();
        this.resetChecks();
        this.analyze();
    }

    public void onUpdateColumnData(UpdateColumnDataEvent event) {
        if (this.hasTheRowCountIncreased(event)) {
            this.addRow(this.eventManager.getNewIndex());
            this.analyze();
        } else if (this.hasTheRowCountDecreased(event)) {
            RowInspector removed = this.cache.removeRow(this.eventManager.rowDeleted);
            this.checks.remove(removed);
            this.analyze();
        }
        this.eventManager.clear();
    }

    private boolean hasTheRowCountDecreased(UpdateColumnDataEvent event) {
        return this.cache.all().size() > event.getColumnData().size();
    }

    private boolean hasTheRowCountIncreased(UpdateColumnDataEvent event) {
        return this.cache.all().size() < event.getColumnData().size();
    }

    private void addRow(int index) {
        RowInspector rowInspector = this.cache.addRow(index, (List)this.model.getData().get(index));
        this.checks.add(rowInspector);
    }

    public void onDeleteRow(DeleteRowEvent event) {
        this.checks.cancelExistingAnalysis();
        this.eventManager.rowDeleted = event.getIndex();
    }

    public void onAppendRow(AppendRowEvent event) {
        this.checks.cancelExistingAnalysis();
        this.eventManager.rowAppended = true;
    }

    public void onInsertRow(InsertRowEvent event) {
        this.checks.cancelExistingAnalysis();
        this.eventManager.rowInserted = event.getIndex();
    }

    public void onFocus() {
        if (this.checks.isEmpty()) {
            this.resetChecks();
            this.analyze();
        } else {
            this.sendReport(this.makeAnalysisReport());
        }
    }

    public void onClose() {
        this.checks.cancelExistingAnalysis();
    }

    class EventManager {
        boolean rowAppended = false;
        Integer rowInserted = null;
        Integer rowDeleted = null;

        EventManager() {
        }

        public void clear() {
            this.rowAppended = false;
            this.rowInserted = null;
            this.rowDeleted = null;
        }

        int getNewIndex() {
            if (((DecisionTableAnalyzer)DecisionTableAnalyzer.this).eventManager.rowAppended) {
                return DecisionTableAnalyzer.this.model.getData().size() - 1;
            }
            if (((DecisionTableAnalyzer)DecisionTableAnalyzer.this).eventManager.rowInserted != null) {
                return ((DecisionTableAnalyzer)DecisionTableAnalyzer.this).eventManager.rowInserted;
            }
            throw new IllegalStateException("There are no active updates");
        }
    }
}

