/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.action;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.ActionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsConflicting;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsRedundant;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsSubsuming;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;

public class ActionInspector
implements IsRedundant,
IsSubsuming,
IsConflicting {
    protected final ActionInspectorKey key;
    private final DTCellValue52 value;
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat DATE_FORMATTER = DateTimeFormat.getFormat((String)DATE_FORMAT);

    public ActionInspector(ActionInspectorKey key, DTCellValue52 value) {
        this.key = key;
        this.value = value;
    }

    public ActionInspectorKey getKey() {
        return this.key;
    }

    public DTCellValue52 getValue() {
        return this.value;
    }

    @Override
    public boolean isRedundant(Object other) {
        if (other instanceof ActionInspector) {
            return this.key.equals(((ActionInspector)other).key) && this.isValueRedundant(((ActionInspector)other).value);
        }
        return false;
    }

    private boolean isValueRedundant(DTCellValue52 other) {
        if (this.value.equals((Object)other)) {
            return true;
        }
        if (this.isDataTypeString(this.value) && !this.isDataTypeString(other)) {
            return this.isStringValueEqualTo(this.value.getStringValue(), other);
        }
        if (!this.isDataTypeString(this.value) && this.isDataTypeString(other)) {
            return this.isStringValueEqualTo(other.getStringValue(), this.value);
        }
        return false;
    }

    private boolean isDataTypeString(DTCellValue52 value) {
        return value.getDataType().equals((Object)DataType.DataTypes.STRING);
    }

    private boolean isStringValueEqualTo(String stringValue, DTCellValue52 dtCellValue52) {
        switch (dtCellValue52.getDataType()) {
            case STRING: {
                return stringValue.equals(dtCellValue52.getStringValue());
            }
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                return stringValue.equals(dtCellValue52.getNumericValue().toString());
            }
            case DATE: {
                return stringValue.equals(this.format(dtCellValue52.getDateValue()));
            }
            case BOOLEAN: {
                return stringValue.equals(dtCellValue52.getBooleanValue().toString());
            }
        }
        return false;
    }

    protected String format(Date dateValue) {
        return DATE_FORMATTER.format(dateValue);
    }

    @Override
    public boolean conflicts(Object other) {
        if (other instanceof ActionInspector && this.key.equals(((ActionInspector)other).key) && this.hasValue() && ((ActionInspector)other).hasValue()) {
            return !this.isRedundant(other);
        }
        return false;
    }

    @Override
    public boolean subsumes(Object other) {
        return this.isRedundant(other);
    }

    public boolean hasValue() {
        switch (this.value.getDataType()) {
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                return this.value.getNumericValue() != null;
            }
            case BOOLEAN: {
                return this.value.getBooleanValue() != null;
            }
        }
        return this.value.getStringValue() != null && !this.value.getStringValue().isEmpty();
    }

    public String getValueAsString() {
        switch (this.value.getDataType()) {
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                return this.value.getNumericValue().toString();
            }
            case BOOLEAN: {
                return this.value.getBooleanValue().toString();
            }
        }
        return this.value.getStringValue();
    }

    public String toHumanReadableString() {
        return this.key.toHumanReadableString() + " = " + this.getValueAsString();
    }
}

