/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspectorGenerator;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.UpdateHandler;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.Conditions;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;

public class RowInspectorCache {
    private static final int ROW_NUMBER_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private final ArrayList<RowInspector> rowInspectorList = new ArrayList();
    private final RowInspectorGenerator rowInspectorGenerator;
    private final Conditions conditions = new Conditions();
    private final UpdateHandler updateHandler;

    public RowInspectorCache(AsyncPackageDataModelOracle oracle, GuidedDecisionTable52 model, UpdateHandler updateHandler) {
        this.rowInspectorGenerator = new RowInspectorGenerator(oracle, model, this);
        this.updateHandler = updateHandler;
        this.reset();
    }

    public void reset() {
        this.rowInspectorList.clear();
        this.conditions.clear();
        for (RowInspector rowInspector : this.rowInspectorGenerator.generate()) {
            this.add(rowInspector);
        }
    }

    public Collection<RowInspector> all() {
        return this.rowInspectorList;
    }

    public Collection<RowInspector> all(Filter filter) {
        ArrayList<RowInspector> result = new ArrayList<RowInspector>();
        for (RowInspector rowInspector : this.all()) {
            if (!filter.accept(rowInspector)) continue;
            result.add(rowInspector);
        }
        return result;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void updateRowInspectors(Set<Coordinate> coordinates, List<List<DTCellValue52>> data) {
        for (Coordinate coordinate : coordinates) {
            if (coordinate.getCol() == 0 || coordinate.getCol() == 1) continue;
            int rowIndex = coordinate.getRow();
            List<DTCellValue52> row = data.get(rowIndex);
            RowInspector oldRowInspector = this.rowInspectorList.get(rowIndex);
            RowInspector newRowInspector = this.rowInspectorGenerator.generate(rowIndex, row);
            this.rowInspectorList.set(rowIndex, newRowInspector);
            this.updateHandler.updateRow(oldRowInspector, newRowInspector);
            this.indexRowInspectors();
        }
    }

    private boolean add(RowInspector rowInspector) {
        boolean add = this.rowInspectorList.add(rowInspector);
        this.conditions.addAll(rowInspector.getConditions().allValues());
        this.indexRowInspectors();
        return add;
    }

    public RowInspector removeRow(int rowNumber) {
        RowInspector removed = this.rowInspectorList.remove(rowNumber);
        this.indexRowInspectors();
        return removed;
    }

    public RowInspector addRow(int index, List<DTCellValue52> row) {
        RowInspector rowInspector = this.rowInspectorGenerator.generate(index, row);
        this.rowInspectorList.add(index, rowInspector);
        this.conditions.addAll(rowInspector.getConditions().allValues());
        this.indexRowInspectors();
        return rowInspector;
    }

    private void indexRowInspectors() {
        for (int rowIndex = 0; rowIndex < this.rowInspectorList.size(); ++rowIndex) {
            RowInspector rowInspector = this.rowInspectorList.get(rowIndex);
            rowInspector.setRowIndex(rowIndex);
        }
    }

    public static interface Filter {
        public boolean accept(RowInspector var1);
    }
}

