/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.PairCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class DetectConflictingRowsCheck
extends PairCheck {
    public DetectConflictingRowsCheck(RowInspector rowInspector, RowInspector other) {
        super(rowInspector, other);
    }

    @Override
    public void check() {
        if (this.rowInspector.getActions().conflicts(this.other.getActions()) && this.other.getConditions().subsumes(this.rowInspector.getConditions())) {
            this.hasIssues = true;
        }
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.WARNING, AnalysisConstants.INSTANCE.ConflictingRows(), this.rowInspector.getRowIndex() + 1, this.other.getRowIndex() + 1);
        issue.getExplanation().addParagraph(AnalysisConstants.INSTANCE.ConflictingRowsP1()).addParagraph(AnalysisConstants.INSTANCE.ConflictingRowsP2());
        return issue;
    }
}

