/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.SingleCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class DetectImpossibleMatchCheck
extends SingleCheck {
    private final ArrayList<ConditionInspector> conflictingConditions = new ArrayList();
    private ConditionInspectorKey key;

    public DetectImpossibleMatchCheck(RowInspector rowInspector) {
        super(rowInspector);
    }

    @Override
    public void check() {
        for (ConditionInspectorKey key : this.rowInspector.getConditions().keys()) {
            if (!this.inspect(this.rowInspector.getConditions().get(key))) continue;
            this.key = key;
            this.hasIssues = true;
            return;
        }
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.ERROR, AnalysisConstants.INSTANCE.ImpossibleMatch(), this.rowInspector.getRowIndex() + 1);
        issue.getExplanation().startNote().addParagraph(AnalysisConstants.INSTANCE.ImpossibleMatchNote1P1(this.rowInspector.getRowIndex() + 1, this.key.getFactField(), this.key.getPattern().getFactType())).addParagraph(AnalysisConstants.INSTANCE.ImpossibleMatchNote1P2(this.conflictingConditions.get(0).toHumanReadableString(), this.conflictingConditions.get(1).toHumanReadableString())).end().addParagraph(AnalysisConstants.INSTANCE.ImpossibleMatchP1(this.key.getFactField()));
        return issue;
    }

    private boolean inspect(Collection<ConditionInspector> conditions) {
        ArrayList<ConditionInspector> conditionInspectors = new ArrayList<ConditionInspector>(conditions);
        for (int i = 0; i < conditionInspectors.size(); ++i) {
            for (int j = i + 1; j < conditionInspectors.size(); ++j) {
                if (!((ConditionInspector)conditionInspectors.get(i)).conflicts(conditionInspectors.get(j))) continue;
                this.conflictingConditions.add((ConditionInspector)conditionInspectors.get(i));
                this.conflictingConditions.add((ConditionInspector)conditionInspectors.get(j));
                return true;
            }
        }
        return false;
    }
}

