/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.PairCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class DetectRedundantRowsCheck
extends PairCheck {
    private boolean isRedundant;
    private boolean subsumes;

    public DetectRedundantRowsCheck(RowInspector rowInspector, RowInspector other) {
        super(rowInspector, other);
    }

    @Override
    public void check() {
        if (this.other.getActions().hasValues()) {
            if (this.rowInspector.isRedundant(this.other)) {
                this.hasIssues = true;
                this.isRedundant = true;
            } else if (this.rowInspector.subsumes(this.other)) {
                this.hasIssues = true;
                this.subsumes = true;
            }
        }
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.WARNING, this.getMessage(), this.rowInspector.getRowIndex() + 1, this.other.getRowIndex() + 1);
        this.setExplanation(issue);
        return issue;
    }

    private void setExplanation(Issue issue) {
        if (this.isRedundant) {
            issue.getExplanation().addParagraph(AnalysisConstants.INSTANCE.RedundantRowsP1()).addParagraph(AnalysisConstants.INSTANCE.RedundantRowsP2()).addParagraph(AnalysisConstants.INSTANCE.RedundantRowsP3());
        } else if (this.subsumes) {
            issue.getExplanation().addParagraph(AnalysisConstants.INSTANCE.SubsumptantRowsP1()).addParagraph(AnalysisConstants.INSTANCE.SubsumptantRowsP2());
        }
    }

    private String getMessage() {
        if (this.isRedundant) {
            return AnalysisConstants.INSTANCE.RedundantRows();
        }
        if (this.subsumes) {
            return AnalysisConstants.INSTANCE.SubsumptantRows();
        }
        return "";
    }
}

