/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.utils.GuidedDecisionTableUtils;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.BooleanConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ComparableConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.EnumConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.NumericIntegerConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.StringConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.UnrecognizedConditionInspector;

public class ConditionInspectorBuilder {
    private final GuidedDecisionTableUtils utils;
    private final Pattern52 pattern;
    private final ConditionCol52 conditionColumn;
    private final DTCellValue52 realCellValue;

    public ConditionInspectorBuilder(GuidedDecisionTableUtils utils, Pattern52 pattern, ConditionCol52 conditionColumn, DTCellValue52 realCellValue) {
        this.utils = utils;
        this.pattern = pattern;
        this.conditionColumn = conditionColumn;
        this.realCellValue = realCellValue;
    }

    public ConditionInspector buildConditionInspector() {
        String type = this.utils.getType((BaseColumn)this.conditionColumn);
        if (this.isTypeGuvnorEnum(this.conditionColumn)) {
            return new EnumConditionInspector(this.pattern, this.conditionColumn.getFactField(), Arrays.asList(this.utils.getValueList((BaseColumn)this.conditionColumn)), this.realCellValue.getStringValue(), this.conditionColumn.getOperator());
        }
        if (type == null) {
            return new UnrecognizedConditionInspector(this.pattern, this.conditionColumn.getFactField(), this.conditionColumn.getOperator());
        }
        if (type.equals("String")) {
            return new StringConditionInspector(this.pattern, this.conditionColumn.getFactField(), this.realCellValue.getStringValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("Numeric") || type.equals("BigDecimal")) {
            return new ComparableConditionInspector<BigDecimal>(this.pattern, this.conditionColumn.getFactField(), this.getBigDecimalValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("BigInteger")) {
            return new ComparableConditionInspector<BigInteger>(this.pattern, this.conditionColumn.getFactField(), this.getBigIntegerValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("Byte")) {
            return new ComparableConditionInspector<Byte>(this.pattern, this.conditionColumn.getFactField(), (Byte)this.realCellValue.getNumericValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("Double")) {
            return new ComparableConditionInspector<Double>(this.pattern, this.conditionColumn.getFactField(), this.getDoubleValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("Float")) {
            return new ComparableConditionInspector<Float>(this.pattern, this.conditionColumn.getFactField(), (Float)this.realCellValue.getNumericValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("Integer")) {
            return new NumericIntegerConditionInspector(this.pattern, this.conditionColumn.getFactField(), this.getIntegerValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("Long")) {
            return new ComparableConditionInspector<Long>(this.pattern, this.conditionColumn.getFactField(), this.getLongValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("Short")) {
            return new ComparableConditionInspector<Short>(this.pattern, this.conditionColumn.getFactField(), this.getShortValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("Boolean")) {
            return new BooleanConditionInspector(this.pattern, this.conditionColumn.getFactField(), this.realCellValue.getBooleanValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("Date")) {
            return new ComparableConditionInspector<Date>(this.pattern, this.conditionColumn.getFactField(), this.realCellValue.getDateValue(), this.conditionColumn.getOperator());
        }
        if (type.equals("Comparable")) {
            return new ComparableConditionInspector<String>(this.pattern, this.conditionColumn.getFactField(), this.realCellValue.getStringValue(), this.conditionColumn.getOperator());
        }
        return new UnrecognizedConditionInspector(this.pattern, this.conditionColumn.getFactField(), this.conditionColumn.getOperator());
    }

    private Short getShortValue() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Short)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return new Short(this.realCellValue.getStringValue());
    }

    private Long getLongValue() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Long)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return new Long(this.realCellValue.getStringValue());
    }

    private Double getDoubleValue() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Double)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return new Double(this.realCellValue.getStringValue());
    }

    private BigInteger getBigIntegerValue() {
        if (this.realCellValue.getNumericValue() != null) {
            return (BigInteger)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return new BigInteger(this.realCellValue.getStringValue());
    }

    private BigDecimal getBigDecimalValue() {
        if (this.realCellValue.getNumericValue() != null) {
            return (BigDecimal)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return new BigDecimal(this.realCellValue.getStringValue());
    }

    private Integer getIntegerValue() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Integer)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return new Integer(this.realCellValue.getStringValue());
    }

    private boolean isTypeGuvnorEnum(ConditionCol52 conditionColumn) {
        return this.utils.getValueList((BaseColumn)conditionColumn).length != 0;
    }
}

