/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsSubsuming;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Operator;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Redundancy;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ComparableConditionInspector;

public class StringConditionInspector
extends ComparableConditionInspector<String> {
    private final List<String> values = new ArrayList<String>();

    public StringConditionInspector(Pattern52 pattern, String factField, String value, String operator) {
        super(pattern, factField, value, operator);
        if (operator.equals("== null") || operator.equals("!= null")) {
            this.values.add("null");
        } else {
            switch (this.operator) {
                case NOT_IN: 
                case IN: {
                    for (String item : value.split(",")) {
                        this.values.add(item.trim());
                    }
                    break;
                }
                default: {
                    this.values.add(value);
                }
            }
        }
    }

    public List<String> getValues() {
        return this.values;
    }

    @Override
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public boolean isRedundant(Object other) {
        if (this.equals(other)) {
            return true;
        }
        if (other instanceof IsSubsuming) {
            boolean b = this.subsumes(other) && ((IsSubsuming)other).subsumes(this);
            return b;
        }
        return false;
    }

    @Override
    public boolean conflicts(Object other) {
        if (this.equals(other)) {
            return false;
        }
        if (other instanceof StringConditionInspector) {
            if (!this.hasValue() || !((StringConditionInspector)other).hasValue()) {
                return false;
            }
            if ((this.doesNotContainAll(((StringConditionInspector)other).getValues()) || ((StringConditionInspector)other).doesNotContainAll(this.getValues())) && (this.eitherOperatorIs((StringConditionInspector)other, Operator.LESS_THAN) || this.eitherOperatorIs((StringConditionInspector)other, Operator.LESS_OR_EQUAL) || this.eitherOperatorIs((StringConditionInspector)other, Operator.GREATER_THAN) || this.eitherOperatorIs((StringConditionInspector)other, Operator.GREATER_OR_EQUAL))) {
                return false;
            }
            if (this.operatorsAre((StringConditionInspector)other, Operator.NOT_EQUALS)) {
                return false;
            }
        }
        boolean conflicts = !this.overlaps(other);
        return conflicts;
    }

    private boolean eitherOperatorIs(StringConditionInspector other, Operator operator) {
        return other.getOperator().equals((Object)operator) || this.operator.equals((Object)operator);
    }

    @Override
    public boolean overlaps(Object other) {
        if (other instanceof StringConditionInspector) {
            StringConditionInspector otherInspector = (StringConditionInspector)other;
            if (((String)((Object)this.value)).isEmpty() || ((String)((StringConditionInspector)other).getValue()).isEmpty()) {
                return false;
            }
            if (this.operatorsAre(otherInspector, Operator.LESS_THAN) || this.operatorsAre(otherInspector, Operator.GREATER_THAN) || this.operatorsAre(otherInspector, Operator.LESS_OR_EQUAL) || this.operatorsAre(otherInspector, Operator.GREATER_OR_EQUAL) || this.operatorsAre(otherInspector, Operator.LESS_THAN, Operator.LESS_OR_EQUAL) || this.operatorsAre(otherInspector, Operator.GREATER_THAN, Operator.GREATER_OR_EQUAL)) {
                return true;
            }
            if (((String)((Object)this.value)).equals(otherInspector.getValue()) && this.operator.equals((Object)otherInspector.getOperator())) {
                return true;
            }
            if (((StringConditionInspector)other).getOperator().equals((Object)Operator.LESS_THAN) || this.operator.equals((Object)Operator.LESS_THAN) || ((StringConditionInspector)other).getOperator().equals((Object)Operator.GREATER_THAN) || this.operator.equals((Object)Operator.GREATER_THAN)) {
                return false;
            }
            if (!otherInspector.hasValue()) {
                return false;
            }
            switch (this.operator) {
                case EQUALS: 
                case MATCHES: 
                case SOUNDSLIKE: 
                case GREATER_OR_EQUAL: 
                case LESS_OR_EQUAL: {
                    switch (otherInspector.getOperator()) {
                        case NOT_EQUALS: {
                            return !otherInspector.containsAll(this.values);
                        }
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return otherInspector.containsAll(this.values);
                        }
                        case IN: {
                            return otherInspector.valuesContains(this.values.get(0));
                        }
                        case NOT_IN: {
                            return !otherInspector.valuesContains(this.values.get(0));
                        }
                    }
                    return super.overlaps(other);
                }
                case NOT_IN: {
                    switch (otherInspector.getOperator()) {
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return !this.valuesContains((String)otherInspector.getValue());
                        }
                        case IN: {
                            return this.doesNotContainAll(otherInspector.getValues());
                        }
                    }
                    return !otherInspector.containsAll(this.values);
                }
                case NOT_EQUALS: {
                    switch (otherInspector.getOperator()) {
                        case IN: {
                            return this.doesNotContainAll(((StringConditionInspector)other).getValues());
                        }
                        case NOT_EQUALS: {
                            return !otherInspector.containsAll(this.values);
                        }
                    }
                    return !otherInspector.valuesContains(this.values.get(0));
                }
                case IN: {
                    switch (otherInspector.getOperator()) {
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: 
                        case GREATER_OR_EQUAL: 
                        case LESS_OR_EQUAL: {
                            return this.valuesContains(otherInspector.getValues().get(0));
                        }
                        case NOT_EQUALS: {
                            return otherInspector.doesNotContainAll(this.getValues());
                        }
                        case NOT_IN: {
                            return this.doesNotContainAll(otherInspector.getValues());
                        }
                        case IN: {
                            return this.containsAny(otherInspector.values);
                        }
                    }
                }
            }
        }
        return super.overlaps(other);
    }

    private boolean operatorsAre(StringConditionInspector otherInspector, Operator operator) {
        return this.operator.equals((Object)operator) && otherInspector.getOperator().equals((Object)operator);
    }

    private boolean operatorsAre(StringConditionInspector otherInspector, Operator a, Operator b) {
        return this.operator.equals((Object)a) && otherInspector.getOperator().equals((Object)b) || this.operator.equals((Object)b) && otherInspector.getOperator().equals((Object)a);
    }

    @Override
    public boolean covers(Comparable<String> otherValue) {
        switch (this.operator) {
            case STR_STARTS_WITH: {
                return ((String)this.getValue()).startsWith(otherValue.toString());
            }
            case STR_ENDS_WITH: {
                return ((String)this.getValue()).endsWith(otherValue.toString());
            }
            case MATCHES: 
            case SOUNDSLIKE: {
                return this.valueIsEqualTo(otherValue);
            }
            case CONTAINS: {
                return false;
            }
            case NOT_MATCHES: {
                return !this.valueIsEqualTo(otherValue);
            }
            case IN: {
                return this.valuesContains(otherValue.toString());
            }
            case NOT_IN: {
                return !this.valuesContains(otherValue.toString());
            }
        }
        return super.covers(otherValue);
    }

    @Override
    protected boolean valueIsGreaterThanOrEqualTo(Comparable<String> otherValue) {
        return this.valueIsEqualTo(otherValue);
    }

    @Override
    protected boolean valueIsLessThanOrEqualTo(Comparable<String> otherValue) {
        return this.valueIsEqualTo(otherValue);
    }

    @Override
    protected boolean valueIsGreaterThan(Comparable<String> otherValue) {
        return false;
    }

    @Override
    protected boolean valueIsLessThan(Comparable<String> otherValue) {
        return false;
    }

    @Override
    protected boolean valueIsEqualTo(Comparable<String> otherValue) {
        return this.valuesContains(otherValue.toString());
    }

    private boolean valuesContains(String value) {
        return this.values.contains(value);
    }

    private boolean containsAll(List<String> otherValues) {
        if (this.values.isEmpty() || otherValues.isEmpty()) {
            return false;
        }
        for (String otherValue : otherValues) {
            if (this.values.contains(otherValue)) continue;
            return false;
        }
        return true;
    }

    private boolean doesNotContainAll(List<String> otherValues) {
        for (String otherValue : otherValues) {
            if (this.values.contains(otherValue)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAny(List<String> otherValues) {
        for (String thisValue : this.values) {
            for (String otherValue : otherValues) {
                if (!thisValue.equals(otherValue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean subsumes(Object other) {
        if (other instanceof StringConditionInspector) {
            if (((StringConditionInspector)other).getOperator().equals((Object)this.operator)) {
                boolean subsumes = Redundancy.subsumes(this.getValues(), ((StringConditionInspector)other).getValues());
                return subsumes;
            }
            switch (this.operator) {
                case EQUALS: 
                case MATCHES: 
                case SOUNDSLIKE: 
                case GREATER_OR_EQUAL: 
                case LESS_OR_EQUAL: {
                    if (this.operatorsAre((StringConditionInspector)other, Operator.LESS_OR_EQUAL) || this.operatorsAre((StringConditionInspector)other, Operator.GREATER_OR_EQUAL) || this.operatorsAre((StringConditionInspector)other, Operator.LESS_OR_EQUAL, Operator.LESS_THAN) || this.operatorsAre((StringConditionInspector)other, Operator.GREATER_OR_EQUAL, Operator.GREATER_THAN)) {
                        return ((String)this.getValue()).equals(((StringConditionInspector)other).getValue());
                    }
                    switch (((StringConditionInspector)other).getOperator()) {
                        case IN: 
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return ((String)this.getValue()).equals(((StringConditionInspector)other).getValue());
                        }
                    }
                    break;
                }
                case IN: {
                    switch (((StringConditionInspector)other).getOperator()) {
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return this.getValues().contains(((StringConditionInspector)other).getValues().get(0));
                        }
                    }
                    break;
                }
                case NOT_IN: {
                    switch (((StringConditionInspector)other).getOperator()) {
                        case IN: 
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return !this.containsAll(((StringConditionInspector)other).getValues());
                        }
                        case NOT_EQUALS: {
                            return this.getValues().contains(((StringConditionInspector)other).getValue());
                        }
                    }
                    break;
                }
                case NOT_EQUALS: {
                    switch (((StringConditionInspector)other).getOperator()) {
                        case NOT_IN: {
                            return ((String)this.getValue()).equals(((StringConditionInspector)other).getValue());
                        }
                        case IN: {
                            return !((StringConditionInspector)other).getValues().contains(this.getValue());
                        }
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return !((String)this.getValue()).equals(((StringConditionInspector)other).getValue());
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasValue() {
        return this.values != null && !this.values.isEmpty() && this.hasAValueSetInList();
    }

    @Override
    public String toHumanReadableString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getFactField());
        stringBuilder.append(" ");
        stringBuilder.append((Object)this.operator);
        stringBuilder.append(" ");
        Iterator<String> iterator = this.getValues().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private boolean hasAValueSetInList() {
        for (String value : this.values) {
            if (value == null || value.trim().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

