/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardPagingPolicy;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisLineCell;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreen;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreenView;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssuePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;

public class AnalysisReportScreenViewImpl
extends Composite
implements AnalysisReportScreenView,
RequiresResize {
    private AnalysisReportScreen presenter;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField(provided=true)
    CellList<Issue> issuesList;
    @UiField(provided=true)
    IssuePresenter issueDetails;
    @UiField
    ScrollPanel issuesListContainer;

    @Inject
    public AnalysisReportScreenViewImpl(IssuePresenter issueDetails) {
        this.makeIssuesList();
        this.issueDetails = issueDetails;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    private void makeIssuesList() {
        this.issuesList = new CellList((Cell)new AnalysisLineCell());
        this.issuesList.setKeyboardPagingPolicy(HasKeyboardPagingPolicy.KeyboardPagingPolicy.INCREASE_RANGE);
        this.issuesList.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION);
        this.issuesList.setSelectionModel(this.getSelectionModel());
    }

    private SingleSelectionModel<Issue> getSelectionModel() {
        final SingleSelectionModel selectionModel = new SingleSelectionModel();
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                AnalysisReportScreenViewImpl.this.presenter.onSelect((Issue)selectionModel.getSelectedObject());
            }
        });
        return selectionModel;
    }

    @Override
    public void setUpDataProvider(ListDataProvider<Issue> dataProvider) {
        dataProvider.addDataDisplay(this.issuesList);
    }

    @Override
    public void setPresenter(AnalysisReportScreen presenter) {
        this.presenter = presenter;
    }

    @Override
    public void show(Issue issue) {
        this.issueDetails.show(issue);
    }

    @Override
    public void clearIssue() {
        this.issueDetails.clear();
    }

    public void onResize() {
        this.setHeight(this.getParent().getOffsetHeight() + "px");
        this.setWidth(this.getParent().getOffsetWidth() - 15 + "px");
    }

    static interface Binder
    extends UiBinder<Widget, AnalysisReportScreenViewImpl> {
    }
}

