/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;

public class TableBuilder<T> {
    private final SafeHtmlBuilder htmlBuilder;
    private final T parent;
    private boolean oddRow = false;

    public TableBuilder(SafeHtmlBuilder htmlBuilder, T parent) {
        this.htmlBuilder = htmlBuilder;
        this.parent = parent;
        htmlBuilder.appendHtmlConstant("<table class='" + GuidedDecisionTableResources.INSTANCE.analysisCss().exampleTable() + "'>");
    }

    public T end() {
        this.htmlBuilder.appendHtmlConstant("</table>");
        return this.parent;
    }

    public HeaderBuilder startHeader() {
        return new HeaderBuilder();
    }

    public RowBuilder startRow() {
        return new RowBuilder();
    }

    public class RowBuilder {
        public RowBuilder() {
            TableBuilder.this.htmlBuilder.appendHtmlConstant("<tr>");
            TableBuilder.this.oddRow = !TableBuilder.this.oddRow;
        }

        public RowBuilder addConditions(String ... items) {
            for (String item : items) {
                this.addCell(item, this.getConditionStyleName());
            }
            return this;
        }

        public RowBuilder addActions(String ... items) {
            for (String item : items) {
                this.addCell(item, this.getActionStyleName());
            }
            return this;
        }

        private String getActionStyleName() {
            if (TableBuilder.this.oddRow) {
                return GuidedDecisionTableResources.INSTANCE.analysisCss().oddActionCell();
            }
            return GuidedDecisionTableResources.INSTANCE.analysisCss().evenActionCell();
        }

        private String getConditionStyleName() {
            if (TableBuilder.this.oddRow) {
                return GuidedDecisionTableResources.INSTANCE.analysisCss().oddConditionCell();
            }
            return GuidedDecisionTableResources.INSTANCE.analysisCss().evenConditionCell();
        }

        private void addCell(String item, String styleName) {
            TableBuilder.this.htmlBuilder.appendHtmlConstant("<td class='" + styleName + "'>");
            TableBuilder.this.htmlBuilder.appendEscaped(item);
            TableBuilder.this.htmlBuilder.appendHtmlConstant("</td>");
        }

        public TableBuilder<T> end() {
            TableBuilder.this.htmlBuilder.appendHtmlConstant("</tr>");
            return TableBuilder.this;
        }
    }

    public class HeaderBuilder {
        public HeaderBuilder() {
            TableBuilder.this.htmlBuilder.appendHtmlConstant("<tr>");
        }

        public HeaderBuilder headerConditions(String ... items) {
            for (String item : items) {
                this.addHeaderCell(GuidedDecisionTableResources.INSTANCE.analysisCss().exampleTableHeaderConditions(), item);
            }
            return this;
        }

        public HeaderBuilder headerActions(String ... items) {
            for (String item : items) {
                this.addHeaderCell(GuidedDecisionTableResources.INSTANCE.analysisCss().exampleTableHeaderActions(), item);
            }
            return this;
        }

        private void addHeaderCell(String styleName, String item) {
            TableBuilder.this.htmlBuilder.appendHtmlConstant("<th class='" + styleName + "'>");
            TableBuilder.this.htmlBuilder.appendEscaped(item);
            TableBuilder.this.htmlBuilder.appendHtmlConstant("</th>");
        }

        public TableBuilder<T> end() {
            TableBuilder.this.htmlBuilder.appendHtmlConstant("</tr>");
            return TableBuilder.this;
        }
    }
}

