/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.InsertInternalDecisionTableColumnEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.SetInternalDecisionTableModelEvent;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.AbstractDecoratedGridHeaderWidget;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.DynamicColumn;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.ResourcesProvider;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.SortConfiguration;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.ColumnResizeEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.SetInternalModelEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.SortDataEvent;

public class VerticalDecisionTableHeaderWidget
extends AbstractDecoratedGridHeaderWidget<GuidedDecisionTable52, BaseColumn> {
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat format = DateTimeFormat.getFormat((String)DATE_FORMAT);
    private HeaderWidget widget;
    private int multiRowColumnOffset = -1;
    private int multiRowColumnActionsOffset = -1;

    public VerticalDecisionTableHeaderWidget(ResourcesProvider<BaseColumn> resources, boolean isReadOnly, EventBus eventBus) {
        super(resources, isReadOnly, eventBus);
        eventBus.addHandler(SetInternalDecisionTableModelEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(InsertInternalDecisionTableColumnEvent.TYPE, (EventHandler)this);
        this.addResizeHandler(new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                int width = event.getWidth();
                VerticalDecisionTableHeaderWidget.this.panel.setWidth(width + "px");
            }
        });
    }

    public void redraw() {
        this.widget.redraw();
    }

    public void setScrollPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be null");
        }
        ((ScrollPanel)this.panel).setHorizontalScrollPosition(position);
    }

    private void fireResizeEvent() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                ResizeEvent.fire((HasResizeHandlers)VerticalDecisionTableHeaderWidget.this, (int)VerticalDecisionTableHeaderWidget.this.widget.getOffsetWidth(), (int)VerticalDecisionTableHeaderWidget.this.widget.getOffsetHeight());
            }
        });
    }

    private void setCursorType(Style.Cursor cursor) {
        for (int iRow = 0; iRow < this.widget.rowHeaders.length; ++iRow) {
            TableRowElement tre = (TableRowElement)this.widget.rowHeaders[iRow].cast();
            for (int iCol = 0; iCol < tre.getCells().getLength(); ++iCol) {
                TableCellElement tce = (TableCellElement)tre.getCells().getItem(iCol);
                tce.getStyle().setCursor(cursor);
            }
        }
    }

    protected Widget getHeaderWidget() {
        if (this.widget == null) {
            this.widget = new HeaderWidget();
        }
        return this.widget;
    }

    protected AbstractDecoratedGridHeaderWidget.ResizerInformation getResizerInformation(int mx) {
        boolean isPrimed = false;
        AbstractDecoratedGridHeaderWidget.ResizerInformation resizerInfo = new AbstractDecoratedGridHeaderWidget.ResizerInformation((AbstractDecoratedGridHeaderWidget)this);
        for (int iCol = 0; iCol < this.widget.rowHeaders[4].getChildCount(); ++iCol) {
            TableCellElement tce = (TableCellElement)this.widget.rowHeaders[4].getChild(iCol).cast();
            int cx = tce.getAbsoluteRight();
            if (Math.abs(mx - cx) > 5) continue;
            isPrimed = true;
            resizerInfo.setResizePrimed(isPrimed);
            resizerInfo.setResizeColumn((DynamicColumn)this.widget.visibleCols.get(iCol));
            resizerInfo.setResizeColumnLeft(tce.getAbsoluteLeft());
            break;
        }
        if (isPrimed) {
            this.setCursorType(Style.Cursor.COL_RESIZE);
        } else {
            this.setCursorType(Style.Cursor.DEFAULT);
        }
        return resizerInfo;
    }

    protected void resizeColumn(DynamicColumn<BaseColumn> resizeColumn, int resizeColumnWidth) {
        int colOffsetIndex;
        DivElement div;
        TableCellElement tce;
        DynamicColumn mergeCol;
        resizeColumn.setWidth(resizeColumnWidth);
        ((BaseColumn)resizeColumn.getModelColumn()).setWidth(resizeColumnWidth);
        int resizeColumnIndex = this.widget.visibleCols.indexOf(resizeColumn);
        int iRow0ColColumn = 0;
        for (int iCol = 0; iCol < this.widget.visibleCols.size(); ++iCol) {
            DynamicColumn col = (DynamicColumn)this.widget.visibleCols.get(iCol);
            BaseColumn modelCol = (BaseColumn)col.getModelColumn();
            int colSpan = 1;
            int width = col.getWidth();
            if (modelCol instanceof BRLVariableColumn) {
                BRLVariableColumn mergeBRLColumn;
                BRLColumn mergeBRLColumnParent;
                BaseColumn mergeModelCol;
                BRLVariableColumn brlColumn = (BRLVariableColumn)col.getModelColumn();
                BRLColumn brlColumnParent = ((GuidedDecisionTable52)this.model).getBRLColumn(brlColumn);
                while (iCol + colSpan < this.widget.visibleCols.size() && (mergeModelCol = (BaseColumn)(mergeCol = (DynamicColumn)this.widget.visibleCols.get(iCol + colSpan)).getModelColumn()) instanceof BRLVariableColumn && (mergeBRLColumnParent = ((GuidedDecisionTable52)this.model).getBRLColumn(mergeBRLColumn = (BRLVariableColumn)mergeModelCol)) == brlColumnParent) {
                    width += mergeCol.getWidth();
                    ++colSpan;
                }
                iCol = iCol + colSpan - 1;
            }
            tce = (TableCellElement)this.widget.rowHeaders[0].getChild(iRow0ColColumn).cast();
            div = (DivElement)tce.getFirstChild().cast();
            div.getStyle().setWidth((double)width, Style.Unit.PX);
            ++iRow0ColColumn;
        }
        tce = (TableCellElement)this.widget.rowHeaders[4].getChild(resizeColumnIndex).cast();
        div = (DivElement)tce.getFirstChild().cast();
        div.getStyle().setWidth((double)resizeColumnWidth, Style.Unit.PX);
        if (this.multiRowColumnOffset != -1 && (colOffsetIndex = resizeColumnIndex - this.multiRowColumnOffset) >= 0) {
            DynamicColumn col = (DynamicColumn)this.widget.visibleCols.get(resizeColumnIndex);
            tce = (TableCellElement)this.widget.rowHeaders[3].getChild(colOffsetIndex).cast();
            div = (DivElement)tce.getFirstChild().cast();
            div.getStyle().setWidth((double)col.getWidth(), Style.Unit.PX);
        }
        int iRow2ColColumn = 0;
        for (int iCol = 0; iCol < this.widget.visibleConditionCols.size(); ++iCol) {
            ConditionCol52 mergeCondCol;
            Pattern52 mergeCondColPattern;
            DynamicColumn col = (DynamicColumn)this.widget.visibleConditionCols.get(iCol);
            ConditionCol52 cc = (ConditionCol52)col.getModelColumn();
            Pattern52 ccPattern = ((GuidedDecisionTable52)this.model).getPattern(cc);
            int colSpan = 1;
            int width = col.getWidth();
            while (iCol + colSpan < this.widget.visibleConditionCols.size() && (mergeCondColPattern = ((GuidedDecisionTable52)this.model).getPattern(mergeCondCol = (ConditionCol52)(mergeCol = (DynamicColumn)this.widget.visibleConditionCols.get(iCol + colSpan)).getModelColumn())) == ccPattern) {
                width += mergeCol.getWidth();
                ++colSpan;
            }
            iCol = iCol + colSpan - 1;
            tce = (TableCellElement)this.widget.rowHeaders[2].getChild(iRow2ColColumn).cast();
            div = (DivElement)tce.getFirstChild().cast();
            div.getStyle().setWidth((double)width, Style.Unit.PX);
            ++iRow2ColColumn;
        }
        if (this.multiRowColumnActionsOffset != -1 && (colOffsetIndex = resizeColumnIndex - this.multiRowColumnActionsOffset) >= 0) {
            DynamicColumn col = (DynamicColumn)this.widget.visibleCols.get(resizeColumnIndex);
            tce = (TableCellElement)this.widget.rowHeaders[2].getChild(colOffsetIndex += iRow2ColColumn).cast();
            div = (DivElement)tce.getFirstChild().cast();
            div.getStyle().setWidth((double)col.getWidth(), Style.Unit.PX);
        }
        ColumnResizeEvent cre = new ColumnResizeEvent((DynamicColumn)this.widget.visibleCols.get(resizeColumnIndex), resizeColumnWidth);
        this.eventBus.fireEvent((GwtEvent)cre);
    }

    public void onSetInternalModel(SetInternalModelEvent<GuidedDecisionTable52, BaseColumn> event) {
        this.sortableColumns.clear();
        this.model = event.getModel();
        List columns = event.getColumns();
        for (DynamicColumn column : columns) {
            this.sortableColumns.add(column);
        }
        this.redraw();
    }

    private class HeaderWidget
    extends CellPanel {
        private List<HeaderSorter> sorters = new ArrayList<HeaderSorter>();
        private HeaderSplitter splitter = new HeaderSplitter();
        private Element[] rowHeaders = new Element[5];
        private List<DynamicColumn<BaseColumn>> visibleCols = new ArrayList<DynamicColumn<BaseColumn>>();
        private List<DynamicColumn<BaseColumn>> visibleConditionCols = new ArrayList<DynamicColumn<BaseColumn>>();
        private List<DynamicColumn<BaseColumn>> visibleActionCols = new ArrayList<DynamicColumn<BaseColumn>>();

        private HeaderWidget() {
            for (int iRow = 0; iRow < this.rowHeaders.length; ++iRow) {
                this.rowHeaders[iRow] = DOM.createTR();
                this.getBody().appendChild((Node)this.rowHeaders[iRow]);
            }
            ((TableElement)this.getBody().getParentElement().cast()).setCellSpacing(0);
            ((TableElement)this.getBody().getParentElement().cast()).setCellPadding(0);
        }

        private Element makeLabel(String text, int width, int height) {
            Element div = DOM.createDiv();
            div.getStyle().setWidth((double)width, Style.Unit.PX);
            div.getStyle().setHeight((double)height, Style.Unit.PX);
            div.getStyle().setOverflow(Style.Overflow.HIDDEN);
            div.setInnerText(text);
            return div;
        }

        private void populateTableCellElement(BaseColumn modelCol, int width, Element tce) {
            if (modelCol instanceof RowNumberCol52) {
                tce.appendChild((Node)this.makeLabel("#", width, VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight()));
                ((TableCellElement)tce.cast()).setRowSpan(4);
                tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerRowIntermediate());
                tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn((Object)modelCol));
            } else if (modelCol instanceof DescriptionCol52) {
                tce.appendChild((Node)this.makeLabel(GuidedDecisionTableConstants.INSTANCE.Description(), width, VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight()));
                ((TableCellElement)tce.cast()).setRowSpan(4);
                tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerRowIntermediate());
                tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn((Object)modelCol));
            } else if (modelCol instanceof MetadataCol52) {
                tce.appendChild((Node)this.makeLabel(((MetadataCol52)modelCol).getMetadata(), width, VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight()));
                ((TableCellElement)tce.cast()).setRowSpan(4);
                tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerRowIntermediate());
                tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn((Object)modelCol));
            } else if (modelCol instanceof AttributeCol52) {
                tce.appendChild((Node)this.makeLabel(((AttributeCol52)modelCol).getAttribute(), width, VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight()));
                ((TableCellElement)tce.cast()).setRowSpan(4);
                tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerRowIntermediate());
                tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn((Object)modelCol));
            } else if (modelCol instanceof ConditionCol52) {
                ConditionCol52 cc = (ConditionCol52)modelCol;
                StringBuilder header = new StringBuilder();
                if (cc.isBound()) {
                    header.append(cc.getBinding());
                    header.append(" : ");
                }
                header.append(cc.getHeader());
                tce.appendChild((Node)this.makeLabel(header.toString(), width, VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight()));
                tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn((Object)modelCol));
            } else if (modelCol instanceof ActionCol52) {
                tce.appendChild((Node)this.makeLabel(((ActionCol52)modelCol).getHeader(), width, VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight()));
                tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn((Object)modelCol));
            }
        }

        private void redraw() {
            if (this.splitter != null) {
                this.remove((Widget)this.splitter);
            }
            for (HeaderSorter sorter : this.sorters) {
                this.remove((Widget)sorter);
            }
            this.sorters.clear();
            this.visibleCols.clear();
            this.visibleConditionCols.clear();
            this.visibleActionCols.clear();
            VerticalDecisionTableHeaderWidget.this.multiRowColumnOffset = -1;
            VerticalDecisionTableHeaderWidget.this.multiRowColumnActionsOffset = -1;
            int iColumnCount = 0;
            for (int iCol = 0; iCol < VerticalDecisionTableHeaderWidget.this.sortableColumns.size(); ++iCol) {
                DynamicColumn col = (DynamicColumn)VerticalDecisionTableHeaderWidget.this.sortableColumns.get(iCol);
                if (!col.isVisible()) continue;
                this.visibleCols.add((DynamicColumn<BaseColumn>)col);
                BaseColumn modelCol = (BaseColumn)col.getModelColumn();
                if (modelCol instanceof ConditionCol52) {
                    if (VerticalDecisionTableHeaderWidget.this.multiRowColumnOffset == -1) {
                        VerticalDecisionTableHeaderWidget.this.multiRowColumnOffset = iColumnCount;
                    }
                    this.visibleConditionCols.add((DynamicColumn<BaseColumn>)col);
                }
                if (modelCol instanceof ActionCol52) {
                    if (VerticalDecisionTableHeaderWidget.this.multiRowColumnOffset == -1) {
                        VerticalDecisionTableHeaderWidget.this.multiRowColumnOffset = iColumnCount;
                    }
                    if (VerticalDecisionTableHeaderWidget.this.multiRowColumnActionsOffset == -1) {
                        VerticalDecisionTableHeaderWidget.this.multiRowColumnActionsOffset = iColumnCount;
                    }
                    this.visibleActionCols.add((DynamicColumn<BaseColumn>)col);
                }
                ++iColumnCount;
            }
            for (int iRow = 0; iRow < this.rowHeaders.length; ++iRow) {
                this.redrawHeaderRow(iRow);
            }
            VerticalDecisionTableHeaderWidget.this.fireResizeEvent();
        }

        private void redrawHeaderRow(int iRow) {
            Element tce = null;
            Element tre = DOM.createTR();
            switch (iRow) {
                case 0: {
                    for (int iCol = 0; iCol < this.visibleCols.size(); ++iCol) {
                        DynamicColumn<BaseColumn> col = this.visibleCols.get(iCol);
                        BaseColumn modelCol = (BaseColumn)col.getModelColumn();
                        tce = DOM.createTD();
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerText());
                        tre.appendChild((Node)tce);
                        int colSpan = 1;
                        int width = col.getWidth();
                        if (modelCol instanceof BRLVariableColumn) {
                            DynamicColumn<BaseColumn> mergeCol;
                            BaseColumn mergeModelCol;
                            BRLVariableColumn brlColumn = (BRLVariableColumn)col.getModelColumn();
                            BRLColumn brlColumnParent = ((GuidedDecisionTable52)VerticalDecisionTableHeaderWidget.this.model).getBRLColumn(brlColumn);
                            while (iCol + colSpan < this.visibleCols.size() && (mergeModelCol = (BaseColumn)(mergeCol = this.visibleCols.get(iCol + colSpan)).getModelColumn()) instanceof BRLVariableColumn) {
                                BRLVariableColumn mergeBRLColumn = (BRLVariableColumn)mergeModelCol;
                                BRLColumn mergeBRLColumnParent = ((GuidedDecisionTable52)VerticalDecisionTableHeaderWidget.this.model).getBRLColumn(mergeBRLColumn);
                                if (mergeBRLColumnParent != brlColumnParent) break;
                                width += mergeCol.getWidth();
                                ++colSpan;
                            }
                            iCol = iCol + colSpan - 1;
                        }
                        this.populateTableCellElement(modelCol, width, tce);
                        ((TableCellElement)tce.cast()).setColSpan(colSpan);
                    }
                    break;
                }
                case 1: {
                    if (this.visibleConditionCols.size() <= 0 && this.visibleActionCols.size() <= 0) break;
                    this.splitter.setRowHeaders(this.rowHeaders);
                    tce = DOM.createTD();
                    ((TableCellElement)tce.cast()).setColSpan(this.visibleConditionCols.size() + this.visibleActionCols.size());
                    tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerSplitter());
                    tre.appendChild((Node)tce);
                    this.add((Widget)this.splitter, tce);
                    break;
                }
                case 2: {
                    DynamicColumn<BaseColumn> col;
                    int iCol;
                    for (iCol = 0; iCol < this.visibleConditionCols.size(); ++iCol) {
                        col = this.visibleConditionCols.get(iCol);
                        ConditionCol52 cc = (ConditionCol52)col.getModelColumn();
                        Pattern52 ccPattern = ((GuidedDecisionTable52)VerticalDecisionTableHeaderWidget.this.model).getPattern(cc);
                        tce = DOM.createTD();
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerText());
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn(col.getModelColumn()));
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerRowIntermediate());
                        tre.appendChild((Node)tce);
                        int colSpan = 1;
                        int width = col.getWidth();
                        while (iCol + colSpan < this.visibleConditionCols.size()) {
                            DynamicColumn<BaseColumn> mergeCol = this.visibleConditionCols.get(iCol + colSpan);
                            ConditionCol52 mergeCondCol = (ConditionCol52)mergeCol.getModelColumn();
                            Pattern52 mergeCondColPattern = ((GuidedDecisionTable52)VerticalDecisionTableHeaderWidget.this.model).getPattern(mergeCondCol);
                            if (mergeCondColPattern != ccPattern) break;
                            width += mergeCol.getWidth();
                            ++colSpan;
                        }
                        iCol = iCol + colSpan - 1;
                        StringBuilder label = new StringBuilder();
                        if (!(cc instanceof LimitedEntryBRLConditionColumn)) {
                            if (cc instanceof BRLConditionVariableColumn) {
                                BRLConditionVariableColumn brl = (BRLConditionVariableColumn)cc;
                                label.append(brl.getVarName());
                            } else if (cc instanceof ConditionCol52) {
                                String factType = ccPattern.getFactType();
                                String boundName = ccPattern.getBoundName();
                                if (factType != null && factType.length() > 0) {
                                    if (ccPattern.isNegated()) {
                                        label.append(GuidedDecisionTableConstants.INSTANCE.negatedPattern()).append(" ").append(factType);
                                    } else {
                                        label.append(factType).append(" [").append(boundName).append("]");
                                    }
                                }
                            }
                        }
                        tce.appendChild((Node)this.makeLabel(label.toString(), width, this.splitter.isCollapsed ? 0 : VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight()));
                        ((TableCellElement)tce.cast()).setColSpan(colSpan);
                    }
                    for (iCol = 0; iCol < this.visibleActionCols.size(); ++iCol) {
                        String factType;
                        col = this.visibleActionCols.get(iCol);
                        ActionCol52 ac = (ActionCol52)col.getModelColumn();
                        tce = DOM.createTD();
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerText());
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn(col.getModelColumn()));
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerRowIntermediate());
                        tre.appendChild((Node)tce);
                        StringBuilder label = new StringBuilder();
                        if (ac instanceof ActionInsertFactCol52) {
                            ActionInsertFactCol52 aifc = (ActionInsertFactCol52)ac;
                            String factType2 = aifc.getFactType();
                            String binding = aifc.getBoundName();
                            if (factType2 != null && factType2.length() > 0) {
                                label.append(factType2);
                                if (binding != null) {
                                    label.append(" [" + binding + "]");
                                }
                            }
                        } else if (ac instanceof ActionSetFieldCol52) {
                            factType = ((ActionSetFieldCol52)ac).getBoundName();
                            if (factType != null && factType.length() > 0) {
                                label.append(factType);
                            }
                        } else if (ac instanceof LimitedEntryActionRetractFactCol52) {
                            factType = ((LimitedEntryActionRetractFactCol52)ac).getValue().getStringValue();
                            if (factType != null && factType.length() > 0) {
                                label.append(factType);
                            }
                        } else if (ac instanceof ActionWorkItemCol52) {
                            factType = ((ActionWorkItemCol52)ac).getWorkItemDefinition().getDisplayName();
                            if (factType != null && factType.length() > 0) {
                                label.append(factType);
                            }
                        } else if (ac instanceof BRLActionVariableColumn && (factType = ((BRLActionVariableColumn)ac).getVarName()) != null && factType.length() > 0) {
                            label.append(factType);
                        }
                        tce.appendChild((Node)this.makeLabel(label.toString(), col.getWidth(), this.splitter.isCollapsed ? 0 : VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight()));
                    }
                    break;
                }
                case 3: {
                    String field;
                    BRLConditionVariableColumn brl;
                    StringBuilder label;
                    for (DynamicColumn<BaseColumn> col : this.visibleConditionCols) {
                        tce = DOM.createTD();
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerText());
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerRowIntermediate());
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn(col.getModelColumn()));
                        tre.appendChild((Node)tce);
                        ConditionCol52 cc = (ConditionCol52)col.getModelColumn();
                        label = new StringBuilder();
                        if (!(cc instanceof LimitedEntryBRLConditionColumn)) {
                            if (cc instanceof BRLConditionVariableColumn) {
                                brl = (BRLConditionVariableColumn)cc;
                                field = brl.getFactField();
                                label.append(field == null ? "" : field);
                            } else {
                                String factField = cc.getFactField();
                                if (factField != null && factField.length() > 0) {
                                    label.append(factField);
                                }
                                if (cc.getConstraintValueType() != 5) {
                                    label.append(" [");
                                    label.append(cc.getOperator());
                                    String lev = this.getLimitedEntryValue((DTColumnConfig52)cc);
                                    if (lev != null) {
                                        label.append(lev);
                                    }
                                    label.append("]");
                                }
                            }
                        }
                        tce.appendChild((Node)this.makeLabel(label.toString(), col.getWidth(), this.splitter.isCollapsed ? 0 : VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight()));
                    }
                    for (DynamicColumn<BaseColumn> col : this.visibleActionCols) {
                        String lev;
                        String factField;
                        tce = DOM.createTD();
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerText());
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerRowIntermediate());
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn(col.getModelColumn()));
                        tre.appendChild((Node)tce);
                        ActionCol52 ac = (ActionCol52)col.getModelColumn();
                        label = new StringBuilder();
                        if (ac instanceof ActionInsertFactCol52) {
                            ActionInsertFactCol52 aifc = (ActionInsertFactCol52)ac;
                            factField = aifc.getFactField();
                            if (factField != null && factField.length() > 0) {
                                label.append(factField);
                            }
                            if ((lev = this.getLimitedEntryValue((DTColumnConfig52)aifc)) != null) {
                                label.append(" [");
                                label.append(lev);
                                label.append("]");
                            }
                        } else if (ac instanceof ActionSetFieldCol52) {
                            ActionSetFieldCol52 asf = (ActionSetFieldCol52)ac;
                            factField = asf.getFactField();
                            if (factField != null && factField.length() > 0) {
                                label.append(factField);
                            }
                            if ((lev = this.getLimitedEntryValue((DTColumnConfig52)asf)) != null) {
                                label.append(" [");
                                label.append(lev);
                                label.append("]");
                            }
                        } else if (ac instanceof ActionRetractFactCol52) {
                            label.append("[" + GuidedDecisionTableConstants.INSTANCE.Delete() + "]");
                        } else if (ac instanceof ActionWorkItemCol52) {
                            label.append("[" + GuidedDecisionTableConstants.INSTANCE.WorkItemAction() + "]");
                        } else if (ac instanceof BRLActionVariableColumn) {
                            brl = (BRLActionVariableColumn)ac;
                            field = brl.getFactField();
                            label.append(field == null ? "" : field);
                        }
                        tce.appendChild((Node)this.makeLabel(label.toString(), col.getWidth(), this.splitter.isCollapsed ? 0 : VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight()));
                    }
                    break;
                }
                case 4: {
                    for (DynamicColumn col : VerticalDecisionTableHeaderWidget.this.sortableColumns) {
                        if (!col.isVisible()) continue;
                        HeaderSorter shp = new HeaderSorter(col);
                        final DynamicColumn sortableColumn = col;
                        if (!VerticalDecisionTableHeaderWidget.this.isReadOnly) {
                            shp.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    if (sortableColumn.isSortable()) {
                                        VerticalDecisionTableHeaderWidget.this.updateSortOrder(sortableColumn);
                                        SortDataEvent sde = new SortDataEvent(VerticalDecisionTableHeaderWidget.this.getSortConfiguration());
                                        VerticalDecisionTableHeaderWidget.this.eventBus.fireEvent((GwtEvent)sde);
                                    }
                                }
                            });
                        }
                        this.sorters.add(shp);
                        tce = DOM.createTD();
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.headerRowBottom());
                        tce.addClassName(VerticalDecisionTableHeaderWidget.this.resources.cellTableColumn(col.getModelColumn()));
                        tre.appendChild((Node)tce);
                        this.add((Widget)shp, tce);
                    }
                    break;
                }
            }
            this.getBody().replaceChild((Node)tre, (Node)this.rowHeaders[iRow]);
            this.rowHeaders[iRow] = tre;
        }

        private String getLimitedEntryValue(DTColumnConfig52 c) {
            if (!(c instanceof LimitedEntryCol)) {
                return null;
            }
            LimitedEntryCol lec = (LimitedEntryCol)c;
            DTCellValue52 cv = lec.getValue();
            if (cv == null) {
                return null;
            }
            DataType.DataTypes type = cv.getDataType();
            switch (type) {
                case BOOLEAN: {
                    return cv.getBooleanValue().toString();
                }
                case NUMERIC: {
                    BigDecimal numeric = (BigDecimal)cv.getNumericValue();
                    return numeric.toPlainString();
                }
                case NUMERIC_BIGDECIMAL: {
                    BigDecimal numericBigDecimal = (BigDecimal)cv.getNumericValue();
                    return numericBigDecimal.toPlainString();
                }
                case NUMERIC_BIGINTEGER: {
                    BigInteger numericBigInteger = (BigInteger)cv.getNumericValue();
                    return numericBigInteger.toString();
                }
                case NUMERIC_BYTE: {
                    Byte numericByte = (Byte)cv.getNumericValue();
                    return numericByte.toString();
                }
                case NUMERIC_DOUBLE: {
                    Double numericDouble = (Double)cv.getNumericValue();
                    return numericDouble.toString();
                }
                case NUMERIC_FLOAT: {
                    Float numericFloat = (Float)cv.getNumericValue();
                    return numericFloat.toString();
                }
                case NUMERIC_INTEGER: {
                    Integer numericInteger = (Integer)cv.getNumericValue();
                    return numericInteger.toString();
                }
                case NUMERIC_LONG: {
                    Long numericLong = (Long)cv.getNumericValue();
                    return numericLong.toString();
                }
                case NUMERIC_SHORT: {
                    Short numericShort = (Short)cv.getNumericValue();
                    return numericShort.toString();
                }
                case DATE: {
                    return format.format(cv.getDateValue());
                }
            }
            return cv.getStringValue();
        }

        private class HeaderSplitter
        extends FocusPanel {
            private Element[] rowHeaders;
            private final HorizontalPanel hp = new HorizontalPanel();
            private final Image icon = new Image();
            private boolean isCollapsed = true;

            private HeaderSplitter() {
                this.hp.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
                this.hp.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
                this.hp.getElement().getStyle().setHeight((double)VerticalDecisionTableHeaderWidget.this.resources.rowHeaderSplitterHeight(), Style.Unit.PX);
                this.hp.setWidth("100%");
                this.setIconImage();
                this.hp.add((Widget)this.icon);
                this.add((Widget)this.hp);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (HeaderSplitter.this.isCollapsed) {
                            HeaderSplitter.this.showRow(2);
                            HeaderSplitter.this.showRow(3);
                        } else {
                            HeaderSplitter.this.hideRow(2);
                            HeaderSplitter.this.hideRow(3);
                        }
                        HeaderSplitter.this.isCollapsed = !HeaderSplitter.this.isCollapsed;
                        HeaderSplitter.this.setIconImage();
                    }
                });
            }

            private void hideRow(int iRow) {
                if (this.rowHeaders == null || this.rowHeaders.length - 1 < iRow) {
                    return;
                }
                TableRowElement tre = (TableRowElement)this.rowHeaders[iRow].cast();
                HeaderRowAnimation anim = new HeaderRowAnimation(tre, VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight(), 0);
                anim.run(250);
            }

            private void setIconImage() {
                if (this.isCollapsed) {
                    this.icon.setResource(VerticalDecisionTableHeaderWidget.this.resources.smallDownArrowIcon());
                } else {
                    this.icon.setResource(VerticalDecisionTableHeaderWidget.this.resources.smallUpArrowIcon());
                }
            }

            private void setRowHeaders(Element[] rowHeaders) {
                this.rowHeaders = rowHeaders;
            }

            private void showRow(int iRow) {
                if (this.rowHeaders == null || this.rowHeaders.length - 1 < iRow) {
                    return;
                }
                TableRowElement tre = (TableRowElement)this.rowHeaders[iRow].cast();
                HeaderRowAnimation anim = new HeaderRowAnimation(tre, 0, VerticalDecisionTableHeaderWidget.this.resources.rowHeaderHeight());
                anim.run(250);
            }

            private class HeaderRowAnimation
            extends Animation {
                private TableRowElement tre;
                private int startHeight;
                private int endHeight;

                private HeaderRowAnimation(TableRowElement tre, int startHeight, int endHeight) {
                    this.tre = tre;
                    this.startHeight = startHeight;
                    this.endHeight = endHeight;
                }

                private void setHeight(int height) {
                    for (int i = 0; i < this.tre.getChildCount(); ++i) {
                        ((DivElement)this.tre.getChild(i).getFirstChild().cast()).getStyle().setHeight((double)height, Style.Unit.PX);
                    }
                    VerticalDecisionTableHeaderWidget.this.fireResizeEvent();
                }

                protected void onComplete() {
                    super.onComplete();
                    this.setHeight(this.endHeight);
                }

                protected void onUpdate(double progress) {
                    int height = (int)((double)this.startHeight + progress * (double)(this.endHeight - this.startHeight));
                    this.setHeight(height);
                }
            }
        }

        private class HeaderSorter
        extends FocusPanel {
            private final HorizontalPanel hp = new HorizontalPanel();
            private final DynamicColumn<BaseColumn> col;

            private HeaderSorter(DynamicColumn<BaseColumn> col) {
                this.col = col;
                this.hp.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
                this.hp.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
                this.hp.setHeight(VerticalDecisionTableHeaderWidget.this.resources.rowHeaderSorterHeight() + "px");
                this.hp.setWidth("100%");
                this.setIconImage();
                this.add((Widget)this.hp);
                col.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<SortConfiguration>(){

                    public void onValueChange(ValueChangeEvent<SortConfiguration> event) {
                        HeaderSorter.this.setIconImage();
                    }
                });
            }

            private void setIconImage() {
                this.hp.clear();
                block0 : switch (this.col.getSortDirection()) {
                    case ASCENDING: {
                        switch (this.col.getSortIndex()) {
                            case 0: {
                                this.hp.add((Widget)new Image(VerticalDecisionTableHeaderWidget.this.resources.upArrowIcon()));
                                break block0;
                            }
                        }
                        this.hp.add((Widget)new Image(VerticalDecisionTableHeaderWidget.this.resources.smallUpArrowIcon()));
                        break;
                    }
                    case DESCENDING: {
                        switch (this.col.getSortIndex()) {
                            case 0: {
                                this.hp.add((Widget)new Image(VerticalDecisionTableHeaderWidget.this.resources.downArrowIcon()));
                                break block0;
                            }
                        }
                        this.hp.add((Widget)new Image(VerticalDecisionTableHeaderWidget.this.resources.smallDownArrowIcon()));
                        break;
                    }
                    default: {
                        this.hp.add((Widget)new Image(VerticalDecisionTableHeaderWidget.this.resources.arrowSpacerIcon()));
                    }
                }
            }
        }
    }
}

