/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.utils.DTCellValueUtilities;
import org.drools.workbench.screens.guided.dtable.client.utils.GuidedDecisionTableUtils;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.GenericColumnCommand;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.ImageButton;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ActionSetFieldPopup
extends FormStylePopup {
    private SmallLabel bindingLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private SimplePanel limitedEntryValueWidgetContainer = new SimplePanel();
    private int limitedEntryValueAttributeIndex = -1;
    private TextBox valueListWidget = null;
    private SimplePanel defaultValueWidgetContainer = new SimplePanel();
    private int defaultValueWidgetContainerIndex = -1;
    private final GuidedDecisionTable52 model;
    private final AsyncPackageDataModelOracle oracle;
    private final GuidedDecisionTableUtils utils;
    private final DTCellValueWidgetFactory factory;
    private final BRLRuleModel rm;
    private final DTCellValueUtilities utilities;
    private ActionSetFieldCol52 editingCol;
    private final boolean isReadOnly;
    private ModalFooterOKCancelButtons footer;

    public ActionSetFieldPopup(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, final GenericColumnCommand refreshGrid, final ActionSetFieldCol52 col, final boolean isNew, boolean isReadOnly) {
        super(GuidedDecisionTableConstants.INSTANCE.ColumnConfigurationSetAFieldOnAFact());
        this.rm = new BRLRuleModel(model);
        this.editingCol = this.cloneActionSetColumn(col);
        this.model = model;
        this.oracle = oracle;
        this.utils = new GuidedDecisionTableUtils(model, oracle);
        this.isReadOnly = isReadOnly;
        this.utilities = new DTCellValueUtilities(model, oracle);
        this.factory = DTCellValueWidgetFactory.getInstance(model, oracle, isReadOnly, this.allowEmptyValues());
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.bindingLabel);
        this.doBindingLabel();
        ImageButton changePattern = new ImageButton(this.createEnabledEditButton(), this.createDisabledEditButton(), GuidedDecisionTableConstants.INSTANCE.ChooseABoundFactThatThisColumnPertainsTo(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionSetFieldPopup.this.showChangeFact(w);
            }
        });
        changePattern.setEnabled(!isReadOnly);
        pattern.add((Widget)changePattern);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Fact() + ":", (IsWidget)pattern);
        HorizontalPanel field = new HorizontalPanel();
        this.fieldLabel.setEnabled(!isReadOnly);
        field.add((Widget)this.fieldLabel);
        ImageButton editField = new ImageButton(this.createEnabledEditButton(), this.createDisabledEditButton(), GuidedDecisionTableConstants.INSTANCE.EditTheFieldThatThisColumnOperatesOn(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionSetFieldPopup.this.showFieldChange();
            }
        });
        editField.setEnabled(!isReadOnly);
        field.add((Widget)editField);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)field);
        this.doFieldLabel();
        final TextBox header = new TextBox();
        header.setText(col.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ActionSetFieldPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.ColumnHeaderDescription(), (IsWidget)header);
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.valueListWidget = new TextBox();
            this.valueListWidget.setText(this.editingCol.getValueList());
            this.valueListWidget.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                this.valueListWidget.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        ActionSetFieldPopup.this.editingCol.setValueList(ActionSetFieldPopup.this.valueListWidget.getText());
                    }
                });
                this.valueListWidget.addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        this.assertDefaultValue();
                        ActionSetFieldPopup.this.makeDefaultValueWidget();
                    }

                    private void assertDefaultValue() {
                        List<String> valueList = Arrays.asList(ActionSetFieldPopup.this.utils.getValueList((BaseColumn)ActionSetFieldPopup.this.editingCol));
                        if (valueList.size() > 0) {
                            String defaultValue = ActionSetFieldPopup.this.utilities.asString(ActionSetFieldPopup.this.editingCol.getDefaultValue());
                            if (!valueList.contains(defaultValue)) {
                                ActionSetFieldPopup.this.editingCol.getDefaultValue().clearValues();
                            }
                        } else {
                            DTCellValue52 defaultValue = ActionSetFieldPopup.this.editingCol.getDefaultValue();
                            DataType.DataTypes dataType = ActionSetFieldPopup.this.utilities.getDataType((BaseColumn)ActionSetFieldPopup.this.editingCol);
                            ActionSetFieldPopup.this.utilities.assertDTCellValue(dataType, defaultValue);
                        }
                    }
                });
            }
            HorizontalPanel vl = new HorizontalPanel();
            vl.add((Widget)this.valueListWidget);
            vl.add((IsWidget)new InfoPopup(GuidedDecisionTableConstants.INSTANCE.ValueList(), GuidedDecisionTableConstants.INSTANCE.ValueListsExplanation()));
            this.addAttribute(GuidedDecisionTableConstants.INSTANCE.optionalValueList(), (IsWidget)vl);
        }
        this.doValueList();
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.defaultValueWidgetContainerIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.DefaultValue() + ":", (IsWidget)this.defaultValueWidgetContainer).getIndex();
            this.makeDefaultValueWidget();
        }
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            this.limitedEntryValueAttributeIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.LimitedEntryValue(), (IsWidget)this.limitedEntryValueWidgetContainer).getIndex();
            this.makeLimitedValueWidget();
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.UpdateEngineWithChanges() + ":", (IsWidget)this.doUpdate());
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":", (IsWidget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        this.footer = new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                ActionSetFieldPopup.this.applyChanges(refreshGrid, col, isNew);
            }
        }, new Command(){

            public void execute() {
                ActionSetFieldPopup.this.hide();
            }
        });
        this.add((Widget)this.footer);
    }

    private void applyChanges(GenericColumnCommand refreshGrid, ActionSetFieldCol52 col, boolean isNew) {
        if (!this.isValidFactType()) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnFact());
            return;
        }
        if (!this.isValidFactField()) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnField());
            return;
        }
        if (null == this.editingCol.getHeader() || "".equals(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
            return;
        }
        if (isNew) {
            if (!this.unique(this.editingCol.getHeader())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                return;
            }
        } else if (!col.getHeader().equals(this.editingCol.getHeader()) && !this.unique(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
            return;
        }
        refreshGrid.execute((DTColumnConfig52)this.editingCol);
        this.hide();
    }

    private Image createDisabledEditButton() {
        Image disabledChangePattern = GuidedDecisionTableImageResources508.INSTANCE.EditDisabled();
        disabledChangePattern.setAltText(GuidedDecisionTableConstants.INSTANCE.ChooseABoundFactThatThisColumnPertainsTo());
        return disabledChangePattern;
    }

    private Image createEnabledEditButton() {
        Image enabledChangePattern = GuidedDecisionTableImageResources508.INSTANCE.Edit();
        enabledChangePattern.setAltText(GuidedDecisionTableConstants.INSTANCE.ChooseABoundFactThatThisColumnPertainsTo());
        return enabledChangePattern;
    }

    private boolean allowEmptyValues() {
        return this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
    }

    private ActionSetFieldCol52 cloneActionSetColumn(ActionSetFieldCol52 col) {
        LimitedEntryActionSetFieldCol52 clone = null;
        if (col instanceof LimitedEntryActionSetFieldCol52) {
            clone = new LimitedEntryActionSetFieldCol52();
            DTCellValue52 dcv = this.cloneDTCellValue(((LimitedEntryCol)col).getValue());
            ((LimitedEntryCol)clone).setValue(dcv);
        } else {
            clone = new ActionSetFieldCol52();
        }
        clone.setBoundName(col.getBoundName());
        clone.setFactField(col.getFactField());
        clone.setHeader(col.getHeader());
        clone.setType(col.getType());
        clone.setValueList(col.getValueList());
        clone.setUpdate(col.isUpdate());
        clone.setDefaultValue(this.cloneDTCellValue(col.getDefaultValue()));
        clone.setHideColumn(col.isHideColumn());
        return clone;
    }

    private DTCellValue52 cloneDTCellValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        DTCellValue52 clone = new DTCellValue52(dcv);
        return clone;
    }

    private void makeLimitedValueWidget() {
        if (!(this.editingCol instanceof LimitedEntryActionSetFieldCol52)) {
            return;
        }
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, false);
            return;
        }
        LimitedEntryActionSetFieldCol52 lea = (LimitedEntryActionSetFieldCol52)this.editingCol;
        this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, true);
        if (lea.getValue() == null) {
            lea.setValue(this.factory.makeNewValue((DTColumnConfig52)this.editingCol));
        }
        this.limitedEntryValueWidgetContainer.setWidget(this.factory.getWidget(this.model.getConditionPattern(this.editingCol.getBoundName()), this.editingCol, lea.getValue()));
    }

    private void makeDefaultValueWidget() {
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, false);
            return;
        }
        this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, true);
        if (this.editingCol.getDefaultValue() == null) {
            this.editingCol.setDefaultValue(this.factory.makeNewValue((DTColumnConfig52)this.editingCol));
        }
        DTCellValue52 defaultValue = this.editingCol.getDefaultValue();
        DataType.DataTypes dataType = this.utilities.getDataType((BaseColumn)this.editingCol);
        this.utilities.assertDTCellValue(dataType, defaultValue);
        this.defaultValueWidgetContainer.setWidget(this.factory.getWidget(this.model.getConditionPattern(this.editingCol.getBoundName()), this.editingCol, defaultValue));
    }

    private void doBindingLabel() {
        if (this.editingCol.getBoundName() != null) {
            this.bindingLabel.setText("" + this.editingCol.getBoundName());
        } else {
            this.bindingLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseChooseABoundFactForThisColumn());
        }
    }

    void doFieldLabel() {
        if (!this.nil(this.editingCol.getFactField())) {
            this.setFieldLabelToFieldName(this.editingCol.getFactField());
        } else if (!this.nil(this.editingCol.getBoundName())) {
            this.setFieldLabelPleaseSelectAField();
        } else {
            this.setFieldLabelPleaseChooseAFactPatternFirst();
        }
    }

    void setFieldLabelToFieldName(String fieldName) {
        this.fieldLabel.setText(fieldName);
    }

    void setFieldLabelPleaseSelectAField() {
        this.fieldLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAField());
    }

    void setFieldLabelPleaseChooseAFactPatternFirst() {
        this.fieldLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseChooseAFactPatternFirst());
    }

    private void doValueList() {
        boolean enableValueList;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.utils.getBoundFactType(this.editingCol.getBoundName());
        String factField = this.editingCol.getFactField();
        boolean bl = enableValueList = factType != null && !"".equals(factType) && factField != null && !"".equals(factField);
        if (enableValueList) {
            enableValueList = !this.oracle.hasEnums(factType, factField);
        }
        this.valueListWidget.setEnabled(enableValueList);
        if (!enableValueList) {
            this.valueListWidget.setText("");
        }
    }

    private Widget doUpdate() {
        HorizontalPanel hp = new HorizontalPanel();
        final CheckBox cb = new CheckBox();
        cb.setValue(Boolean.valueOf(this.editingCol.isUpdate()));
        cb.setText("");
        cb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            cb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent arg0) {
                    if (ActionSetFieldPopup.this.oracle.isGlobalVariable(ActionSetFieldPopup.this.editingCol.getBoundName())) {
                        cb.setEnabled(false);
                        ActionSetFieldPopup.this.editingCol.setUpdate(false);
                    } else {
                        ActionSetFieldPopup.this.editingCol.setUpdate(cb.getValue().booleanValue());
                    }
                }
            });
        }
        hp.add((Widget)cb);
        hp.add((IsWidget)new InfoPopup(GuidedDecisionTableConstants.INSTANCE.UpdateFact(), GuidedDecisionTableConstants.INSTANCE.UpdateDescription()));
        return hp;
    }

    private String getFactType() {
        if (this.oracle.isGlobalVariable(this.editingCol.getBoundName())) {
            return this.oracle.getGlobalVariable(this.editingCol.getBoundName());
        }
        return this.getFactType(this.editingCol.getBoundName());
    }

    private String getFactType(String boundName) {
        return this.rm.getLHSBoundFact(boundName).getFactType();
    }

    private TextBox getFieldLabel() {
        final TextBox box = new TextBox();
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ActionSetFieldPopup.this.editingCol.setFactField(box.getText());
            }
        });
        return box;
    }

    private ListBox loadBoundFacts(String binding) {
        ListBox listBox = new ListBox();
        listBox.addItem(GuidedDecisionTableConstants.INSTANCE.Choose());
        List factBindings = this.rm.getLHSBoundFacts();
        for (int index = 0; index < factBindings.size(); ++index) {
            String boundName = (String)factBindings.get(index);
            if ("".equals(boundName)) continue;
            listBox.addItem(boundName);
            if (!boundName.equals(binding)) continue;
            listBox.setSelectedIndex(index + 1);
        }
        String[] globs = this.oracle.getGlobalVariables();
        for (int i = 0; i < globs.length; ++i) {
            listBox.addItem(globs[i]);
        }
        listBox.setEnabled(listBox.getItemCount() > 1);
        if (listBox.getItemCount() == 1) {
            listBox.clear();
            listBox.addItem(GuidedDecisionTableConstants.INSTANCE.NoPatternBindingsAvailable());
        }
        return listBox;
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showChangeFact(ClickEvent w) {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.FactType());
        final ListBox pats = this.loadBoundFacts(this.editingCol.getBoundName());
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.ChooseFact(), (IsWidget)pats);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                String val = pats.getValue(pats.getSelectedIndex());
                ActionSetFieldPopup.this.editingCol.setBoundName(val);
                ActionSetFieldPopup.this.editingCol.setFactField(null);
                ActionSetFieldPopup.this.makeLimitedValueWidget();
                ActionSetFieldPopup.this.makeDefaultValueWidget();
                ActionSetFieldPopup.this.doBindingLabel();
                ActionSetFieldPopup.this.doFieldLabel();
                ActionSetFieldPopup.this.doValueList();
                pop.hide();
                ActionSetFieldPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionSetFieldPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    private void showFieldChange() {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.Field());
        final ListBox box = new ListBox();
        final String factType = this.getFactType();
        this.oracle.getFieldCompletions(factType, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                for (int i = 0; i < fields.length; ++i) {
                    box.addItem(fields[i].getName());
                }
            }
        });
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)box);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                ActionSetFieldPopup.this.editingCol.setFactField(box.getItemText(box.getSelectedIndex()));
                ActionSetFieldPopup.this.editingCol.setType(ActionSetFieldPopup.this.oracle.getFieldType(factType, ActionSetFieldPopup.this.editingCol.getFactField()));
                ActionSetFieldPopup.this.makeLimitedValueWidget();
                ActionSetFieldPopup.this.makeDefaultValueWidget();
                ActionSetFieldPopup.this.doFieldLabel();
                ActionSetFieldPopup.this.doValueList();
                pop.hide();
                ActionSetFieldPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionSetFieldPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    private boolean isValidFactType() {
        return this.editingCol.getBoundName() != null && !"".equals(this.editingCol.getBoundName());
    }

    private boolean isValidFactField() {
        return this.editingCol.getFactField() != null && !"".equals(this.editingCol.getFactField());
    }

    private boolean unique(String header) {
        for (ActionCol52 o : this.model.getActionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }

    private void enableFooter(boolean enabled) {
        if (this.footer == null) {
            return;
        }
        this.footer.enableOkButton(enabled);
        this.footer.enableCancelButton(enabled);
    }
}

