/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.utils.GuidedDecisionTableUtils;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.GenericColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.ModalFooterChangePattern;
import org.drools.workbench.screens.guided.rule.client.editor.BindingTextBox;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.ImageButton;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ActionWorkItemInsertFactPopup
extends FormStylePopup {
    private SmallLabel patternLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private ListBox workItemResultParameters = new ListBox();
    private Map<String, WorkItemParameter> workItemResultParametersMap = new HashMap<String, WorkItemParameter>();
    private ActionWorkItemInsertFactCol52 editingCol;
    private GuidedDecisionTable52 model;
    private final AsyncPackageDataModelOracle oracle;
    private final GuidedDecisionTableUtils utils;
    private final boolean isReadOnly;
    private ModalFooterOKCancelButtons footer;

    public ActionWorkItemInsertFactPopup(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, final GenericColumnCommand refreshGrid, final ActionWorkItemInsertFactCol52 col, final boolean isNew, boolean isReadOnly) {
        super(GuidedDecisionTableConstants.INSTANCE.ColumnConfigurationWorkItemInsertFact());
        this.editingCol = this.cloneActionInsertColumn(col);
        this.model = model;
        this.oracle = oracle;
        this.utils = new GuidedDecisionTableUtils(model, oracle);
        this.isReadOnly = isReadOnly;
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.patternLabel);
        this.doPatternLabel();
        ImageButton changePattern = new ImageButton(this.createEnabledEdit(), this.createDisabledEdit(), GuidedDecisionTableConstants.INSTANCE.ChooseAPatternThatThisColumnAddsDataTo(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionWorkItemInsertFactPopup.this.showChangePattern(w);
            }
        });
        changePattern.setEnabled(!isReadOnly);
        pattern.add((Widget)changePattern);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Pattern(), (IsWidget)pattern);
        HorizontalPanel field = new HorizontalPanel();
        this.fieldLabel.setEnabled(!isReadOnly);
        field.add((Widget)this.fieldLabel);
        ImageButton editField = new ImageButton(this.createEnabledEdit(), this.createDisabledEdit(), GuidedDecisionTableConstants.INSTANCE.EditTheFieldThatThisColumnOperatesOn(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionWorkItemInsertFactPopup.this.showFieldChange();
            }
        });
        editField.setEnabled(!isReadOnly);
        field.add((Widget)editField);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)field);
        this.doFieldLabel();
        final TextBox header = new TextBox();
        header.setText(col.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ActionWorkItemInsertFactPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.ColumnHeaderDescription(), (IsWidget)header);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.LogicallyInsert() + ":", (IsWidget)this.doInsertLogical());
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.BindActionFieldToWorkItem(), (IsWidget)this.doBindFieldToWorkItem());
        if (!isReadOnly) {
            this.workItemResultParameters.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    int index = ActionWorkItemInsertFactPopup.this.workItemResultParameters.getSelectedIndex();
                    if (index >= 0) {
                        String key = ActionWorkItemInsertFactPopup.this.workItemResultParameters.getValue(index);
                        WorkItemParameter wip = (WorkItemParameter)ActionWorkItemInsertFactPopup.this.workItemResultParametersMap.get(key);
                        ActionWorkItemInsertFactPopup.this.editingCol.setWorkItemName(wip.workDefinition.getName());
                        ActionWorkItemInsertFactPopup.this.editingCol.setWorkItemResultParameterName(wip.workParameterDefinition.getName());
                        ActionWorkItemInsertFactPopup.this.editingCol.setParameterClassName(wip.workParameterDefinition.getClassName());
                    }
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":", (IsWidget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        this.footer = new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                ActionWorkItemInsertFactPopup.this.applyChanges(refreshGrid, col, isNew);
            }
        }, new Command(){

            public void execute() {
                ActionWorkItemInsertFactPopup.this.hide();
            }
        });
        this.add((Widget)this.footer);
    }

    private void applyChanges(GenericColumnCommand refreshGrid, ActionWorkItemInsertFactCol52 col, boolean isNew) {
        if (!this.isValidFactType()) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnPattern());
            return;
        }
        if (!this.isValidFactField()) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnField());
            return;
        }
        if (null == this.editingCol.getHeader() || "".equals(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
            return;
        }
        if (isNew) {
            if (!this.unique(this.editingCol.getHeader())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                return;
            }
        } else if (!col.getHeader().equals(this.editingCol.getHeader()) && !this.unique(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
            return;
        }
        refreshGrid.execute((DTColumnConfig52)this.editingCol);
        this.hide();
    }

    private Image createDisabledEdit() {
        Image disabledEdit = GuidedDecisionTableImageResources508.INSTANCE.EditDisabled();
        disabledEdit.setAltText(GuidedDecisionTableConstants.INSTANCE.ChooseAPatternThatThisColumnAddsDataTo());
        return disabledEdit;
    }

    private Image createEnabledEdit() {
        Image edit = GuidedDecisionTableImageResources508.INSTANCE.Edit();
        edit.setAltText(GuidedDecisionTableConstants.INSTANCE.ChooseAPatternThatThisColumnAddsDataTo());
        return edit;
    }

    private ActionWorkItemInsertFactCol52 cloneActionInsertColumn(ActionWorkItemInsertFactCol52 col) {
        ActionWorkItemInsertFactCol52 clone = new ActionWorkItemInsertFactCol52();
        clone.setBoundName(col.getBoundName());
        clone.setType(col.getType());
        clone.setFactField(col.getFactField());
        clone.setFactType(col.getFactType());
        clone.setHeader(col.getHeader());
        clone.setValueList(col.getValueList());
        clone.setDefaultValue(this.cloneDTCellValue(col.getDefaultValue()));
        clone.setHideColumn(col.isHideColumn());
        clone.setInsertLogical(col.isInsertLogical());
        clone.setWorkItemName(col.getWorkItemName());
        clone.setWorkItemResultParameterName(col.getWorkItemResultParameterName());
        clone.setParameterClassName(col.getParameterClassName());
        return clone;
    }

    private DTCellValue52 cloneDTCellValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        DTCellValue52 clone = new DTCellValue52(dcv);
        return clone;
    }

    private void doFieldLabel() {
        if (this.nil(this.editingCol.getFactField())) {
            this.fieldLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseChooseFactType());
        } else {
            this.fieldLabel.setText(this.editingCol.getFactField());
        }
    }

    private void doPatternLabel() {
        if (this.editingCol.getFactType() != null) {
            this.patternLabel.setText(this.editingCol.getFactType() + " [" + this.editingCol.getBoundName() + "]");
        }
    }

    private TextBox getFieldLabel() {
        final TextBox box = new TextBox();
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ActionWorkItemInsertFactPopup.this.editingCol.setFactField(box.getText());
            }
        });
        return box;
    }

    private ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        for (Object o : this.model.getActionCols()) {
            ActionInsertFactCol52 c;
            ActionCol52 col = (ActionCol52)o;
            if (!(col instanceof ActionInsertFactCol52) || vars.contains((c = (ActionInsertFactCol52)col).getBoundName())) continue;
            patterns.addItem(c.getFactType() + " [" + c.getBoundName() + "]", c.getFactType() + " " + c.getBoundName());
            vars.add(c.getBoundName());
        }
        return patterns;
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showFieldChange() {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.Field());
        final ListBox box = new ListBox();
        this.oracle.getFieldCompletions(this.editingCol.getFactType(), FieldAccessorsAndMutators.MUTATOR, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                for (int i = 0; i < fields.length; ++i) {
                    box.addItem(fields[i].getName());
                }
            }
        });
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)box);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                ActionWorkItemInsertFactPopup.this.editingCol.setFactField(box.getItemText(box.getSelectedIndex()));
                ActionWorkItemInsertFactPopup.this.editingCol.setType(ActionWorkItemInsertFactPopup.this.oracle.getFieldType(ActionWorkItemInsertFactPopup.this.editingCol.getFactType(), ActionWorkItemInsertFactPopup.this.editingCol.getFactField()));
                ActionWorkItemInsertFactPopup.this.doBindFieldToWorkItem();
                ActionWorkItemInsertFactPopup.this.doFieldLabel();
                pop.hide();
                ActionWorkItemInsertFactPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionWorkItemInsertFactPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    private boolean unique(String header) {
        for (ActionCol52 o : this.model.getActionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }

    protected void showChangePattern(ClickEvent w) {
        final ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.FactType());
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.ChooseExistingPatternToAddColumnTo(), (IsWidget)pats);
        pop.add((Widget)new ModalFooterChangePattern(new Command(){

            public void execute() {
                String[] val = pats.getValue(pats.getSelectedIndex()).split("\\s");
                ActionWorkItemInsertFactPopup.this.editingCol.setFactType(val[0]);
                ActionWorkItemInsertFactPopup.this.editingCol.setBoundName(val[1]);
                ActionWorkItemInsertFactPopup.this.editingCol.setFactField(null);
                ActionWorkItemInsertFactPopup.this.doBindFieldToWorkItem();
                ActionWorkItemInsertFactPopup.this.doPatternLabel();
                ActionWorkItemInsertFactPopup.this.doFieldLabel();
                pop.hide();
                ActionWorkItemInsertFactPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionWorkItemInsertFactPopup.this.showNewPatternDialog();
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionWorkItemInsertFactPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    protected void showNewPatternDialog() {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.FactType());
        pop.setTitle(GuidedDecisionTableConstants.INSTANCE.NewFactSelectTheType());
        final ListBox types = new ListBox();
        for (int i = 0; i < this.oracle.getFactTypes().length; ++i) {
            types.addItem(this.oracle.getFactTypes()[i]);
        }
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.FactType(), (IsWidget)types);
        BindingTextBox binding = new BindingTextBox();
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Binding() + ":", (IsWidget)binding);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command((TextBox)binding, pop){
            final /* synthetic */ TextBox val$binding;
            final /* synthetic */ FormStylePopup val$pop;
            {
                this.val$binding = textBox;
                this.val$pop = formStylePopup;
            }

            public void execute() {
                String ft = types.getItemText(types.getSelectedIndex());
                String fn = this.val$binding.getText();
                if (fn.equals("")) {
                    Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameForFact());
                    return;
                }
                if (fn.equals(ft)) {
                    Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotTheSameAsTheFactType());
                    return;
                }
                if (!ActionWorkItemInsertFactPopup.this.isBindingUnique(fn)) {
                    Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern());
                    return;
                }
                ActionWorkItemInsertFactPopup.this.editingCol.setBoundName(this.val$binding.getText());
                ActionWorkItemInsertFactPopup.this.editingCol.setFactType(types.getItemText(types.getSelectedIndex()));
                ActionWorkItemInsertFactPopup.this.editingCol.setFactField(null);
                ActionWorkItemInsertFactPopup.this.doBindFieldToWorkItem();
                ActionWorkItemInsertFactPopup.this.doPatternLabel();
                ActionWorkItemInsertFactPopup.this.doFieldLabel();
                this.val$pop.hide();
                ActionWorkItemInsertFactPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionWorkItemInsertFactPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    private boolean isBindingUnique(String binding) {
        for (Pattern52 p : this.model.getPatterns()) {
            if (p.getBoundName().equals(binding)) {
                return false;
            }
            for (ConditionCol52 c : p.getChildColumns()) {
                if (!c.isBound() || !c.getBinding().equals(binding)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidFactType() {
        return this.editingCol.getFactType() != null && !"".equals(this.editingCol.getFactType());
    }

    private boolean isValidFactField() {
        return this.editingCol.getFactField() != null && !"".equals(this.editingCol.getFactField());
    }

    private Widget doInsertLogical() {
        HorizontalPanel hp = new HorizontalPanel();
        final CheckBox cb = new CheckBox();
        cb.setValue(Boolean.valueOf(this.editingCol.isInsertLogical()));
        cb.setText("");
        cb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            cb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent arg0) {
                    if (ActionWorkItemInsertFactPopup.this.oracle.isGlobalVariable(ActionWorkItemInsertFactPopup.this.editingCol.getBoundName())) {
                        cb.setEnabled(false);
                        ActionWorkItemInsertFactPopup.this.editingCol.setInsertLogical(false);
                    } else {
                        ActionWorkItemInsertFactPopup.this.editingCol.setInsertLogical(cb.getValue().booleanValue());
                    }
                }
            });
        }
        hp.add((Widget)cb);
        hp.add((IsWidget)new InfoPopup(GuidedDecisionTableConstants.INSTANCE.LogicallyInsertANewFact(), GuidedDecisionTableConstants.INSTANCE.LogicallyAssertAFactTheFactWillBeDeletedWhenTheSupportingEvidenceIsRemoved()));
        return hp;
    }

    private Widget doBindFieldToWorkItem() {
        this.workItemResultParameters.clear();
        this.workItemResultParametersMap.clear();
        ArrayList<PortableWorkDefinition> actionWorkItems = new ArrayList<PortableWorkDefinition>();
        for (ActionCol52 ac : this.model.getActionCols()) {
            if (!(ac instanceof ActionWorkItemCol52)) continue;
            PortableWorkDefinition pwd = ((ActionWorkItemCol52)ac).getWorkItemDefinition();
            actionWorkItems.add(pwd);
        }
        if (actionWorkItems.size() == 0) {
            this.workItemResultParameters.setEnabled(false);
            this.workItemResultParameters.addItem(GuidedDecisionTableConstants.INSTANCE.NoWorkItemsAvailable());
            this.editingCol.setWorkItemName(null);
            this.editingCol.setWorkItemResultParameterName(null);
            this.editingCol.setParameterClassName(null);
        } else {
            int selectedItemIndex = -1;
            String selectedItemKey = this.editingCol.getWorkItemName() + "" + this.editingCol.getWorkItemResultParameterName();
            this.workItemResultParameters.setEnabled(!this.isReadOnly);
            for (PortableWorkDefinition pwd : actionWorkItems) {
                for (PortableParameterDefinition ppd : pwd.getResults()) {
                    if (!this.acceptParameterType(ppd)) continue;
                    String key = pwd.getName() + "" + ppd.getName();
                    String parameterDisplayName = pwd.getDisplayName() + "" + ppd.getName();
                    if (key.equals(selectedItemKey)) {
                        selectedItemIndex = this.workItemResultParameters.getItemCount();
                    }
                    this.workItemResultParametersMap.put(key, new WorkItemParameter(pwd, ppd));
                    this.workItemResultParameters.addItem(parameterDisplayName, key);
                }
            }
            if (this.workItemResultParameters.getItemCount() == 0) {
                this.workItemResultParameters.setEnabled(false);
                this.workItemResultParameters.addItem(GuidedDecisionTableConstants.INSTANCE.NoWorkItemsAvailable());
                this.editingCol.setWorkItemName(null);
                this.editingCol.setWorkItemResultParameterName(null);
                this.editingCol.setParameterClassName(null);
            } else {
                if (selectedItemIndex == -1) {
                    selectedItemIndex = 0;
                    selectedItemKey = this.workItemResultParameters.getValue(selectedItemIndex);
                    WorkItemParameter wip = this.workItemResultParametersMap.get(selectedItemKey);
                    this.editingCol.setWorkItemName(wip.workDefinition.getName());
                    this.editingCol.setWorkItemResultParameterName(wip.workParameterDefinition.getName());
                    this.editingCol.setParameterClassName(wip.workParameterDefinition.getClassName());
                }
                this.workItemResultParameters.setSelectedIndex(selectedItemIndex);
            }
        }
        return this.workItemResultParameters;
    }

    private boolean acceptParameterType(PortableParameterDefinition ppd) {
        if (this.nil(this.editingCol.getFactField())) {
            return false;
        }
        if (ppd.getClassName() == null) {
            return false;
        }
        String fieldClassName = this.oracle.getFieldClassName(this.editingCol.getFactType(), this.editingCol.getFactField());
        return fieldClassName.equals(ppd.getClassName());
    }

    private void enableFooter(boolean enabled) {
        if (this.footer == null) {
            return;
        }
        this.footer.enableOkButton(enabled);
        this.footer.enableCancelButton(enabled);
    }

    private static class WorkItemParameter {
        PortableWorkDefinition workDefinition;
        PortableParameterDefinition workParameterDefinition;

        WorkItemParameter(PortableWorkDefinition workDefinition, PortableParameterDefinition workParameterDefinition) {
            this.workDefinition = workDefinition;
            this.workParameterDefinition = workParameterDefinition;
        }
    }
}

