/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.utils.GuidedDecisionTableUtils;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.ActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.ActionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.BRLFragmentActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.BRLFragmentColumnActionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.FactFieldColumnActionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.FieldActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.UnrecognizedActionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RowInspectorCache;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.BRLConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspectorBuilder;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;

public class RowInspectorGenerator {
    private final RowInspectorCache cache;
    private final GuidedDecisionTableUtils utils;
    private final GuidedDecisionTable52 model;
    private RowInspector rowInspector;
    private List<DTCellValue52> row;

    public RowInspectorGenerator(AsyncPackageDataModelOracle oracle, GuidedDecisionTable52 model, RowInspectorCache cache) {
        this.cache = cache;
        this.utils = new GuidedDecisionTableUtils(model, oracle);
        this.model = model;
    }

    public List<RowInspector> generate() {
        ArrayList<RowInspector> rowInspectors = new ArrayList<RowInspector>();
        int index = 0;
        for (List row : this.model.getData()) {
            rowInspectors.add(this.generate(index, row));
            ++index;
        }
        return rowInspectors;
    }

    public RowInspector generate(int index, List<DTCellValue52> row) {
        this.row = row;
        this.rowInspector = new RowInspector(index, this.model.getTableFormat(), this.cache);
        this.addConditionInspectors();
        this.addActionInspector();
        return this.rowInspector;
    }

    private void addActionInspector() {
        for (ActionCol52 actionCol : this.model.getActionCols()) {
            int columnIndex;
            if (actionCol instanceof BRLActionColumn) {
                BRLActionColumn brlActionColumn = (BRLActionColumn)actionCol;
                this.rowInspector.addActionInspector(new BRLFragmentActionInspector(new BRLFragmentColumnActionInspectorKey(brlActionColumn), brlActionColumn.getDefinition()));
            }
            if (!this.rowHasIndex(columnIndex = this.model.getExpandedColumns().indexOf(actionCol))) continue;
            this.addActionInspector(actionCol, this.row.get(columnIndex));
        }
    }

    private void addConditionInspectors() {
        for (CompositeColumn column : this.model.getConditions()) {
            if (!(column instanceof BRLConditionColumn)) continue;
            this.rowInspector.addConditionInspector(new BRLConditionInspector((CompositeColumn<? extends BaseColumn>)column));
        }
        for (Pattern52 pattern : this.model.getPatterns()) {
            for (ConditionCol52 conditionCol : pattern.getChildColumns()) {
                int columnIndex = this.model.getExpandedColumns().indexOf(conditionCol);
                if (!this.rowHasIndex(columnIndex)) continue;
                this.addConditionInspector(pattern, conditionCol, this.row.get(columnIndex));
            }
        }
    }

    private boolean rowHasIndex(int columnIndex) {
        return columnIndex > 0 && columnIndex < this.row.size();
    }

    private void addActionInspector(ActionCol52 actionCol, DTCellValue52 visibleCellValue) {
        if (this.isCellNotBlank((DTColumnConfig52)actionCol, visibleCellValue)) {
            this.rowInspector.addActionInspector(this.buildActionInspector(actionCol, visibleCellValue));
        }
    }

    private void addConditionInspector(Pattern52 pattern, ConditionCol52 conditionColumn, DTCellValue52 visibleCellValue) {
        if (this.isCellNotBlank((DTColumnConfig52)conditionColumn, visibleCellValue)) {
            this.rowInspector.addConditionInspector(this.buildConditionInspector(pattern, conditionColumn, visibleCellValue));
        }
    }

    private ConditionInspector buildConditionInspector(Pattern52 pattern, ConditionCol52 conditionColumn, DTCellValue52 visibleCellValue) {
        return new ConditionInspectorBuilder(this.utils, pattern, conditionColumn, this.getRealCellValue((DTColumnConfig52)conditionColumn, visibleCellValue)).buildConditionInspector();
    }

    private ActionInspector buildActionInspector(ActionCol52 actionCol, DTCellValue52 visibleCellValue) {
        return new FieldActionInspector(this.getKey(actionCol), this.getRealCellValue((DTColumnConfig52)actionCol, visibleCellValue));
    }

    private ActionInspectorKey getKey(ActionCol52 actionCol) {
        if (actionCol instanceof ActionSetFieldCol52) {
            return new FactFieldColumnActionInspectorKey((ActionSetFieldCol52)actionCol);
        }
        if (actionCol instanceof ActionInsertFactCol52) {
            return new FactFieldColumnActionInspectorKey((ActionInsertFactCol52)actionCol);
        }
        return new UnrecognizedActionInspectorKey(actionCol);
    }

    private DTCellValue52 getRealCellValue(DTColumnConfig52 config52, DTCellValue52 visibleCellValue) {
        if (config52 instanceof LimitedEntryCol) {
            return ((LimitedEntryCol)config52).getValue();
        }
        return visibleCellValue;
    }

    private boolean isCellNotBlank(DTColumnConfig52 config52, DTCellValue52 visibleCellValue) {
        if (config52 instanceof LimitedEntryCol) {
            return visibleCellValue.getBooleanValue();
        }
        return visibleCellValue.hasValue();
    }
}

