/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.ConflictingActionsFilter;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.OneToManyCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Explanation;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.NoteBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class DetectDeficientRowsCheck
extends OneToManyCheck {
    public DetectDeficientRowsCheck(RowInspector rowInspector) {
        super(rowInspector, new ConflictingActionsFilter(rowInspector));
    }

    @Override
    public void check() {
        if (this.rowInspector.getConditions().hasValues() && this.thereIsAtLestOneRow()) {
            this.hasIssues = this.isDeficient();
        }
    }

    private boolean isDeficient() {
        for (RowInspector other : this.getOtherRows()) {
            if (this.isDeficient(other)) continue;
            return false;
        }
        return true;
    }

    private boolean isDeficient(RowInspector other) {
        for (ConditionInspectorKey key : other.getConditions().keys()) {
            if (!other.getConditions().keyHasNoValues(key) || this.rowInspector.getConditions().isDeficient(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.WARNING, AnalysisConstants.INSTANCE.DeficientRow(), this.rowInspector.getRowIndex() + 1);
        ((Explanation)((NoteBuilder)issue.getExplanation().addParagraph(AnalysisConstants.INSTANCE.DeficientRowsP1()).startNote().addParagraph(AnalysisConstants.INSTANCE.DeficientRowsNoteP1()).startExampleTable().startHeader().headerConditions(AnalysisConstants.INSTANCE.Salary(), AnalysisConstants.INSTANCE.Savings()).headerActions(AnalysisConstants.INSTANCE.ApproveLoan()).end().startRow().addConditions("--", "100 000").addActions("true").end().startRow().addConditions("30 000", "--").addActions("false").end().end()).end()).addParagraph(AnalysisConstants.INSTANCE.DeficientRowsP2());
        return issue;
    }
}

