/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import java.util.List;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.ActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.FieldActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.SingleCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Conflict;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class DetectMultipleValuesForOneActionCheck
extends SingleCheck {
    private List<ActionInspector> conflictingObjects;

    public DetectMultipleValuesForOneActionCheck(RowInspector rowInspector) {
        super(rowInspector);
    }

    @Override
    public void check() {
        for (ActionInspector actionInspector : this.rowInspector.getActions().allValues()) {
            if (!Conflict.hasConflictingObjectInList(this.rowInspector.getActions().allValues(), actionInspector)) continue;
            this.hasIssues = true;
            this.conflictingObjects = Conflict.getConflictingObjects(this.rowInspector.getActions().allValues(), actionInspector);
            return;
        }
        this.hasIssues = false;
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.WARNING, AnalysisConstants.INSTANCE.MultipleValuesForOneAction(), this.rowInspector.getRowIndex() + 1);
        issue.getExplanation().startNote().addParagraph(AnalysisConstants.INSTANCE.MultipleValuesNote1P1(this.getToHumanReadableString(this.conflictingObjects.get(0)), this.getToHumanReadableString(this.conflictingObjects.get(1)))).end().addParagraph(AnalysisConstants.INSTANCE.MultipleValuesP1());
        return issue;
    }

    private String getToHumanReadableString(ActionInspector actionInspector) {
        if (actionInspector instanceof FieldActionInspector) {
            return ((FieldActionInspector)actionInspector).toHumanReadableString();
        }
        return "";
    }
}

