/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base;

import com.google.gwt.core.client.Scheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.DetectConflictingRowsCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.DetectDeficientRowsCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.DetectImpossibleMatchCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.DetectMissingActionCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.DetectMissingConditionCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.DetectMultipleValuesForOneActionCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.DetectRedundantActionCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.DetectRedundantConditionsCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.DetectRedundantRowsCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Check;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.ChecksRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.PairCheck;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public class Checks {
    private final Map<RowInspector, Set<Check>> set = new HashMap<RowInspector, Set<Check>>();
    private final Map<RowInspector, Set<Check>> rechecks = new HashMap<RowInspector, Set<Check>>();
    private final Map<RowInspector, Map<RowInspector, List<Check>>> reciprocalRowInspectors = new HashMap<RowInspector, Map<RowInspector, List<Check>>>();
    private CancellableRepeatingCommand activeAnalysis;

    public void run() {
        this.run(null, null);
    }

    public void run(ParameterizedCommand<Status> onStatus, Command onCompletion) {
        this.cancelExistingAnalysis();
        if (this.set.isEmpty() && onCompletion != null) {
            onCompletion.execute();
            return;
        }
        ChecksRepeatingCommand command = new ChecksRepeatingCommand(this.set, this.rechecks, onStatus, onCompletion);
        this.doRun(command);
    }

    protected void doRun(CancellableRepeatingCommand command) {
        this.activeAnalysis = command;
        Scheduler.get().scheduleIncremental((Scheduler.RepeatingCommand)command);
    }

    public void update(RowInspector oldRowInspector, RowInspector newRowInspector) {
        this.cancelExistingAnalysis();
        newRowInspector.setRowIndex(oldRowInspector.getRowIndex());
        this.remove(oldRowInspector);
        this.add(newRowInspector);
    }

    public Collection<Check> get(RowInspector rowInspector) {
        return this.set.get(rowInspector);
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public void add(RowInspector rowInspector) {
        this.cancelExistingAnalysis();
        this.addSingleRowChecks(rowInspector);
        this.addPairRowChecks(rowInspector);
        for (Check check : this.get(rowInspector)) {
            List<Check> reciprocalChecks;
            if (!(check instanceof PairCheck)) continue;
            RowInspector otherRowInspector = ((PairCheck)check).getOther();
            List<Check> checks = this.makePairRowChecks(otherRowInspector, rowInspector);
            this.assertChecks(otherRowInspector, checks);
            Map<RowInspector, List<Check>> reciprocalRowInspectors = this.reciprocalRowInspectors.get(rowInspector);
            if (reciprocalRowInspectors == null) {
                reciprocalRowInspectors = new HashMap<RowInspector, List<Check>>();
                this.reciprocalRowInspectors.put(rowInspector, reciprocalRowInspectors);
            }
            if ((reciprocalChecks = reciprocalRowInspectors.get(otherRowInspector)) == null) {
                reciprocalChecks = new ArrayList<Check>();
                reciprocalRowInspectors.put(otherRowInspector, reciprocalChecks);
            }
            reciprocalChecks.addAll(checks);
        }
    }

    private void addSingleRowChecks(RowInspector rowInspector) {
        List<Check> checks = this.makeSingleRowChecks(rowInspector);
        this.assertChecks(rowInspector, checks);
    }

    protected List<Check> makeSingleRowChecks(RowInspector rowInspector) {
        ArrayList<Check> checkList = new ArrayList<Check>();
        checkList.add(new DetectImpossibleMatchCheck(rowInspector));
        checkList.add(new DetectMultipleValuesForOneActionCheck(rowInspector));
        checkList.add(new DetectMissingActionCheck(rowInspector));
        checkList.add(new DetectMissingConditionCheck(rowInspector));
        checkList.add(new DetectDeficientRowsCheck(rowInspector));
        checkList.add(new DetectRedundantActionCheck(rowInspector));
        checkList.add(new DetectRedundantConditionsCheck(rowInspector));
        return checkList;
    }

    private void addPairRowChecks(RowInspector rowInspector) {
        for (RowInspector other : rowInspector.getCache().all()) {
            if (rowInspector.equals(other)) continue;
            List<Check> checks = this.makePairRowChecks(rowInspector, other);
            this.assertChecks(rowInspector, checks);
        }
    }

    protected List<Check> makePairRowChecks(RowInspector rowInspector, RowInspector other) {
        ArrayList<Check> checkList = new ArrayList<Check>();
        if (other.getRowIndex() != rowInspector.getRowIndex()) {
            checkList.add(new DetectConflictingRowsCheck(rowInspector, other));
            checkList.add(new DetectRedundantRowsCheck(rowInspector, other));
        }
        return checkList;
    }

    private void assertChecks(RowInspector rowInspector, List<Check> checks) {
        Set<Check> existingSetChecks = this.set.get(rowInspector);
        if (existingSetChecks == null) {
            this.set.put(rowInspector, new HashSet<Check>(checks));
        } else {
            existingSetChecks.addAll(checks);
        }
        Set<Check> existingRechecks = this.rechecks.get(rowInspector);
        if (existingRechecks == null) {
            this.rechecks.put(rowInspector, new HashSet<Check>(checks));
        } else {
            existingRechecks.addAll(checks);
        }
    }

    public Collection<Check> remove(RowInspector removedRowInspector) {
        this.cancelExistingAnalysis();
        HashSet<Check> removedChecks = new HashSet<Check>();
        for (Map.Entry<RowInspector, List<Check>> reciprocalRowInspectors : this.reciprocalRowInspectors.remove(removedRowInspector).entrySet()) {
            RowInspector reciprocalRowInspector = reciprocalRowInspectors.getKey();
            List<Check> reciprocalChecks = reciprocalRowInspectors.getValue();
            removedChecks.addAll(reciprocalChecks);
            if (!this.set.containsKey(reciprocalRowInspector)) continue;
            this.set.get(reciprocalRowInspector).removeAll(reciprocalChecks);
        }
        removedChecks.addAll((Collection)this.set.get(removedRowInspector));
        this.set.remove(removedRowInspector);
        return removedChecks;
    }

    public void cancelExistingAnalysis() {
        if (this.activeAnalysis != null) {
            this.activeAnalysis.cancel();
            this.activeAnalysis = null;
        }
    }
}

