/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Check;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.OneToManyCheck;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public class ChecksRepeatingCommand
implements CancellableRepeatingCommand {
    private static final int BLOCK_SIZE = 10;
    private boolean isCancelled = false;
    private int startRowInspectorIndex = 0;
    private int endRowInspectorIndex = 10;
    private Map<RowInspector, Set<Check>> set = new HashMap<RowInspector, Set<Check>>();
    private Map<RowInspector, Set<Check>> rechecks = new HashMap<RowInspector, Set<Check>>();
    private List<RowInspector> rowInspectorsToCheck = new ArrayList<RowInspector>();
    private ParameterizedCommand<Status> onStatus;
    private Command onCompletion;

    public ChecksRepeatingCommand(Map<RowInspector, Set<Check>> set, Map<RowInspector, Set<Check>> rechecks, ParameterizedCommand<Status> onStatus, Command onCompletion) {
        this.set.putAll(set);
        this.rechecks.putAll(rechecks);
        this.rowInspectorsToCheck.addAll(set.keySet());
        this.onStatus = onStatus;
        this.onCompletion = onCompletion;
        this.startRowInspectorIndex = 0;
        this.endRowInspectorIndex = Math.min(this.rowInspectorsToCheck.size(), 10);
    }

    public boolean execute() {
        for (int ri = this.startRowInspectorIndex; ri < this.endRowInspectorIndex; ++ri) {
            if (this.isCancelled()) {
                return false;
            }
            RowInspector rowInspector = this.rowInspectorsToCheck.get(ri);
            Set<Check> rowInspectorChecks = this.set.get(rowInspector);
            if (this.onStatus != null) {
                this.onStatus.execute((Object)new Status(this.startRowInspectorIndex, this.endRowInspectorIndex, this.rowInspectorsToCheck.size()));
            }
            for (Check check : rowInspectorChecks) {
                if (this.isCancelled()) {
                    return false;
                }
                if (!(check instanceof OneToManyCheck)) continue;
                Set<Check> existingRechecks = this.rechecks.get(rowInspector);
                if (existingRechecks == null) {
                    this.rechecks.put(rowInspector, new HashSet<Check>(rowInspectorChecks));
                    continue;
                }
                existingRechecks.addAll(rowInspectorChecks);
            }
            Set<Check> checksToRun = this.rechecks.get(rowInspector);
            for (Check checkToRun : checksToRun) {
                if (this.isCancelled()) {
                    return false;
                }
                checkToRun.check();
            }
        }
        this.startRowInspectorIndex = this.endRowInspectorIndex + 1;
        this.endRowInspectorIndex += 10;
        if (this.endRowInspectorIndex > this.rowInspectorsToCheck.size() - 1) {
            this.endRowInspectorIndex = this.rowInspectorsToCheck.size() - 1;
        }
        if (this.startRowInspectorIndex > this.rowInspectorsToCheck.size() - 1) {
            this.complete();
            return false;
        }
        return true;
    }

    private boolean isCancelled() {
        if (this.isCancelled) {
            this.complete();
        }
        return this.isCancelled;
    }

    private void complete() {
        if (this.onCompletion != null) {
            this.onCompletion.execute();
        }
        this.rechecks.clear();
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }
}

