/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.auditlog.AuditLogEntry;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.models.guided.dtable.shared.auditlog.DeleteColumnAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.DeleteRowAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.InsertColumnAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.InsertRowAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.UpdateColumnAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiffImpl;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.utils.DTCellValueUtilities;
import org.drools.workbench.screens.guided.dtable.client.utils.GuidedDecisionTableUtils;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.ValidateEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.AbstractDecoratedDecisionTableGridWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.DecisionTableCellFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.DecisionTableCellValueFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.DecisionTableDropDownManager;
import org.drools.workbench.screens.guided.dtable.client.widget.table.DecisionTableResourcesProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.BoundFactsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.InsertDecisionTableColumnEvent;
import org.drools.workbench.screens.guided.rule.client.util.GWTDateConverter;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.CellValue;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.DecoratedGridCellValueAdaptor;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AppendRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.CellStateChangedEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.CopyRowsEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteColumnEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertColumnEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.MoveColumnsEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.PasteRowsEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.SelectedCellChangeEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.SetColumnVisibilityEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.ToggleMergingEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateColumnDataEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateColumnDefinitionEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateModelEvent;

public abstract class AbstractDecisionTableWidget
extends Composite
implements SelectedCellChangeEvent.Handler,
InsertRowEvent.Handler,
DeleteRowEvent.Handler,
AppendRowEvent.Handler,
CopyRowsEvent.Handler,
PasteRowsEvent.Handler,
DeleteColumnEvent.Handler,
InsertColumnEvent.Handler<BaseColumn, DTCellValue52>,
MoveColumnsEvent.Handler,
UpdateModelEvent.Handler {
    protected AbstractDecoratedDecisionTableGridWidget widget;
    protected GuidedDecisionTableUtils utils;
    protected DTCellValueUtilities cellUtils;
    protected final GuidedDecisionTable52 model;
    protected final AsyncPackageDataModelOracle oracle;
    protected final DecisionTableCellFactory cellFactory;
    protected final DecisionTableCellValueFactory cellValueFactory;
    protected final DecisionTableDropDownManager dropDownManager;
    protected final EventBus eventBus;
    protected final boolean isReadOnly;
    private final BRLRuleModel rm;
    private final User identity;
    private List<List<DTCellValue52>> copiedRows = new ArrayList<List<DTCellValue52>>();
    protected static final DecisionTableResourcesProvider resources = new DecisionTableResourcesProvider();

    public AbstractDecisionTableWidget(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, User identity, boolean isReadOnly, EventBus eventBus) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        if (oracle == null) {
            throw new IllegalArgumentException("oracle cannot be null");
        }
        if (identity == null) {
            throw new IllegalArgumentException("identity cannot be null");
        }
        if (eventBus == null) {
            throw new IllegalArgumentException("eventBus cannot be null");
        }
        this.model = model;
        this.oracle = oracle;
        this.identity = identity;
        this.rm = new BRLRuleModel(model);
        this.utils = new GuidedDecisionTableUtils(model, oracle);
        this.cellUtils = new DTCellValueUtilities(model, oracle);
        this.eventBus = eventBus;
        this.isReadOnly = isReadOnly;
        for (CompositeColumn cc : model.getConditions()) {
            if (!(cc instanceof Pattern52)) continue;
            Pattern52 p = (Pattern52)cc;
            Iterator iterator = p.getChildColumns().iterator();
            while (iterator.hasNext()) {
                ConditionCol52 col;
                ConditionCol52 c = col = (ConditionCol52)iterator.next();
                c.setFieldType(oracle.getFieldType(p.getFactType(), c.getFactField()));
            }
        }
        this.dropDownManager = new DecisionTableDropDownManager(model, oracle);
        this.cellFactory = new DecisionTableCellFactory(model, oracle, this.dropDownManager, isReadOnly, eventBus);
        this.cellValueFactory = new DecisionTableCellValueFactory(model, oracle);
        DTCellValueUtilities.injectDateConvertor(GWTDateConverter.getInstance());
        eventBus.addHandler(InsertRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DeleteRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(AppendRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(CopyRowsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(PasteRowsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(SelectedCellChangeEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DeleteColumnEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(InsertDecisionTableColumnEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(MoveColumnsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(UpdateModelEvent.TYPE, (EventHandler)this);
    }

    public void addColumn(ActionCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getActionCols().add(modelColumn);
        this.addColumn(modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
        this.model.getAuditLog().add((AuditLogEntry)new InsertColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void addColumn(BRLActionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getActionCols().add(modelColumn);
        this.addBRLActionVariableColumns(modelColumn.getChildColumns(), true);
        this.model.getAuditLog().add((AuditLogEntry)new InsertColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void addColumn(LimitedEntryBRLActionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getActionCols().add(modelColumn);
        this.addColumn((ActionCol52)modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
        this.model.getAuditLog().add((AuditLogEntry)new InsertColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void addColumn(BRLConditionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getConditions().add(modelColumn);
        this.addBRLConditionVariableColumns(modelColumn.getChildColumns(), true);
        this.model.getAuditLog().add((AuditLogEntry)new InsertColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void addColumn(LimitedEntryBRLConditionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getConditions().add(modelColumn);
        this.addColumn((ConditionCol52)modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
        this.model.getAuditLog().add((AuditLogEntry)new InsertColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void addColumn(AttributeCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getAttributeCols().add(modelColumn);
        this.addColumn(modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
        this.model.getAuditLog().add((AuditLogEntry)new InsertColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void addColumn(MetadataCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getMetadataCols().add(modelColumn);
        this.addColumn(modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
        this.model.getAuditLog().add((AuditLogEntry)new InsertColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void addColumn(Pattern52 pattern, ConditionCol52 modelColumn) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null.");
        }
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        if (!this.model.getConditions().contains(pattern)) {
            this.model.getConditions().add(pattern);
            BoundFactsChangedEvent pce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
            this.eventBus.fireEvent((GwtEvent)pce);
        }
        pattern.getChildColumns().add(modelColumn);
        this.addColumn(modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
        this.model.getAuditLog().add((AuditLogEntry)new InsertColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void deleteColumn(ActionCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        this.model.getActionCols().remove(modelColumn);
        this.deleteColumn(index, true);
        this.model.getAuditLog().add((AuditLogEntry)new DeleteColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void deleteColumn(BRLActionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        BRLActionVariableColumn firstColumn = (BRLActionVariableColumn)modelColumn.getChildColumns().get(0);
        int firstColumnIndex = this.model.getExpandedColumns().indexOf(firstColumn);
        if (firstColumnIndex >= 0) {
            int numberOfColumns = modelColumn.getChildColumns().size();
            this.deleteColumns(firstColumnIndex, numberOfColumns, true);
            this.model.getActionCols().remove(modelColumn);
            this.model.getAuditLog().add((AuditLogEntry)new DeleteColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
        }
    }

    public void deleteColumn(LimitedEntryBRLActionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        this.model.getActionCols().remove(modelColumn);
        this.deleteColumn(index, true);
        this.model.getAuditLog().add((AuditLogEntry)new DeleteColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void deleteColumn(BRLConditionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        BRLConditionVariableColumn firstColumn = (BRLConditionVariableColumn)modelColumn.getChildColumns().get(0);
        int firstColumnIndex = this.model.getExpandedColumns().indexOf(firstColumn);
        if (firstColumnIndex >= 0) {
            int numberOfColumns = modelColumn.getChildColumns().size();
            this.deleteColumns(firstColumnIndex, numberOfColumns, true);
            this.model.getConditions().remove(modelColumn);
            this.model.getAuditLog().add((AuditLogEntry)new DeleteColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
        }
    }

    public void deleteColumn(LimitedEntryBRLConditionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        this.model.getConditions().remove(modelColumn);
        this.deleteColumn(index, true);
        this.model.getAuditLog().add((AuditLogEntry)new DeleteColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void deleteColumn(AttributeCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        if (index >= 0) {
            this.model.getAttributeCols().remove(modelColumn);
            this.deleteColumn(index, true);
            this.model.getAuditLog().add((AuditLogEntry)new DeleteColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
        }
    }

    public void deleteColumn(MetadataCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        this.model.getMetadataCols().remove(modelColumn);
        this.deleteColumn(index, true);
        this.model.getAuditLog().add((AuditLogEntry)new DeleteColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    public void deleteColumn(ConditionCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        Pattern52 pattern = this.model.getPattern(modelColumn);
        pattern.getChildColumns().remove(modelColumn);
        if (pattern.getChildColumns().size() == 0) {
            this.model.getConditions().remove(pattern);
            BoundFactsChangedEvent pce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
            this.eventBus.fireEvent((GwtEvent)pce);
        }
        this.deleteColumn(index, true);
        this.model.getAuditLog().add((AuditLogEntry)new DeleteColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)modelColumn));
    }

    private void deleteColumn(int index, boolean redraw) {
        DeleteColumnEvent dce = new DeleteColumnEvent(index, redraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void deleteColumns(int firstColumnIndex, int numberOfColumns, boolean redraw) {
        DeleteColumnEvent dce = new DeleteColumnEvent(firstColumnIndex, numberOfColumns, redraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    public void appendRow() {
        AppendRowEvent are = new AppendRowEvent();
        this.eventBus.fireEvent((GwtEvent)are);
    }

    public AsyncPackageDataModelOracle getOracle() {
        return this.oracle;
    }

    public void makeOtherwiseCell() {
        HashSet<CellStateChangedEvent.CellStateOperation> operations = new HashSet<CellStateChangedEvent.CellStateOperation>();
        operations.add(new CellStateChangedEvent.CellStateOperation(CellValue.CellState.OTHERWISE, CellStateChangedEvent.Operation.ADD));
        CellStateChangedEvent csce = new CellStateChangedEvent(operations);
        this.eventBus.fireEvent((GwtEvent)csce);
    }

    public void setColumnVisibility(DTColumnConfig52 modelColumn, boolean isVisible) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        SetColumnVisibilityEvent scve = new SetColumnVisibilityEvent(index, isVisible);
        this.eventBus.fireEvent((GwtEvent)scve);
    }

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.widget.setPixelSize(width, height);
    }

    public void updateColumn(ActionInsertFactCol52 origColumn, ActionInsertFactCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnData = false;
        boolean bUpdateColumnDefinition = false;
        boolean isHideUpdated = false;
        boolean isBoundNameUpdated = false;
        boolean isFactTypeUpdated = false;
        boolean isFactFieldUpdated = false;
        boolean isValueListUpdated = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        List diffs = origColumn.diff((BaseColumn)editColumn);
        if (diffs != null && !diffs.isEmpty()) {
            bUpdateColumnDefinition = true;
            isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
            isBoundNameUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"boundName", (List)diffs);
            isFactTypeUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"factType", (List)diffs);
            isFactFieldUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"factField", (List)diffs);
            isValueListUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"valueList", (List)diffs);
        }
        if (isHideUpdated) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!isBoundNameUpdated && (isFactTypeUpdated || isFactFieldUpdated)) {
            bUpdateColumnData = true;
        } else if (isFactTypeUpdated || isFactFieldUpdated) {
            bUpdateColumnData = true;
        }
        if (isValueListUpdated) {
            bUpdateColumnData = this.updateCellsForOptionValueList((DTColumnConfig52)editColumn, (DTColumnConfig52)origColumn);
        }
        if (bUpdateColumnDefinition) {
            this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn, diffs));
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnData) {
            ToggleMergingEvent tme = new ToggleMergingEvent(false);
            this.eventBus.fireEvent((GwtEvent)tme);
        }
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor<? extends Comparable<?>> cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
        if (bUpdateColumnData) {
            UpdateColumnDataEvent updateColumnData = new UpdateColumnDataEvent(iCol, this.getColumnData((BaseColumn)origColumn));
            this.eventBus.fireEvent((GwtEvent)updateColumnData);
        }
    }

    public void updateColumn(ActionSetFieldCol52 origColumn, ActionSetFieldCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnData = false;
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        boolean isHideUpdated = false;
        boolean isBoundNameUpdated = false;
        boolean isFactFieldUpdated = false;
        boolean isValueListUpdated = false;
        List diffs = origColumn.diff((BaseColumn)editColumn);
        if (diffs != null && !diffs.isEmpty()) {
            bUpdateColumnDefinition = true;
            isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
            isBoundNameUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"boundName", (List)diffs);
            isFactFieldUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"factField", (List)diffs);
            isValueListUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"valueList", (List)diffs);
        }
        if (isHideUpdated) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (isBoundNameUpdated && isFactFieldUpdated) {
            bUpdateColumnData = true;
        } else if (isFactFieldUpdated) {
            bUpdateColumnData = true;
        }
        if (isValueListUpdated) {
            bUpdateColumnData = this.updateCellsForOptionValueList((DTColumnConfig52)editColumn, (DTColumnConfig52)origColumn);
        }
        if (bUpdateColumnDefinition) {
            this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn, diffs));
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnData) {
            ToggleMergingEvent tme = new ToggleMergingEvent(false);
            this.eventBus.fireEvent((GwtEvent)tme);
        }
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor<? extends Comparable<?>> cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
        if (bUpdateColumnData) {
            UpdateColumnDataEvent updateColumnData = new UpdateColumnDataEvent(iCol, this.getColumnData((BaseColumn)origColumn));
            this.eventBus.fireEvent((GwtEvent)updateColumnData);
        }
    }

    public void updateColumn(ActionWorkItemSetFieldCol52 origColumn, ActionWorkItemSetFieldCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        boolean isHideUpdated = false;
        List diffs = origColumn.diff((BaseColumn)editColumn);
        if (diffs != null && !diffs.isEmpty()) {
            bUpdateColumnDefinition = true;
            isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
        }
        if (isHideUpdated) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (bUpdateColumnDefinition) {
            this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn, diffs));
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor<? extends Comparable<?>> cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
    }

    public void updateColumn(ActionRetractFactCol52 origColumn, ActionRetractFactCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        boolean isHideUpdated = false;
        List diffs = origColumn.diff((BaseColumn)editColumn);
        if (diffs != null && !diffs.isEmpty()) {
            bUpdateColumnDefinition = true;
            isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
        }
        if (isHideUpdated) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (bUpdateColumnDefinition) {
            this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn, diffs));
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor<? extends Comparable<?>> cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
    }

    public void updateColumn(ActionWorkItemCol52 origColumn, ActionWorkItemCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        boolean isHideUpdated = false;
        List diffs = origColumn.diff((BaseColumn)editColumn);
        if (diffs != null && !diffs.isEmpty()) {
            bUpdateColumnDefinition = true;
            isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
        }
        if (isHideUpdated) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (bUpdateColumnDefinition) {
            this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn, diffs));
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor<? extends Comparable<?>> cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
    }

    public void updateColumn(BRLActionColumn origColumn, BRLActionColumn editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        List diffs = origColumn.diff((BaseColumn)editColumn);
        if (diffs != null && !diffs.isEmpty()) {
            bUpdateColumnDefinition = true;
        }
        HashMap origColumnVariables = new HashMap();
        for (BRLActionVariableColumn variable : origColumn.getChildColumns()) {
            int iCol = this.model.getExpandedColumns().indexOf(variable);
            ArrayList columnData = new ArrayList();
            String key = this.getUpdateBRLActionColumnKey(variable);
            for (List row : this.model.getData()) {
                columnData.add(row.get(iCol));
            }
            origColumnVariables.put(key, columnData);
        }
        this.model.getActionCols().add(this.model.getActionCols().indexOf(origColumn), editColumn);
        int index = this.model.getExpandedColumns().indexOf(editColumn.getChildColumns().get(0));
        ArrayList<BaseColumn> columns = new ArrayList<BaseColumn>();
        ArrayList<List<DTCellValue52>> columnsData = new ArrayList<List<DTCellValue52>>();
        columns.addAll(editColumn.getChildColumns());
        for (BaseColumn column : columns) {
            BRLActionVariableColumn variable = (BRLActionVariableColumn)column;
            String key = this.getUpdateBRLActionColumnKey(variable);
            List<DTCellValue52> columnData = (List<DTCellValue52>)origColumnVariables.get(key);
            if (columnData == null) {
                columnData = this.cellValueFactory.makeColumnData((BaseColumn)variable);
            }
            columnsData.add(columnData);
        }
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent(columns, columnsData, index, true);
        this.eventBus.fireEvent((GwtEvent)dce);
        BRLActionVariableColumn firstColumn = (BRLActionVariableColumn)origColumn.getChildColumns().get(0);
        int firstColumnIndex = this.model.getExpandedColumns().indexOf(firstColumn);
        int numberOfColumns = origColumn.getChildColumns().size();
        this.deleteColumns(firstColumnIndex, numberOfColumns, true);
        this.model.getActionCols().remove(origColumn);
        if (bUpdateColumnDefinition) {
            this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn, diffs));
        }
    }

    private String getUpdateBRLActionColumnKey(BRLActionVariableColumn variable) {
        StringBuilder key = new StringBuilder(variable.getVarName()).append(":").append(variable.getFieldType()).append(":").append(variable.getFactField()).append(":").append(variable.getFactType());
        return key.toString();
    }

    public void updateColumn(BRLConditionColumn origColumn, BRLConditionColumn editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        List diffs = origColumn.diff((BaseColumn)editColumn);
        if (diffs != null && !diffs.isEmpty()) {
            bUpdateColumnDefinition = true;
        }
        HashMap origColumnVariables = new HashMap();
        for (BRLConditionVariableColumn variable : origColumn.getChildColumns()) {
            int iCol = this.model.getExpandedColumns().indexOf(variable);
            ArrayList columnData = new ArrayList();
            String key = this.getUpdateBRLConditionColumnKey(variable);
            for (List row : this.model.getData()) {
                columnData.add(row.get(iCol));
            }
            origColumnVariables.put(key, columnData);
        }
        this.model.getConditions().add(this.model.getConditions().indexOf(origColumn), editColumn);
        int index = this.model.getExpandedColumns().indexOf(editColumn.getChildColumns().get(0));
        ArrayList<BaseColumn> columns = new ArrayList<BaseColumn>();
        ArrayList<List<DTCellValue52>> columnsData = new ArrayList<List<DTCellValue52>>();
        columns.addAll(editColumn.getChildColumns());
        for (BaseColumn column : columns) {
            BRLConditionVariableColumn variable = (BRLConditionVariableColumn)column;
            String key = this.getUpdateBRLConditionColumnKey(variable);
            List<DTCellValue52> columnData = (List<DTCellValue52>)origColumnVariables.get(key);
            if (columnData == null) {
                columnData = this.cellValueFactory.makeColumnData((BaseColumn)variable);
            }
            columnsData.add(columnData);
        }
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent(columns, columnsData, index, true);
        this.eventBus.fireEvent((GwtEvent)dce);
        BRLConditionVariableColumn firstColumn = (BRLConditionVariableColumn)origColumn.getChildColumns().get(0);
        int firstColumnIndex = this.model.getExpandedColumns().indexOf(firstColumn);
        int numberOfColumns = origColumn.getChildColumns().size();
        this.deleteColumns(firstColumnIndex, numberOfColumns, true);
        this.model.getConditions().remove(origColumn);
        if (bUpdateColumnDefinition) {
            this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn, diffs));
        }
        BoundFactsChangedEvent pce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
        this.eventBus.fireEvent((GwtEvent)pce);
    }

    private String getUpdateBRLConditionColumnKey(BRLConditionVariableColumn variable) {
        StringBuilder key = new StringBuilder(variable.getVarName()).append(":").append(variable.getFieldType()).append(":").append(variable.getFactField()).append(":").append(variable.getFactType());
        return key.toString();
    }

    public void updateColumn(LimitedEntryBRLConditionColumn origColumn, LimitedEntryBRLConditionColumn editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        boolean isHideUpdated = false;
        List diffs = origColumn.diff((BaseColumn)editColumn);
        if (diffs != null && !diffs.isEmpty()) {
            bUpdateColumnDefinition = true;
            isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
        }
        if (isHideUpdated) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (bUpdateColumnDefinition) {
            this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn));
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor<? extends Comparable<?>> cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
    }

    public void updateColumn(LimitedEntryBRLActionColumn origColumn, LimitedEntryBRLActionColumn editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        boolean isHideUpdated = false;
        List diffs = origColumn.diff((BaseColumn)editColumn);
        if (diffs != null && !diffs.isEmpty()) {
            bUpdateColumnDefinition = true;
            isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
        }
        if (isHideUpdated) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (bUpdateColumnDefinition) {
            this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn, diffs));
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor<? extends Comparable<?>> cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
    }

    public void updateColumn(Pattern52 origPattern, ConditionCol52 origColumn, Pattern52 editPattern, ConditionCol52 editColumn) {
        if (origPattern == null) {
            throw new IllegalArgumentException("origPattern cannot be null");
        }
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editPattern == null) {
            throw new IllegalArgumentException("editPattern cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        List patternDiff = null;
        boolean existPattern = false;
        if (this.model.getConditions() != null && !this.model.getConditions().isEmpty()) {
            for (CompositeColumn col : this.model.getConditions()) {
                try {
                    Pattern52 existingCol = (Pattern52)col;
                    if (!existingCol.getBoundName().equals(editPattern.getBoundName())) continue;
                    existPattern = true;
                    break;
                }
                catch (ClassCastException existingCol) {
                }
            }
        }
        patternDiff = origPattern.diff((BaseColumn)editPattern);
        if (!existPattern) {
            this.model.getConditions().add(editPattern);
            BoundFactsChangedEvent pce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
            this.eventBus.fireEvent((GwtEvent)pce);
        } else {
            origPattern.update(editPattern);
        }
        boolean bUpdateColumnData = false;
        boolean bUpdateColumnDefinition = false;
        if (!this.isEqualOrNull(origPattern.getBoundName(), editPattern.getBoundName())) {
            editPattern.getChildColumns().add(editColumn);
            List<DTCellValue52> columnData = this.cellValueFactory.makeColumnData((BaseColumn)editColumn);
            int origColumnIndex = this.model.getExpandedColumns().indexOf(origColumn);
            if (this.isEqualOrNull(origPattern.getFactType(), editPattern.getFactType()) && this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField()) && origColumn.getConstraintValueType() == editColumn.getConstraintValueType()) {
                columnData.clear();
                for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
                    List row = (List)this.model.getData().get(iRow);
                    columnData.add((DTCellValue52)row.get(origColumnIndex));
                }
            }
            this.addColumn(editColumn, columnData, true);
            origPattern.getChildColumns().remove(origColumn);
            if (origPattern.getChildColumns().size() == 0) {
                this.model.getConditions().remove(origPattern);
                BRLRuleModel rm = new BRLRuleModel(this.model);
                BoundFactsChangedEvent pce = new BoundFactsChangedEvent(rm.getLHSBoundFacts());
                this.eventBus.fireEvent((GwtEvent)pce);
            }
            this.deleteColumn(origColumnIndex, true);
            ArrayList diffs = origColumn.diff((BaseColumn)editColumn);
            if (patternDiff != null && !patternDiff.isEmpty()) {
                if (diffs == null) {
                    diffs = new ArrayList(patternDiff.size());
                }
                diffs.addAll(patternDiff);
            }
            this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn, diffs));
        } else {
            boolean isHideUpdated = false;
            boolean isOperatorUpdated = false;
            boolean isFieldTypeUpdated = false;
            boolean isFactFieldUpdated = false;
            boolean isFactTypeUpdated = false;
            boolean isConstraintValueTypeUpdated = false;
            boolean isValueListUpdated = false;
            ArrayList diffs = origColumn.diff((BaseColumn)editColumn);
            if (diffs != null && !diffs.isEmpty()) {
                bUpdateColumnDefinition = true;
                isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
                isOperatorUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"operator", (List)diffs);
                isFieldTypeUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"fieldType", diffs);
                isFactFieldUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"factField", diffs);
                isFactTypeUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"factType", diffs);
                isConstraintValueTypeUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"valueList", diffs);
                isValueListUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"valueList", diffs);
            }
            if (patternDiff != null && !patternDiff.isEmpty()) {
                if (diffs == null) {
                    diffs = new ArrayList(patternDiff.size());
                }
                diffs.addAll(patternDiff);
                bUpdateColumnDefinition = true;
            }
            if (isHideUpdated) {
                this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
            }
            if (isOperatorUpdated && !this.canAcceptOtherwiseValues((BaseColumn)editColumn)) {
                this.removeOtherwiseStates((DTColumnConfig52)origColumn);
                bUpdateColumnData = true;
            }
            if (isOperatorUpdated && !this.canAcceptCommaSeparatedValues((BaseColumn)editColumn)) {
                this.cellUtils.removeCommaSeparatedValue(editColumn.getDefaultValue());
                this.removeCommaSeparatedValues((DTColumnConfig52)origColumn);
                bUpdateColumnData = true;
            }
            if (isFactTypeUpdated || isFactFieldUpdated || isFieldTypeUpdated || isOperatorUpdated || isConstraintValueTypeUpdated) {
                bUpdateColumnData = true;
            }
            if (isValueListUpdated) {
                bUpdateColumnData = this.updateCellsForOptionValueList((DTColumnConfig52)editColumn, (DTColumnConfig52)origColumn);
            }
            if (origColumn.isBound() && editColumn.isBound() && !origColumn.getBinding().equals(editColumn.getBinding())) {
                bUpdateColumnDefinition = true;
            }
            if (bUpdateColumnDefinition) {
                this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), (BaseColumn)origColumn, (BaseColumn)editColumn, diffs));
            }
            this.populateModelColumn(origColumn, editColumn);
        }
        if (bUpdateColumnData) {
            ToggleMergingEvent tme = new ToggleMergingEvent(false);
            this.eventBus.fireEvent((GwtEvent)tme);
        }
        if (bUpdateColumnDefinition) {
            int iCol = this.model.getExpandedColumns().indexOf(origColumn);
            DecoratedGridCellValueAdaptor<? extends Comparable<?>> cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
        if (bUpdateColumnData) {
            int iCol = this.model.getExpandedColumns().indexOf(origColumn);
            UpdateColumnDataEvent updateColumnData = new UpdateColumnDataEvent(iCol, this.getColumnData((BaseColumn)origColumn));
            this.eventBus.fireEvent((GwtEvent)updateColumnData);
        }
    }

    public void updateSystemControlledColumnValues() {
        for (BaseColumn column : this.model.getExpandedColumns()) {
            AttributeCol52 attrCol;
            if (column instanceof RowNumberCol52) {
                this.updateRowNumberColumnValues(column);
                continue;
            }
            if (!(column instanceof AttributeCol52) || !(attrCol = (AttributeCol52)column).getAttribute().equals("salience")) continue;
            this.updateSalienceColumnValues(attrCol);
        }
    }

    private void addColumn(MetadataCol52 modelColumn, List<DTCellValue52> columnData, boolean bRedraw) {
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent((BaseColumn)modelColumn, columnData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void addColumn(AttributeCol52 modelColumn, List<DTCellValue52> columnData, boolean bRedraw) {
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent((BaseColumn)modelColumn, columnData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void addColumn(ConditionCol52 modelColumn, List<DTCellValue52> columnData, boolean bRedraw) {
        int index = this.findConditionColumnIndex(modelColumn);
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent((BaseColumn)modelColumn, columnData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void addColumn(ActionCol52 modelColumn, List<DTCellValue52> columnData, boolean bRedraw) {
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent((BaseColumn)modelColumn, columnData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void addBRLActionVariableColumns(List<BRLActionVariableColumn> modelColumns, boolean bRedraw) {
        int index = this.model.getExpandedColumns().indexOf(modelColumns.get(0));
        ArrayList<BaseColumn> columns = new ArrayList<BaseColumn>();
        ArrayList<List<DTCellValue52>> columnsData = new ArrayList<List<DTCellValue52>>();
        columns.addAll(modelColumns);
        for (BaseColumn column : columns) {
            columnsData.add(this.cellValueFactory.makeColumnData(column));
        }
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent(columns, columnsData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void addBRLConditionVariableColumns(List<BRLConditionVariableColumn> modelColumns, boolean bRedraw) {
        int index = this.model.getExpandedColumns().indexOf(modelColumns.get(0));
        ArrayList<BaseColumn> columns = new ArrayList<BaseColumn>();
        ArrayList<List<DTCellValue52>> columnsData = new ArrayList<List<DTCellValue52>>();
        columns.addAll(modelColumns);
        for (BaseColumn column : columns) {
            columnsData.add(this.cellValueFactory.makeColumnData(column));
        }
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent(columns, columnsData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private boolean canAcceptOtherwiseValues(BaseColumn column) {
        if (!(column instanceof ConditionCol52)) {
            return false;
        }
        ConditionCol52 cc = (ConditionCol52)column;
        if (cc.getConstraintValueType() != 1) {
            return false;
        }
        if (cc.getOperator() == null) {
            return false;
        }
        if (cc.getOperator().equals("==")) {
            return true;
        }
        return cc.getOperator().equals("!=");
    }

    private boolean canAcceptCommaSeparatedValues(BaseColumn column) {
        if (!(column instanceof ConditionCol52)) {
            return false;
        }
        ConditionCol52 cc = (ConditionCol52)column;
        if (cc.getConstraintValueType() != 1) {
            return false;
        }
        List<String> ops = Arrays.asList(OperatorsOracle.EXPLICIT_LIST_OPERATORS);
        return ops.contains(cc.getOperator());
    }

    private int findConditionColumnIndex(ConditionCol52 col) {
        int index = 0;
        boolean bMatched = false;
        List columns = this.model.getExpandedColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            BaseColumn column = (BaseColumn)columns.get(iCol);
            if (column instanceof RowNumberCol52) {
                index = iCol;
                continue;
            }
            if (column instanceof DescriptionCol52) {
                index = iCol;
                continue;
            }
            if (column instanceof MetadataCol52) {
                index = iCol;
                continue;
            }
            if (column instanceof AttributeCol52) {
                index = iCol;
                continue;
            }
            if (!(column instanceof ConditionCol52)) continue;
            if (this.isEquivalentConditionColumn((ConditionCol52)column, col)) {
                index = iCol;
                bMatched = true;
                continue;
            }
            if (bMatched) continue;
            index = iCol;
        }
        return index;
    }

    private List<CellValue<? extends Comparable<?>>> getColumnData(BaseColumn column) {
        int iColIndex = this.model.getExpandedColumns().indexOf(column);
        ArrayList columnData = new ArrayList();
        for (List row : this.model.getData()) {
            DTCellValue52 dcv = (DTCellValue52)row.get(iColIndex);
            columnData.add(this.cellValueFactory.convertModelCellValue(column, dcv));
        }
        return columnData;
    }

    private boolean isEqualOrNull(Object s1, Object s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1 != null && s2 != null && s1.equals(s2);
    }

    private boolean isEquivalentConditionColumn(ConditionCol52 c1, ConditionCol52 c2) {
        Pattern52 c1Pattern = this.model.getPattern(c1);
        Pattern52 c2Pattern = this.model.getPattern(c2);
        return this.isEqualOrNull(c1Pattern.getFactType(), c2Pattern.getFactType()) && this.isEqualOrNull(c1Pattern.getBoundName(), c2Pattern.getBoundName());
    }

    private void populateModelColumn(ActionInsertFactCol52 col, ActionInsertFactCol52 editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setFactType(editingCol.getFactType());
        col.setInsertLogical(editingCol.isInsertLogical());
        if (col instanceof LimitedEntryCol && editingCol instanceof LimitedEntryCol) {
            ((LimitedEntryCol)col).setValue(((LimitedEntryCol)editingCol).getValue());
        }
    }

    private void populateModelColumn(ActionSetFieldCol52 col, ActionSetFieldCol52 editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setUpdate(editingCol.isUpdate());
        if (col instanceof LimitedEntryCol && editingCol instanceof LimitedEntryCol) {
            ((LimitedEntryCol)col).setValue(((LimitedEntryCol)editingCol).getValue());
        }
    }

    private void populateModelColumn(ActionRetractFactCol52 col, ActionRetractFactCol52 editingCol) {
        col.setHeader(editingCol.getHeader());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        if (col instanceof LimitedEntryCol && editingCol instanceof LimitedEntryCol) {
            ((LimitedEntryCol)col).setValue(((LimitedEntryCol)editingCol).getValue());
        }
    }

    private void populateModelColumn(ActionWorkItemCol52 col, ActionWorkItemCol52 editingCol) {
        col.setHeader(editingCol.getHeader());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setWorkItemDefinition(editingCol.getWorkItemDefinition());
    }

    private void populateModelColumn(ActionWorkItemSetFieldCol52 col, ActionWorkItemSetFieldCol52 editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setHideColumn(editingCol.isHideColumn());
        col.setUpdate(editingCol.isUpdate());
        col.setWorkItemName(editingCol.getWorkItemName());
        col.setWorkItemResultParameterName(editingCol.getWorkItemResultParameterName());
        col.setParameterClassName(editingCol.getParameterClassName());
    }

    private void populateModelColumn(LimitedEntryBRLActionColumn col, LimitedEntryBRLActionColumn editingCol) {
        col.setHeader(editingCol.getHeader());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setDefinition(editingCol.getDefinition());
    }

    private void populateModelColumn(ConditionCol52 col, ConditionCol52 editingCol) {
        col.setConstraintValueType(editingCol.getConstraintValueType());
        col.setFactField(editingCol.getFactField());
        col.setFieldType(editingCol.getFieldType());
        col.setHeader(editingCol.getHeader());
        col.setOperator(editingCol.getOperator());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setParameters(editingCol.getParameters());
        col.setBinding(editingCol.getBinding());
        if (col instanceof LimitedEntryCol && editingCol instanceof LimitedEntryCol) {
            ((LimitedEntryCol)col).setValue(((LimitedEntryCol)editingCol).getValue());
        }
    }

    private void populateModelColumn(LimitedEntryBRLConditionColumn col, LimitedEntryBRLConditionColumn editingCol) {
        col.setHeader(editingCol.getHeader());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setDefinition(editingCol.getDefinition());
    }

    private void removeOtherwiseStates(DTColumnConfig52 column) {
        int index = this.model.getExpandedColumns().indexOf(column);
        for (List row : this.model.getData()) {
            DTCellValue52 dcv = (DTCellValue52)row.get(index);
            dcv.setOtherwise(false);
        }
    }

    private void removeCommaSeparatedValues(DTColumnConfig52 column) {
        int index = this.model.getExpandedColumns().indexOf(column);
        if (index >= 0) {
            for (List row : this.model.getData()) {
                DTCellValue52 dcv = (DTCellValue52)row.get(index);
                this.cellUtils.removeCommaSeparatedValue(dcv);
            }
        }
    }

    private boolean updateCellsForOptionValueList(DTColumnConfig52 editColumn, DTColumnConfig52 origColumn) {
        List<String> vals = Arrays.asList(this.utils.getValueList((BaseColumn)editColumn));
        boolean clearExistingValues = vals.size() > 0;
        boolean bUpdateColumnData = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        if (iCol >= 0) {
            for (List row : this.model.getData()) {
                if (!vals.contains(((DTCellValue52)row.get(iCol)).getStringValue())) {
                    bUpdateColumnData = true;
                }
                if (!clearExistingValues) continue;
                ((DTCellValue52)row.get(iCol)).clearValues();
            }
        }
        return bUpdateColumnData;
    }

    private void updateRowNumberColumnValues(BaseColumn column) {
        int rowNumber = 1;
        int iColIndex = this.model.getExpandedColumns().indexOf(column);
        for (List row : this.model.getData()) {
            ((DTCellValue52)row.get(iColIndex)).setNumericValue(Integer.valueOf(rowNumber));
            ++rowNumber;
        }
        UpdateColumnDataEvent uce = new UpdateColumnDataEvent(iColIndex, this.getColumnData(column));
        this.eventBus.fireEvent((GwtEvent)uce);
    }

    private void updateSalienceColumnValues(AttributeCol52 column) {
        int iColIndex = this.model.getExpandedColumns().indexOf(column);
        UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(this.cellFactory.getCell((BaseColumn)column), column.isUseRowNumber(), !column.isUseRowNumber(), iColIndex);
        this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        if (!column.isUseRowNumber()) {
            return;
        }
        if (!column.isReverseOrder()) {
            this.updateRowNumberColumnValues((BaseColumn)column);
        }
        int salience = column.isReverseOrder() ? this.model.getData().size() : 1;
        for (List row : this.model.getData()) {
            ((DTCellValue52)row.get(iColIndex)).setNumericValue(Integer.valueOf(salience));
            if (column.isReverseOrder()) {
                --salience;
                continue;
            }
            ++salience;
        }
        UpdateColumnDataEvent updateColumnData = new UpdateColumnDataEvent(iColIndex, this.getColumnData((BaseColumn)column));
        this.eventBus.fireEvent((GwtEvent)updateColumnData);
    }

    public void movePattern(CompositeColumn<?> pattern, int patternTargetIndex) {
        if (patternTargetIndex < 0 || patternTargetIndex > this.model.getConditions().size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int patternSourceIndex = this.model.getConditions().indexOf(pattern);
        if (patternSourceIndex == patternTargetIndex) {
            return;
        }
        if (patternTargetIndex > patternSourceIndex) {
            CompositeColumn patternBeingMovedAfter = (CompositeColumn)this.model.getConditions().get(patternTargetIndex);
            int sourceColumnIndex = this.model.getExpandedColumns().indexOf(pattern.getChildColumns().get(0));
            int targetColumnIndex = this.model.getExpandedColumns().indexOf(patternBeingMovedAfter.getChildColumns().get(patternBeingMovedAfter.getChildColumns().size() - 1));
            int numberOfColumns = pattern.getChildColumns().size();
            this.model.getConditions().remove(pattern);
            this.model.getConditions().add(patternTargetIndex, pattern);
            MoveColumnsEvent mce = new MoveColumnsEvent(sourceColumnIndex, targetColumnIndex, numberOfColumns);
            this.eventBus.fireEvent((GwtEvent)mce);
        } else {
            CompositeColumn patternBeingMovedBefore = (CompositeColumn)this.model.getConditions().get(patternTargetIndex);
            int sourceColumnIndex = this.model.getExpandedColumns().indexOf(pattern.getChildColumns().get(0));
            int targetColumnIndex = this.model.getExpandedColumns().indexOf(patternBeingMovedBefore.getChildColumns().get(0));
            int numberOfColumns = pattern.getChildColumns().size();
            this.model.getConditions().remove(pattern);
            this.model.getConditions().add(patternTargetIndex, pattern);
            MoveColumnsEvent mce = new MoveColumnsEvent(sourceColumnIndex, targetColumnIndex, numberOfColumns);
            this.eventBus.fireEvent((GwtEvent)mce);
        }
    }

    public void moveCondition(Pattern52 pattern, ConditionCol52 condition, int conditionTargetIndex) {
        if (conditionTargetIndex < 0 || conditionTargetIndex > pattern.getChildColumns().size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int conditionSourceIndex = pattern.getChildColumns().indexOf(condition);
        if (conditionSourceIndex == conditionTargetIndex) {
            return;
        }
        ConditionCol52 conditionTarget = (ConditionCol52)pattern.getChildColumns().get(conditionTargetIndex);
        int conditionTargetColumnIndex = this.model.getExpandedColumns().indexOf(conditionTarget);
        int conditionSourceColumnIndex = this.model.getExpandedColumns().indexOf(condition);
        pattern.getChildColumns().remove(condition);
        pattern.getChildColumns().add(conditionTargetIndex, condition);
        MoveColumnsEvent mce = new MoveColumnsEvent(conditionSourceColumnIndex, conditionTargetColumnIndex, 1);
        this.eventBus.fireEvent((GwtEvent)mce);
    }

    public void moveAction(ActionCol52 action, int actionTargetIndex) {
        if (actionTargetIndex < 0 || actionTargetIndex > this.model.getActionCols().size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int actionSourceIndex = this.model.getActionCols().indexOf(action);
        if (actionSourceIndex == actionTargetIndex) {
            return;
        }
        if (actionTargetIndex > actionSourceIndex) {
            BRLActionVariableColumn variable;
            BRLActionColumn brlColumn;
            ActionCol52 actionBeingMovedAfter = (ActionCol52)this.model.getActionCols().get(actionTargetIndex);
            int sourceColumnIndex = -1;
            int targetColumnIndex = -1;
            int numberOfColumns = -1;
            if (action instanceof BRLActionColumn) {
                brlColumn = (BRLActionColumn)action;
                variable = (BRLActionVariableColumn)brlColumn.getChildColumns().get(0);
                sourceColumnIndex = this.model.getExpandedColumns().indexOf(variable);
                numberOfColumns = brlColumn.getChildColumns().size();
            } else {
                sourceColumnIndex = this.model.getExpandedColumns().indexOf(action);
                numberOfColumns = 1;
            }
            if (actionBeingMovedAfter instanceof BRLActionColumn) {
                brlColumn = (BRLActionColumn)actionBeingMovedAfter;
                variable = (BRLActionVariableColumn)brlColumn.getChildColumns().get(brlColumn.getChildColumns().size() - 1);
                targetColumnIndex = this.model.getExpandedColumns().indexOf(variable);
            } else {
                targetColumnIndex = this.model.getExpandedColumns().indexOf(actionBeingMovedAfter);
            }
            this.model.getActionCols().remove(action);
            this.model.getActionCols().add(actionTargetIndex, action);
            MoveColumnsEvent mce = new MoveColumnsEvent(sourceColumnIndex, targetColumnIndex, numberOfColumns);
            this.eventBus.fireEvent((GwtEvent)mce);
        } else {
            BRLActionVariableColumn variable;
            BRLActionColumn brlColumn;
            ActionCol52 actionBeingMovedBefore = (ActionCol52)this.model.getActionCols().get(actionTargetIndex);
            int sourceColumnIndex = -1;
            int targetColumnIndex = -1;
            int numberOfColumns = -1;
            if (action instanceof BRLActionColumn) {
                brlColumn = (BRLActionColumn)action;
                variable = (BRLActionVariableColumn)brlColumn.getChildColumns().get(0);
                sourceColumnIndex = this.model.getExpandedColumns().indexOf(variable);
                numberOfColumns = brlColumn.getChildColumns().size();
            } else {
                sourceColumnIndex = this.model.getExpandedColumns().indexOf(action);
                numberOfColumns = 1;
            }
            if (actionBeingMovedBefore instanceof BRLActionColumn) {
                brlColumn = (BRLActionColumn)actionBeingMovedBefore;
                variable = (BRLActionVariableColumn)brlColumn.getChildColumns().get(0);
                targetColumnIndex = this.model.getExpandedColumns().indexOf(variable);
            } else {
                targetColumnIndex = this.model.getExpandedColumns().indexOf(actionBeingMovedBefore);
            }
            this.model.getActionCols().remove(action);
            this.model.getActionCols().add(actionTargetIndex, action);
            MoveColumnsEvent mce = new MoveColumnsEvent(sourceColumnIndex, targetColumnIndex, numberOfColumns);
            this.eventBus.fireEvent((GwtEvent)mce);
        }
    }

    public void onDeleteRow(DeleteRowEvent event) {
        this.model.getData().remove(event.getIndex());
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AbstractDecisionTableWidget.this.updateSystemControlledColumnValues();
            }
        });
        this.model.getAuditLog().add((AuditLogEntry)new DeleteRowAuditLogEntry(this.identity.getIdentifier(), event.getIndex()));
    }

    public void onInsertRow(InsertRowEvent event) {
        List<DTCellValue52> data = this.cellValueFactory.makeRowData();
        this.model.getData().add(event.getIndex(), data);
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AbstractDecisionTableWidget.this.updateSystemControlledColumnValues();
            }
        });
        this.model.getAuditLog().add((AuditLogEntry)new InsertRowAuditLogEntry(this.identity.getIdentifier(), event.getIndex()));
    }

    public void onCopyRows(CopyRowsEvent event) {
        this.copiedRows.clear();
        for (Integer iRow : event.getRowIndexes()) {
            this.copiedRows.add((List<DTCellValue52>)this.model.getData().get(iRow));
        }
    }

    public void onPasteRows(PasteRowsEvent event) {
        if (this.copiedRows == null || this.copiedRows.size() == 0) {
            return;
        }
        int iRow = event.getTargetRowIndex();
        for (List<DTCellValue52> sourceRowData : this.copiedRows) {
            List<DTCellValue52> rowData = this.cellValueFactory.makeRowData();
            block14: for (int iCol = 1; iCol < sourceRowData.size(); ++iCol) {
                DTCellValue52 sourceCell = sourceRowData.get(iCol);
                DTCellValue52 targetCell = rowData.get(iCol);
                switch (sourceCell.getDataType()) {
                    case BOOLEAN: {
                        targetCell.setBooleanValue(sourceCell.getBooleanValue());
                        continue block14;
                    }
                    case DATE: {
                        targetCell.setDateValue(sourceCell.getDateValue());
                        continue block14;
                    }
                    case NUMERIC: {
                        targetCell.setNumericValue(sourceCell.getNumericValue());
                        continue block14;
                    }
                    case NUMERIC_BIGDECIMAL: {
                        targetCell.setNumericValue((BigDecimal)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case NUMERIC_BIGINTEGER: {
                        targetCell.setNumericValue((BigInteger)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case NUMERIC_BYTE: {
                        targetCell.setNumericValue((Byte)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case NUMERIC_DOUBLE: {
                        targetCell.setNumericValue((Double)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case NUMERIC_FLOAT: {
                        targetCell.setNumericValue((Float)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case NUMERIC_INTEGER: {
                        targetCell.setNumericValue((Integer)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case NUMERIC_LONG: {
                        targetCell.setNumericValue((Long)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case NUMERIC_SHORT: {
                        targetCell.setNumericValue((Short)sourceCell.getNumericValue());
                        continue block14;
                    }
                    default: {
                        targetCell.setStringValue(sourceCell.getStringValue());
                    }
                }
            }
            this.model.getData().add(iRow, rowData);
            this.model.getAuditLog().add((AuditLogEntry)new InsertRowAuditLogEntry(this.identity.getIdentifier(), iRow));
            ++iRow;
        }
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AbstractDecisionTableWidget.this.updateSystemControlledColumnValues();
            }
        });
    }

    public void onAppendRow(AppendRowEvent event) {
        List<DTCellValue52> data = this.cellValueFactory.makeRowData();
        this.model.getData().add(data);
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AbstractDecisionTableWidget.this.updateSystemControlledColumnValues();
            }
        });
        this.model.getAuditLog().add((AuditLogEntry)new InsertRowAuditLogEntry(this.identity.getIdentifier(), this.model.getData().size() - 1));
    }

    public void onDeleteColumn(DeleteColumnEvent event) {
        int firstColumnIndex = event.getFirstColumnIndex();
        for (int iCol = 0; iCol < event.getNumberOfColumns(); ++iCol) {
            for (List row : this.model.getData()) {
                row.remove(firstColumnIndex);
            }
        }
    }

    public void onInsertColumn(InsertColumnEvent<BaseColumn, DTCellValue52> event) {
        int index = event.getIndex();
        List columnsData = event.getColumnsData();
        for (int iCol = 0; iCol < columnsData.size(); ++iCol) {
            List columnData = (List)columnsData.get(iCol);
            for (int iRow = 0; iRow < columnData.size(); ++iRow) {
                DTCellValue52 dcv = (DTCellValue52)columnData.get(iRow);
                List row = (List)this.model.getData().get(iRow);
                row.add(index, dcv);
            }
            ++index;
        }
    }

    public void onSelectedCellChange(SelectedCellChangeEvent event) {
        if (event.getCellSelectionDetail() == null) {
            this.setEnableOtherwiseButton(false);
        } else {
            Coordinate c = event.getCellSelectionDetail().getCoordinate();
            BaseColumn column = (BaseColumn)this.model.getExpandedColumns().get(c.getCol());
            this.setEnableOtherwiseButton(this.canAcceptOtherwiseValues(column) && !this.isReadOnly);
        }
    }

    protected abstract void setEnableOtherwiseButton(boolean var1);

    public void onMoveColumns(MoveColumnsEvent event) {
        block5: {
            int numberOfColumns;
            int targetColumnIndex;
            int sourceColumnIndex;
            block4: {
                sourceColumnIndex = event.getSourceColumnIndex();
                targetColumnIndex = event.getTargetColumnIndex();
                numberOfColumns = event.getNumberOfColumns();
                if (targetColumnIndex <= sourceColumnIndex) break block4;
                for (int iCol = 0; iCol < numberOfColumns; ++iCol) {
                    for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
                        List row = (List)this.model.getData().get(iRow);
                        row.add(targetColumnIndex, row.remove(sourceColumnIndex));
                    }
                }
                break block5;
            }
            if (targetColumnIndex >= sourceColumnIndex) break block5;
            for (int iCol = 0; iCol < numberOfColumns; ++iCol) {
                for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
                    List row = (List)this.model.getData().get(iRow);
                    row.add(targetColumnIndex, row.remove(sourceColumnIndex));
                }
                ++sourceColumnIndex;
                ++targetColumnIndex;
            }
        }
    }

    public void onUpdateModel(UpdateModelEvent event) {
        boolean updateRowNumber = false;
        boolean updateSalienceAttribute = false;
        Map updates = event.getUpdates();
        for (Map.Entry e : updates.entrySet()) {
            Coordinate originCoordinate = (Coordinate)e.getKey();
            int originRowIndex = originCoordinate.getRow();
            int originColumnIndex = originCoordinate.getCol();
            List data = (List)e.getValue();
            for (int iRow = 0; iRow < data.size(); ++iRow) {
                List rowData = (List)data.get(iRow);
                int targetRowIndex = originRowIndex + iRow;
                for (int iCol = 0; iCol < rowData.size(); ++iCol) {
                    AttributeCol52 attributeCol;
                    int targetColumnIndex = originColumnIndex + iCol;
                    CellValue changedCell = (CellValue)rowData.get(iCol);
                    BaseColumn col = (BaseColumn)this.model.getExpandedColumns().get(targetColumnIndex);
                    DTCellValue52 dcv = this.cellValueFactory.convertToModelCell(col, changedCell);
                    ((List)this.model.getData().get(targetRowIndex)).set(targetColumnIndex, dcv);
                    if (col instanceof RowNumberCol52) {
                        updateRowNumber = true;
                        continue;
                    }
                    if (!(col instanceof AttributeCol52) || !(attributeCol = (AttributeCol52)col).getAttribute().equals("salience")) continue;
                    updateSalienceAttribute = !attributeCol.isUseRowNumber();
                }
            }
        }
        this.eventBus.fireEvent((GwtEvent)new ValidateEvent(event.getUpdates()));
        if (updateRowNumber || updateSalienceAttribute) {
            Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    AbstractDecisionTableWidget.this.updateSystemControlledColumnValues();
                }
            });
        }
    }
}

