/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.event.shared.EventBus;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.utils.GuidedDecisionTableUtils;
import org.drools.workbench.screens.guided.dtable.client.widget.table.DecisionTableDropDownManager;
import org.drools.workbench.screens.guided.dtable.client.widget.table.cells.PopupBoundPatternDropDownEditCell;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.AbstractCellFactory;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.CellTableDropDownDataValueMapProvider;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.DecoratedGridCellValueAdaptor;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.PopupDialectDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.PopupDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.PopupStringValueListDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.PopupTextEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupDateDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericBigDecimalDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericBigIntegerDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericByteDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericDoubleDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericFloatDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericIntegerDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericLongDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericShortDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupTextDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.RowNumberCell;

public class DecisionTableCellFactory
extends AbstractCellFactory<BaseColumn> {
    private GuidedDecisionTableUtils utils;
    private GuidedDecisionTable52 model;

    public DecisionTableCellFactory(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, DecisionTableDropDownManager dropDownManager, boolean isReadOnly, EventBus eventBus) {
        super(oracle, (CellTableDropDownDataValueMapProvider)dropDownManager, isReadOnly, eventBus);
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        if (oracle == null) {
            throw new IllegalArgumentException("oracle cannot be null");
        }
        this.model = model;
        this.utils = new GuidedDecisionTableUtils(model, oracle);
    }

    public DecoratedGridCellValueAdaptor<? extends Comparable<?>> getCell(BaseColumn column) {
        DecoratedGridCellValueAdaptor<? extends Comparable<?>> cell = this.makeTextCell();
        if (column instanceof RowNumberCol52) {
            cell = this.makeRowNumberCell();
        } else if (column instanceof AttributeCol52) {
            AttributeCol52 attrCol = (AttributeCol52)column;
            String attrName = attrCol.getAttribute();
            if (attrName.equals("salience")) {
                cell = attrCol.isUseRowNumber() ? this.makeRowNumberCell() : this.makeNumericIntegerCell();
            } else if (attrName.equals("enabled")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("no-loop")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("duration")) {
                cell = this.makeNumericLongCell();
            } else if (attrName.equals("timer")) {
                cell = this.makeTimerCell();
            } else if (attrName.equals("calendars")) {
                cell = this.makeCalendarsCell();
            } else if (attrName.equals("auto-focus")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("lock-on-active")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("date-effective")) {
                cell = this.makeDateCell();
            } else if (attrName.equals("date-expires")) {
                cell = this.makeDateCell();
            } else if (attrName.equals("dialect")) {
                cell = this.makeDialectCell();
            } else if (attrName.equals("negate")) {
                cell = this.makeBooleanCell();
            }
        } else if (column instanceof LimitedEntryCol) {
            cell = this.makeBooleanCell();
        } else if (column instanceof BRLConditionVariableColumn) {
            cell = this.derieveCellFromCondition((BRLConditionVariableColumn)column);
        } else if (column instanceof ConditionCol52) {
            cell = this.derieveCellFromCondition((ConditionCol52)column);
        } else if (column instanceof ActionWorkItemSetFieldCol52) {
            cell = this.makeBooleanCell();
        } else if (column instanceof ActionWorkItemInsertFactCol52) {
            cell = this.makeBooleanCell();
        } else if (column instanceof ActionSetFieldCol52) {
            cell = this.derieveCellFromAction((ActionSetFieldCol52)column);
        } else if (column instanceof ActionInsertFactCol52) {
            cell = this.derieveCellFromAction((ActionInsertFactCol52)column);
        } else if (column instanceof ActionRetractFactCol52) {
            cell = this.derieveCellFromAction((ActionRetractFactCol52)column);
        } else if (column instanceof ActionWorkItemCol52) {
            cell = this.makeBooleanCell();
        } else if (column instanceof BRLActionVariableColumn) {
            cell = this.derieveCellFromAction((BRLActionVariableColumn)column);
        }
        return cell;
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromCondition(ConditionCol52 col) {
        if (col.getOperator() != null && (col.getOperator().equals("== null") || col.getOperator().equals("!= null"))) {
            return this.makeBooleanCell();
        }
        String factType = this.model.getPattern(col).getFactType();
        String fieldName = col.getFactField();
        String dataType = this.utils.getType((BaseColumn)col);
        if (this.utils.hasValueList(col)) {
            return this.makeValueListCell(col);
        }
        if (this.oracle.hasEnums(factType, fieldName)) {
            if (OperatorsOracle.operatorRequiresList((String)col.getOperator())) {
                return this.makeMultipleSelectEnumCell(factType, fieldName);
            }
            return this.makeSingleSelectionEnumCell(factType, fieldName, dataType);
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromCondition(BRLConditionVariableColumn col) {
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        String dataType = this.utils.getType((BaseColumn)col);
        if (this.oracle.hasEnums(factType, fieldName)) {
            if (OperatorsOracle.operatorRequiresList((String)col.getOperator())) {
                return this.makeMultipleSelectEnumCell(factType, fieldName);
            }
            return this.makeSingleSelectionEnumCell(factType, fieldName, dataType);
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromAction(ActionSetFieldCol52 col) {
        String factType = this.utils.getBoundFactType(col.getBoundName());
        String fieldName = col.getFactField();
        String dataType = this.utils.getType((BaseColumn)col);
        if (this.utils.hasValueList(col)) {
            return this.makeValueListCell((ActionCol52)col);
        }
        if (this.oracle.hasEnums(factType, fieldName)) {
            return this.makeSingleSelectionEnumCell(factType, fieldName, dataType);
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromAction(ActionInsertFactCol52 col) {
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        String dataType = this.utils.getType((BaseColumn)col);
        if (this.utils.hasValueList(col)) {
            return this.makeValueListCell((ActionCol52)col);
        }
        if (this.oracle.hasEnums(factType, fieldName)) {
            return this.makeSingleSelectionEnumCell(factType, fieldName, dataType);
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromAction(ActionRetractFactCol52 col) {
        PopupBoundPatternDropDownEditCell pudd = new PopupBoundPatternDropDownEditCell(this.eventBus, this.isReadOnly);
        BRLRuleModel rm = new BRLRuleModel(this.model);
        pudd.setFactBindings(rm.getLHSBoundFacts());
        return new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromAction(BRLActionVariableColumn col) {
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        String dataType = this.utils.getType((BaseColumn)col);
        if (this.oracle.hasEnums(factType, fieldName)) {
            return this.makeSingleSelectionEnumCell(factType, fieldName, dataType);
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromModel(DTColumnConfig52 col) {
        DecoratedGridCellValueAdaptor cell = this.makeTextCell();
        String type = this.utils.getType((BaseColumn)col);
        if (type.equals("Numeric")) {
            cell = this.makeNumericCell();
        } else if (type.equals("BigDecimal")) {
            cell = this.makeNumericBigDecimalCell();
        } else if (type.equals("BigInteger")) {
            cell = this.makeNumericBigIntegerCell();
        } else if (type.equals("Byte")) {
            cell = this.makeNumericByteCell();
        } else if (type.equals("Double")) {
            cell = this.makeNumericDoubleCell();
        } else if (type.equals("Float")) {
            cell = this.makeNumericFloatCell();
        } else if (type.equals("Integer")) {
            cell = this.makeNumericIntegerCell();
        } else if (type.equals("Long")) {
            cell = this.makeNumericLongCell();
        } else if (type.equals("Short")) {
            cell = this.makeNumericShortCell();
        } else if (type.equals("Boolean")) {
            cell = this.makeBooleanCell();
        } else if (type.equals("Date")) {
            cell = this.makeDateCell();
        }
        return cell;
    }

    private DecoratedGridCellValueAdaptor<String> makeDialectCell() {
        PopupDialectDropDownEditCell pudd = new PopupDialectDropDownEditCell(this.isReadOnly);
        return new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<Integer> makeRowNumberCell() {
        return new DecoratedGridCellValueAdaptor((AbstractCell)new RowNumberCell(), this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<String> makeTimerCell() {
        return new DecoratedGridCellValueAdaptor((AbstractCell)new PopupTextEditCell(this.isReadOnly), this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<String> makeCalendarsCell() {
        return new DecoratedGridCellValueAdaptor((AbstractCell)new PopupTextEditCell(this.isReadOnly), this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> makeValueListCell(ConditionCol52 col) {
        boolean isMultipleSelect = OperatorsOracle.operatorRequiresList((String)col.getOperator());
        PopupStringValueListDropDownEditCell pudd = new PopupStringValueListDropDownEditCell(this.utils.getValueList((BaseColumn)col), isMultipleSelect, this.isReadOnly);
        DecoratedGridCellValueAdaptor cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        return cell;
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> makeValueListCell(ActionCol52 col) {
        PopupStringValueListDropDownEditCell pudd = new PopupStringValueListDropDownEditCell(this.utils.getValueList((BaseColumn)col), this.isReadOnly);
        DecoratedGridCellValueAdaptor cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        return cell;
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> makeMultipleSelectEnumCell(String factType, String fieldName) {
        PopupDropDownEditCell pudd = new PopupDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, true, this.isReadOnly);
        DecoratedGridCellValueAdaptor cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        return cell;
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> makeSingleSelectionEnumCell(String factType, String fieldName, String dataType) {
        DecoratedGridCellValueAdaptor cell;
        if (dataType.equals("Numeric")) {
            ProxyPopupNumericBigDecimalDropDownEditCell pudd = new ProxyPopupNumericBigDecimalDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        } else if (dataType.equals("BigDecimal")) {
            ProxyPopupNumericBigDecimalDropDownEditCell pudd = new ProxyPopupNumericBigDecimalDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        } else if (dataType.equals("BigInteger")) {
            ProxyPopupNumericBigIntegerDropDownEditCell pudd = new ProxyPopupNumericBigIntegerDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        } else if (dataType.equals("Byte")) {
            ProxyPopupNumericByteDropDownEditCell pudd = new ProxyPopupNumericByteDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        } else if (dataType.equals("Double")) {
            ProxyPopupNumericDoubleDropDownEditCell pudd = new ProxyPopupNumericDoubleDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        } else if (dataType.equals("Float")) {
            ProxyPopupNumericFloatDropDownEditCell pudd = new ProxyPopupNumericFloatDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        } else if (dataType.equals("Integer")) {
            ProxyPopupNumericIntegerDropDownEditCell pudd = new ProxyPopupNumericIntegerDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        } else if (dataType.equals("Long")) {
            ProxyPopupNumericLongDropDownEditCell pudd = new ProxyPopupNumericLongDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        } else if (dataType.equals("Short")) {
            ProxyPopupNumericShortDropDownEditCell pudd = new ProxyPopupNumericShortDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        } else if (dataType.equals("Boolean")) {
            cell = this.makeBooleanCell();
        } else if (dataType.equals("Date")) {
            ProxyPopupDateDropDownEditCell pudd = new ProxyPopupDateDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly, this.DATE_FORMAT);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        } else {
            ProxyPopupTextDropDownEditCell pudd = new ProxyPopupTextDropDownEditCell(factType, fieldName, this.oracle, this.dropDownManager, this.isReadOnly);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        }
        return cell;
    }
}

