/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.utils.DTCellValueUtilities;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.AbstractCellValueFactory;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.CellValue;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.DynamicDataRow;

public class DecisionTableCellValueFactory
extends AbstractCellValueFactory<BaseColumn, DTCellValue52> {
    private final GuidedDecisionTable52 model;
    private final DTCellValueUtilities utilities;

    public DecisionTableCellValueFactory(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle) {
        super(oracle);
        this.model = model;
        this.utilities = new DTCellValueUtilities(model, oracle);
    }

    public List<DTCellValue52> makeRowData() {
        ArrayList<DTCellValue52> data = new ArrayList<DTCellValue52>();
        List columns = this.model.getExpandedColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            BaseColumn column = (BaseColumn)columns.get(iCol);
            DTCellValue52 cell = this.makeModelCellValue(column);
            data.add(cell);
        }
        return data;
    }

    public DynamicDataRow makeUIRowData() {
        DynamicDataRow data = new DynamicDataRow();
        List columns = this.model.getExpandedColumns();
        for (BaseColumn column : columns) {
            DTCellValue52 dcv = this.makeModelCellValue(column);
            DataType.DataTypes dataType = this.utilities.getDataType(column);
            this.utilities.assertDTCellValue(dataType, dcv);
            CellValue<? extends Comparable<?>> cell = this.convertModelCellValue(column, dcv);
            data.add(cell);
        }
        return data;
    }

    public List<DTCellValue52> makeColumnData(BaseColumn column) {
        ArrayList<DTCellValue52> data = new ArrayList<DTCellValue52>();
        for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
            DTCellValue52 cell = this.makeModelCellValue(column);
            data.add(cell);
        }
        return data;
    }

    public List<CellValue<? extends Comparable<?>>> convertColumnData(BaseColumn column, List<DTCellValue52> columnData) {
        ArrayList data = new ArrayList();
        for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
            DTCellValue52 dcv = columnData.get(iRow);
            CellValue<? extends Comparable<?>> cell = this.convertModelCellValue(column, dcv);
            data.add(cell);
        }
        return data;
    }

    public DTCellValue52 makeModelCellValue(BaseColumn column) {
        DataType.DataTypes dataType = this.utilities.getDataType(column);
        DTCellValue52 dcv = null;
        dcv = column instanceof LimitedEntryCol ? new DTCellValue52(Boolean.FALSE) : new DTCellValue52(column.getDefaultValue());
        this.utilities.assertDTCellValue(dataType, dcv);
        return dcv;
    }

    public CellValue<? extends Comparable<?>> convertModelCellValue(BaseColumn column, DTCellValue52 dcv) {
        DataType.DataTypes dataType = this.utilities.getDataType(column);
        this.utilities.assertDTCellValue(dataType, dcv);
        CellValue<Long> cell = null;
        switch (dataType) {
            case BOOLEAN: {
                cell = this.makeNewBooleanCellValue(dcv.getBooleanValue());
                break;
            }
            case DATE: {
                cell = this.makeNewDateCellValue(dcv.getDateValue());
                break;
            }
            case NUMERIC: {
                cell = this.makeNewNumericCellValue((BigDecimal)dcv.getNumericValue());
                break;
            }
            case NUMERIC_BIGDECIMAL: {
                cell = this.makeNewBigDecimalCellValue((BigDecimal)dcv.getNumericValue());
                break;
            }
            case NUMERIC_BIGINTEGER: {
                cell = this.makeNewBigIntegerCellValue((BigInteger)dcv.getNumericValue());
                break;
            }
            case NUMERIC_BYTE: {
                cell = this.makeNewByteCellValue((Byte)dcv.getNumericValue());
                break;
            }
            case NUMERIC_DOUBLE: {
                cell = this.makeNewDoubleCellValue((Double)dcv.getNumericValue());
                break;
            }
            case NUMERIC_FLOAT: {
                cell = this.makeNewFloatCellValue((Float)dcv.getNumericValue());
                break;
            }
            case NUMERIC_INTEGER: {
                cell = this.makeNewIntegerCellValue((Integer)dcv.getNumericValue());
                break;
            }
            case NUMERIC_LONG: {
                AttributeCol52 at;
                if (column instanceof RowNumberCol52) {
                    cell = this.makeNewRowNumberCellValue((Long)dcv.getNumericValue());
                    break;
                }
                cell = this.makeNewLongCellValue((Long)dcv.getNumericValue());
                if (!(column instanceof AttributeCol52) || !(at = (AttributeCol52)column).getAttribute().equals("salience") || !at.isUseRowNumber()) break;
                cell = this.makeNewRowNumberCellValue((Long)dcv.getNumericValue());
                break;
            }
            case NUMERIC_SHORT: {
                cell = this.makeNewShortCellValue((Short)dcv.getNumericValue());
                break;
            }
            default: {
                AttributeCol52 ac;
                cell = this.makeNewStringCellValue(dcv.getStringValue());
                if (!(column instanceof AttributeCol52) || !(ac = (AttributeCol52)column).getAttribute().equals("dialect")) break;
                cell = this.makeNewDialectCellValue(dcv.getStringValue());
            }
        }
        if (dcv.isOtherwise()) {
            cell.addState(CellValue.CellState.OTHERWISE);
        }
        return cell;
    }

    public CellValue<Long> makeNewRowNumberCellValue(Long initialValue) {
        CellValue cv = this.makeNewLongCellValue(initialValue);
        if (initialValue != null) {
            cv.setValue((Object)initialValue);
        }
        return cv;
    }

    public DTCellValue52 convertToModelCell(BaseColumn column, CellValue<?> cell) {
        DataType.DataTypes dt = this.utilities.getDataType(column);
        DTCellValue52 dtCell = null;
        switch (dt) {
            case BOOLEAN: {
                dtCell = new DTCellValue52((Boolean)cell.getValue());
                break;
            }
            case DATE: {
                dtCell = new DTCellValue52((Date)cell.getValue());
                break;
            }
            case NUMERIC: {
                dtCell = new DTCellValue52((BigDecimal)cell.getValue());
                break;
            }
            case NUMERIC_BIGDECIMAL: {
                dtCell = new DTCellValue52((BigDecimal)cell.getValue());
                break;
            }
            case NUMERIC_BIGINTEGER: {
                dtCell = new DTCellValue52((BigInteger)cell.getValue());
                break;
            }
            case NUMERIC_BYTE: {
                dtCell = new DTCellValue52((Byte)cell.getValue());
                break;
            }
            case NUMERIC_DOUBLE: {
                dtCell = new DTCellValue52((Double)cell.getValue());
                break;
            }
            case NUMERIC_FLOAT: {
                dtCell = new DTCellValue52((Float)cell.getValue());
                break;
            }
            case NUMERIC_INTEGER: {
                dtCell = new DTCellValue52((Integer)cell.getValue());
                break;
            }
            case NUMERIC_LONG: {
                dtCell = new DTCellValue52((Long)cell.getValue());
                break;
            }
            case NUMERIC_SHORT: {
                dtCell = new DTCellValue52((Short)cell.getValue());
                break;
            }
            default: {
                dtCell = new DTCellValue52((String)((Object)cell.getValue()));
            }
        }
        dtCell.setOtherwise(cell.isOtherwise());
        return dtCell;
    }
}

