/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.pages;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AbstractGuidedDecisionTableWizardPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.ColumnExpansionPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.events.ConditionsDefinedEvent;
import org.uberfire.client.callbacks.Callback;

@Dependent
public class ColumnExpansionPage
extends AbstractGuidedDecisionTableWizardPage
implements ColumnExpansionPageView.Presenter {
    @Inject
    private ColumnExpansionPageView view;
    private List<ConditionCol52> columnsToExpand = null;

    public String getTitle() {
        return GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardColumnExpansion();
    }

    public void initialise() {
        this.view.init(this);
        this.view.setValidator(this.getValidator());
        this.view.setChosenColumns(new ArrayList<ConditionCol52>());
        this.content.setWidget((IsWidget)this.view);
        this.columnsToExpand = null;
    }

    public void prepareView() {
        List<ConditionCol52> availableColumns = this.findAvailableColumnsToExpand();
        this.view.setAvailableColumns(availableColumns);
        this.columnsToExpand = availableColumns;
    }

    private List<ConditionCol52> findAvailableColumnsToExpand() {
        ArrayList<ConditionCol52> availableColumns = new ArrayList<ConditionCol52>();
        for (CompositeColumn cc : this.model.getPatterns()) {
            if (!(cc instanceof Pattern52)) continue;
            Pattern52 p = (Pattern52)cc;
            block5: for (ConditionCol52 c : p.getChildColumns()) {
                switch (this.model.getTableFormat()) {
                    case EXTENDED_ENTRY: {
                        if (this.modelUtils.hasValueList(c)) {
                            String[] values = this.modelUtils.getValueList((BaseColumn)c);
                            if (values == null || values.length <= 1) continue block5;
                            availableColumns.add(c);
                            break;
                        }
                        if (!this.oracle.hasEnums(p.getFactType(), c.getFactField())) break;
                        availableColumns.add(c);
                        break;
                    }
                    case LIMITED_ENTRY: {
                        availableColumns.add(c);
                    }
                }
            }
        }
        return availableColumns;
    }

    public void isComplete(Callback<Boolean> callback) {
        callback.callback((Object)true);
    }

    public void onConditionsDefined(@Observes ConditionsDefinedEvent event) {
        this.view.setAreConditionsDefined(event.getAreConditionsDefined());
    }

    @Override
    public void setColumnsToExpand(List<ConditionCol52> columns) {
        this.columnsToExpand = columns;
    }

    @Override
    public List<ConditionCol52> getColumnsToExpand() {
        if (this.columnsToExpand == null) {
            return this.findAvailableColumnsToExpand();
        }
        return this.columnsToExpand;
    }
}

