/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.AnalyzerProvider;
import org.junit.Before;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertRowEvent;

public abstract class AnalyzerUpdateTestBase {
    protected AnalyzerProvider analyzerProvider;
    protected GuidedDecisionTable52 table52;
    protected DecisionTableAnalyzer analyzer;
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
    }

    protected void fireUpAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = this.analyzerProvider.makeAnalyser(this.table52);
        }
        this.analyzer.analyze(Collections.emptyList());
    }

    protected void removeRow(int rowIndex) {
        this.table52.getData().remove(rowIndex);
        DeleteRowEvent event = new DeleteRowEvent(rowIndex);
        this.analyzer.deleteRow(event.getIndex());
        this.analyzer.updateColumns(this.table52.getData().size());
    }

    protected void removeActionColumn(int columnDataIndex, int columnActionIndex) {
        this.table52.getActionCols().remove(columnActionIndex);
        for (List row : this.table52.getData()) {
            row.remove(columnDataIndex);
        }
        this.analyzer.deleteColumns(columnDataIndex, 1);
    }

    public ValueSetter setCoordinate() {
        return new ValueSetter();
    }

    protected void setValue(int rowIndex, int columnIndex, Number value) {
        ((DTCellValue52)((List)this.table52.getData().get(rowIndex)).get(columnIndex)).setNumericValue(value);
        this.analyzer.analyze(this.getUpdates(rowIndex, columnIndex));
    }

    protected void setValue(int rowIndex, int columnIndex, String value) {
        ((DTCellValue52)((List)this.table52.getData().get(rowIndex)).get(columnIndex)).setStringValue(value);
        this.analyzer.analyze(this.getUpdates(rowIndex, columnIndex));
    }

    protected void appendActionColumn(int columnNumber, ActionSetFieldCol52 actionSetField, Comparable ... cellValues) {
        this.table52.getActionCols().add(actionSetField);
        for (int i = 0; i < cellValues.length; ++i) {
            ((List)this.table52.getData().get(i)).add(new DTCellValue52((Object)cellValues[i]));
        }
        this.analyzer.insertColumn((BaseColumn)this.table52.getExpandedColumns().get(columnNumber));
    }

    protected void insertConditionColumn(int columnNumber, BRLConditionColumn brlConditionColumn, Comparable ... cellValues) {
        this.table52.getConditions().add(brlConditionColumn);
        for (int i = 0; i < cellValues.length; ++i) {
            ((List)this.table52.getData().get(i)).add(new DTCellValue52((Object)cellValues[i]));
        }
        this.analyzer.insertColumn((BaseColumn)this.table52.getExpandedColumns().get(columnNumber));
    }

    protected void insertRow(int rowNumber) {
        this.table52.getData().add(rowNumber, new ArrayList());
        InsertRowEvent event = new InsertRowEvent(rowNumber);
        this.analyzer.insertRow(event.getIndex());
        this.analyzer.updateColumns(this.table52.getData().size());
    }

    protected void appendRow(DataType.DataTypes ... dataTypes) {
        ArrayList<DTCellValue52> row = new ArrayList<DTCellValue52>();
        row.add(new DTCellValue52());
        row.add(new DTCellValue52());
        for (DataType.DataTypes dataType : dataTypes) {
            row.add(new DTCellValue52(dataType, true));
        }
        this.table52.getData().add(row);
        this.analyzer.appendRow();
        this.analyzer.updateColumns(this.table52.getData().size());
    }

    protected ArrayList<Coordinate> getUpdates(int x, int y) {
        ArrayList<Coordinate> updates = new ArrayList<Coordinate>();
        updates.add(new Coordinate(x, y));
        return updates;
    }

    public class ValueSetter {
        public ColumnValueSetter row(int row) {
            return new ColumnValueSetter(row);
        }

        public class ColumnValueSetter {
            private int row;

            public ColumnValueSetter(int row) {
                this.row = row;
            }

            public CellValueSetter column(int column) {
                return new CellValueSetter(column);
            }

            public class CellValueSetter {
                private int column;

                public CellValueSetter(int column) {
                    this.column = column;
                }

                public void toValue(String value) {
                    AnalyzerUpdateTestBase.this.setValue(ColumnValueSetter.this.row, this.column, value);
                }

                public void toValue(Number value) {
                    AnalyzerUpdateTestBase.this.setValue(ColumnValueSetter.this.row, this.column, value);
                }
            }
        }
    }
}

